/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.statistics;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfAnalysisModuleWithStateSystems;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.statistics.ITmfStatistics;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStateStatistics;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsEventTypesModule;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsTotalsModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfStatisticsModule
extends TmfAbstractAnalysisModule
implements ITmfAnalysisModuleWithStateSystems {
    @NonNull
    public static final String ID = "org.eclipse.linuxtools.tmf.core.statistics.analysis";
    private ITmfStatistics fStatistics = null;
    private final TmfStateSystemAnalysisModule totalsModule = new TmfStatisticsTotalsModule();
    private final TmfStateSystemAnalysisModule eventTypesModule = new TmfStatisticsEventTypesModule();
    private final CountDownLatch fInitialized = new CountDownLatch(1);

    @Nullable
    public ITmfStatistics getStatistics() {
        return this.fStatistics;
    }

    public void waitForInitialization() {
        try {
            this.fInitialized.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.totalsModule.dispose();
        this.eventTypesModule.dispose();
    }

    @Override
    public boolean setTrace(ITmfTrace trace) throws TmfAnalysisException {
        if (!super.setTrace(trace)) {
            return false;
        }
        if (!this.totalsModule.setTrace(trace)) {
            return false;
        }
        return this.eventTypesModule.setTrace(trace);
    }

    @Override
    protected boolean executeAnalysis(IProgressMonitor monitor) throws TmfAnalysisException {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            this.fInitialized.countDown();
            return false;
        }
        IStatus status1 = this.totalsModule.schedule();
        IStatus status2 = this.eventTypesModule.schedule();
        if (!status1.isOK() || !status2.isOK()) {
            this.cancelSubAnalyses();
            this.fInitialized.countDown();
            return false;
        }
        this.totalsModule.waitForInitialization();
        this.eventTypesModule.waitForInitialization();
        ITmfStateSystem totalsSS = this.totalsModule.getStateSystem();
        ITmfStateSystem eventTypesSS = this.eventTypesModule.getStateSystem();
        if (totalsSS == null || eventTypesSS == null) {
            this.fInitialized.countDown();
            return false;
        }
        this.fStatistics = new TmfStateStatistics(totalsSS, eventTypesSS);
        this.fInitialized.countDown();
        return this.totalsModule.waitForCompletion(monitor) && this.eventTypesModule.waitForCompletion(monitor);
    }

    @Override
    protected void canceling() {
        this.cancelSubAnalyses();
        ITmfStatistics stats = this.fStatistics;
        if (stats != null) {
            stats.dispose();
        }
    }

    private void cancelSubAnalyses() {
        this.totalsModule.cancel();
        this.eventTypesModule.cancel();
    }

    @Override
    public ITmfStateSystem getStateSystem(String id) {
        switch (id) {
            case "org.eclipse.linuxtools.tmf.statistics.totals": {
                return this.totalsModule.getStateSystem();
            }
            case "org.eclipse.linuxtools.tmf.statistics.types": {
                return this.eventTypesModule.getStateSystem();
            }
        }
        return null;
    }

    @Override
    public Iterable<ITmfStateSystem> getStateSystems() {
        LinkedList<ITmfStateSystem> list = new LinkedList<ITmfStateSystem>();
        list.add(this.totalsModule.getStateSystem());
        list.add(this.eventTypesModule.getStateSystem());
        return list;
    }
}

