/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.statistics;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.statistics.ITmfStatistics;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsModule;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ui.TmfUiRefreshHandler;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfBaseColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfBaseColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsFormatter;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsTree;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsTreeManager;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsTreeNode;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfTreeContentProvider;

@Deprecated
public class TmfStatisticsViewer
extends TmfViewer {
    private static final byte TIME_SCALE = -9;
    private static final long LIVE_UPDATE_DELAY = 1000L;
    private TreeViewer fTreeViewer;
    private TmfStatisticsTree fStatisticsData;
    private final Object fStatisticsRangeUpdateSyncObj = new Object();
    private ITmfTrace fTrace;
    private boolean fProcessAll;
    private static int fCountInstance = 0;
    private int fInstanceNb;
    private Cursor fWaitCursor = null;
    private int fWaitCursorCount = 0;
    private boolean fSendRangeRequest = true;
    private final Map<ITmfTrace, Job> fUpdateJobsPartial = new HashMap<ITmfTrace, Job>();
    private final Map<ITmfTrace, Job> fUpdateJobsGlobal = new HashMap<ITmfTrace, Job>();
    private TmfTimeRange fTimeRange;
    private TmfTimeRange fTimeRangePartial;

    public TmfStatisticsViewer(Composite parent, String viewerName, ITmfTrace trace) {
        this.init(parent, viewerName, trace);
    }

    public void init(Composite parent, String viewerName, ITmfTrace trace) {
        super.init(parent, viewerName);
        this.fInstanceNb = ++fCountInstance;
        this.fTrace = trace;
        this.fProcessAll = trace instanceof TmfExperiment;
        this.initContent(parent);
        this.initInput();
    }

    public void dispose() {
        super.dispose();
        if (this.fWaitCursor != null) {
            this.fWaitCursor.dispose();
        }
        for (Job j : this.fUpdateJobsGlobal.values()) {
            j.cancel();
        }
        for (Job j : this.fUpdateJobsPartial.values()) {
            j.cancel();
        }
        TmfStatisticsTreeManager.removeStatTreeRoot(this.getTreeID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TmfSignalHandler
    public void traceRangeUpdated(TmfTraceRangeUpdatedSignal signal) {
        ITmfTrace trace = signal.getTrace();
        if (!this.isListeningTo(trace)) {
            return;
        }
        Object object = this.fStatisticsRangeUpdateSyncObj;
        synchronized (object) {
            if (this.fSendRangeRequest) {
                this.fSendRangeRequest = false;
                TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
                TmfTimeRange timeRange = ctx.getSelectionRange();
                this.requestTimeRangeData(trace, timeRange);
            }
        }
        this.requestData(trace, signal.getRange());
    }

    @TmfSignalHandler
    public void timeSynchUpdated(TmfSelectionRangeUpdatedSignal signal) {
        if (this.fTrace == null) {
            return;
        }
        ITmfTimestamp begin = signal.getBeginTime();
        ITmfTimestamp end = signal.getEndTime();
        TmfTimeRange timeRange = new TmfTimeRange(begin, end);
        this.requestTimeRangeData(this.fTrace, timeRange);
    }

    @Override
    public Control getControl() {
        return this.fTreeViewer.getControl();
    }

    public Object getInput() {
        return this.fTreeViewer.getInput();
    }

    public TmfStatisticsTree getStatisticData() {
        if (this.fStatisticsData == null) {
            this.fStatisticsData = new TmfStatisticsTree();
        }
        return this.fStatisticsData;
    }

    public String getTreeID() {
        return String.valueOf(this.getName()) + this.fInstanceNb;
    }

    @Override
    public void refresh() {
        final Control viewerControl = this.getControl();
        if (viewerControl.isDisposed()) {
            return;
        }
        TmfUiRefreshHandler.getInstance().queueUpdate(this, new Runnable(){

            @Override
            public void run() {
                if (!viewerControl.isDisposed()) {
                    TmfStatisticsViewer.this.fTreeViewer.refresh();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPartialRequestOnNextUpdate() {
        Object object = this.fStatisticsRangeUpdateSyncObj;
        synchronized (object) {
            this.fSendRangeRequest = true;
        }
    }

    public void setFocus() {
        this.fTreeViewer.getTree().setFocus();
    }

    protected void cancelOngoingRequest(ITmfEventRequest request) {
        if (request != null && !request.isCompleted()) {
            request.cancel();
        }
    }

    protected TmfBaseColumnDataProvider getColumnDataProvider() {
        return new TmfBaseColumnDataProvider();
    }

    protected void initContent(Composite parent) {
        final List<TmfBaseColumnData> columnDataList = this.getColumnDataProvider().getColumnData();
        this.fTreeViewer = new TreeViewer(parent, 2816);
        this.fTreeViewer.setContentProvider((IContentProvider)new TmfTreeContentProvider());
        this.fTreeViewer.getTree().setHeaderVisible(true);
        this.fTreeViewer.setUseHashlookup(true);
        for (final TmfBaseColumnData columnData : columnDataList) {
            final TreeViewerColumn treeColumn = new TreeViewerColumn(this.fTreeViewer, columnData.getAlignment());
            treeColumn.getColumn().setText(columnData.getHeader());
            treeColumn.getColumn().setWidth(columnData.getWidth());
            treeColumn.getColumn().setToolTipText(columnData.getTooltip());
            if (columnData == columnDataList.get(TmfBaseColumnDataProvider.StatsColumn.DUMMY.getIndex())) {
                treeColumn.getColumn().setResizable(false);
            }
            if (columnData.getComparator() != null) {
                treeColumn.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){
                    private ViewerComparator reverseComparator;

                    public void widgetSelected(SelectionEvent e) {
                        if (this.reverseComparator == null) {
                            this.reverseComparator = new ViewerComparator(){

                                public int compare(Viewer viewer, Object e1, Object e2) {
                                    return -1 * columnData.getComparator().compare(viewer, e1, e2);
                                }
                            };
                        }
                        if (TmfStatisticsViewer.this.fTreeViewer.getTree().getSortDirection() == 128 || TmfStatisticsViewer.this.fTreeViewer.getTree().getSortColumn() != treeColumn.getColumn()) {
                            TmfStatisticsViewer.this.fTreeViewer.setComparator(columnData.getComparator());
                            TmfStatisticsViewer.this.fTreeViewer.getTree().setSortDirection(1024);
                        } else {
                            TmfStatisticsViewer.this.fTreeViewer.setComparator(this.reverseComparator);
                            TmfStatisticsViewer.this.fTreeViewer.getTree().setSortDirection(128);
                        }
                        TmfStatisticsViewer.this.fTreeViewer.getTree().setSortColumn(treeColumn.getColumn());
                    }
                });
            }
            treeColumn.setLabelProvider((CellLabelProvider)columnData.getLabelProvider());
        }
        this.fTreeViewer.getTree().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if (((TmfBaseColumnData)columnDataList.get(event.index)).getPercentageProvider() != null) {
                    long eventValue;
                    TmfStatisticsTreeNode node = (TmfStatisticsTreeNode)event.item.getData();
                    if (TmfBaseColumnDataProvider.HIDDEN_FOLDER_LEVELS.contains(node.getName())) {
                        return;
                    }
                    double percentage = ((TmfBaseColumnData)columnDataList.get(event.index)).getPercentageProvider().getPercentage(node);
                    if ((event.detail & 2) > 0) {
                        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
                        event.detail &= 0xFFFFFFFD;
                    }
                    if (event.index != TmfBaseColumnDataProvider.StatsColumn.TOTAL.getIndex() && event.index != TmfBaseColumnDataProvider.StatsColumn.PARTIAL.getIndex() || node == node.getTop()) {
                        return;
                    }
                    long l = eventValue = event.index == TmfBaseColumnDataProvider.StatsColumn.TOTAL.getIndex() ? node.getTop().getValues().getTotal() : node.getTop().getValues().getPartial();
                    if (eventValue != 0L) {
                        int oldAlpha = event.gc.getAlpha();
                        Color oldForeground = event.gc.getForeground();
                        Color oldBackground = event.gc.getBackground();
                        if (percentage != 0.0) {
                            int barWidth = (int)((double)(TmfStatisticsViewer.this.fTreeViewer.getTree().getColumn(event.index).getWidth() - 8) * percentage);
                            event.gc.setAlpha(64);
                            event.gc.setForeground(event.item.getDisplay().getSystemColor(9));
                            event.gc.setBackground(event.item.getDisplay().getSystemColor(25));
                            event.gc.fillGradientRectangle(event.x, event.y, barWidth, event.height, true);
                            event.gc.drawRectangle(event.x, event.y, barWidth, event.height);
                            event.gc.setBackground(oldBackground);
                            event.gc.setAlpha(oldAlpha);
                            event.detail &= 0xFFFFFFF7;
                        }
                        String percentageText = TmfStatisticsFormatter.toPercentageText(percentage);
                        String absoluteNumberText = TmfStatisticsFormatter.toColumnData(node, TmfBaseColumnDataProvider.StatsColumn.getColumn(event.index));
                        if (event.width > event.gc.stringExtent((String)percentageText).x + event.gc.stringExtent((String)absoluteNumberText).x) {
                            int textHeight = event.gc.stringExtent((String)percentageText).y;
                            event.gc.setForeground(event.item.getDisplay().getSystemColor(16));
                            event.gc.drawText(percentageText, event.x, event.y + (event.height - textHeight) / 2, true);
                        }
                        event.gc.setForeground(oldForeground);
                    }
                }
            }
        });
        this.fTreeViewer.setComparator(columnDataList.get(0).getComparator());
        this.fTreeViewer.getTree().setSortColumn(this.fTreeViewer.getTree().getColumn(0));
        this.fTreeViewer.getTree().setSortDirection(1024);
    }

    protected void initInput() {
        TmfStatisticsTreeNode statisticsTreeNode;
        String treeID = this.getTreeID();
        if (TmfStatisticsTreeManager.containsTreeRoot(treeID)) {
            statisticsTreeNode = TmfStatisticsTreeManager.getStatTreeRoot(treeID);
            int numNodeTraces = statisticsTreeNode.getNbChildren();
            Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)this.fTrace);
            int numTraces = traces.size();
            if (numTraces == numNodeTraces) {
                boolean same = true;
                for (ITmfTrace trace : traces) {
                    String traceName = trace.getName();
                    if (statisticsTreeNode.containsChild(traceName)) continue;
                    same = false;
                    break;
                }
                if (same) {
                    this.fTreeViewer.setInput((Object)statisticsTreeNode);
                    return;
                }
                statisticsTreeNode.reset();
            }
        } else {
            statisticsTreeNode = TmfStatisticsTreeManager.addStatsTreeRoot(treeID, this.getStatisticData());
        }
        this.fTreeViewer.setInput((Object)statisticsTreeNode);
    }

    protected boolean isListeningTo(ITmfTrace trace) {
        return this.fProcessAll || trace == this.fTrace;
    }

    protected void modelComplete(boolean global) {
        this.refresh();
        this.waitCursor(false);
    }

    protected void modelIncomplete(boolean isGlobalRequest) {
        if (!isGlobalRequest) {
            this.resetTimeRangeValue();
        }
        this.refresh();
        this.waitCursor(false);
    }

    protected void requestData(ITmfTrace trace, TmfTimeRange timeRange) {
        this.buildStatisticsTree(trace, timeRange, true);
    }

    protected void requestTimeRangeData(ITmfTrace trace, TmfTimeRange timeRange) {
        this.buildStatisticsTree(trace, timeRange, false);
    }

    private void buildStatisticsTree(ITmfTrace trace, TmfTimeRange timeRange, boolean isGlobal) {
        Map<ITmfTrace, Job> updateJobs;
        TmfStatisticsTree statsData = TmfStatisticsTreeManager.getStatTree(this.getTreeID());
        if (statsData == null) {
            return;
        }
        if (isGlobal) {
            updateJobs = this.fUpdateJobsGlobal;
            this.fTimeRange = timeRange;
        } else {
            updateJobs = this.fUpdateJobsPartial;
            this.fTimeRangePartial = timeRange;
        }
        for (ITmfTrace aTrace : TmfTraceManager.getTraceSet((ITmfTrace)trace)) {
            Job job;
            TmfStatisticsModule statsMod;
            if (!this.isListeningTo(aTrace = (ITmfTrace)NonNullUtils.checkNotNull((Object)aTrace)) || (statsMod = (TmfStatisticsModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)aTrace, TmfStatisticsModule.class, (String)"org.eclipse.linuxtools.tmf.core.statistics.analysis")) == null || (job = updateJobs.get(aTrace)) != null) continue;
            job = new UpdateJob("Statistics update", aTrace, isGlobal, statsMod);
            updateJobs.put(aTrace, job);
            job.setSystem(true);
            job.schedule();
        }
    }

    protected void resetTimeRangeValue() {
        TmfStatisticsTreeNode treeModelRoot = TmfStatisticsTreeManager.getStatTreeRoot(this.getTreeID());
        if (treeModelRoot != null && treeModelRoot.hasChildren()) {
            treeModelRoot.resetTimeRangeValue();
        }
    }

    protected void waitCursor(final boolean waitRequested) {
        if (this.fTreeViewer == null || this.fTreeViewer.getTree().isDisposed()) {
            return;
        }
        boolean needsUpdate = false;
        Display display = this.fTreeViewer.getControl().getDisplay();
        if (waitRequested) {
            ++this.fWaitCursorCount;
            if (this.fWaitCursor == null) {
                this.fWaitCursor = new Cursor((Device)display, 1);
            }
            if (this.fWaitCursorCount == 1) {
                needsUpdate = true;
            }
        } else if (this.fWaitCursorCount > 0) {
            --this.fWaitCursorCount;
            if (this.fWaitCursorCount == 0) {
                needsUpdate = true;
            }
        }
        if (needsUpdate) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TmfStatisticsViewer.this.fTreeViewer != null && !TmfStatisticsViewer.this.fTreeViewer.getTree().isDisposed()) {
                        Cursor cursor = null;
                        if (waitRequested) {
                            cursor = TmfStatisticsViewer.this.fWaitCursor;
                        }
                        TmfStatisticsViewer.this.fTreeViewer.getControl().setCursor(cursor);
                    }
                }
            });
        }
    }

    private class UpdateJob
    extends Job {
        private final ITmfTrace fJobTrace;
        private final boolean fIsGlobal;
        private final TmfStatisticsModule fStatsMod;

        private UpdateJob(String name, ITmfTrace trace, boolean isGlobal, TmfStatisticsModule statsMod) {
            super(name);
            this.fJobTrace = trace;
            this.fIsGlobal = isGlobal;
            this.fStatsMod = statsMod;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.fStatsMod.waitForInitialization();
            ITmfStatistics stats = this.fStatsMod.getStatistics();
            if (stats == null) {
                throw new IllegalStateException();
            }
            ITmfStateSystem ss = this.fStatsMod.getStateSystem("org.eclipse.linuxtools.tmf.statistics.types");
            if (ss == null) {
                throw new IllegalStateException();
            }
            long start = 0L;
            long end = 0L;
            boolean finished = false;
            do {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                finished = ss.waitUntilBuilt(1000L);
                TmfTimeRange localtimeRange = this.fIsGlobal ? TmfStatisticsViewer.this.fTimeRange : TmfStatisticsViewer.this.fTimeRangePartial;
                start = localtimeRange.getStartTime().normalize(0L, -9).getValue();
                end = localtimeRange.getEndTime().normalize(0L, -9).getValue();
                Map map = stats.getEventTypesInRange(start, end);
                this.updateStats(map);
            } while (!finished);
            Map map = stats.getEventTypesInRange(start, end);
            this.updateStats(map);
            Map updateJobs = this.fIsGlobal ? TmfStatisticsViewer.this.fUpdateJobsGlobal : TmfStatisticsViewer.this.fUpdateJobsPartial;
            updateJobs.remove(this.fJobTrace);
            return Status.OK_STATUS;
        }

        private void updateStats(Map<String, Long> eventsPerType) {
            TmfStatisticsTree statsData = TmfStatisticsTreeManager.getStatTree(TmfStatisticsViewer.this.getTreeID());
            if (statsData == null) {
                return;
            }
            Map<String, Long> map = eventsPerType;
            String name = this.fJobTrace.getName();
            for (Map.Entry<String, Long> entry : map.entrySet()) {
                statsData.setTypeCount(name, entry.getKey(), this.fIsGlobal, entry.getValue());
            }
            long globalTotal = 0L;
            for (long val : map.values()) {
                globalTotal += val;
            }
            statsData.setTotal(name, this.fIsGlobal, globalTotal);
            TmfStatisticsViewer.this.modelComplete(this.fIsGlobal);
        }
    }
}

