/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelAnalysisModule;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;

public final class KernelThreadInformationProvider {
    private KernelThreadInformationProvider() {
    }

    @Nullable
    public static Integer getThreadOnCpu(KernelAnalysisModule module, long cpuId, long ts) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return null;
        }
        try {
            int cpuQuark = ss.getQuarkAbsolute(new String[]{"CPUs", Long.toString(cpuId), "Current_thread"});
            ITmfStateInterval interval = ss.querySingleState(ts, cpuQuark);
            ITmfStateValue val = interval.getStateValue();
            switch (val.getType()) {
                case INTEGER: {
                    return val.unboxInt();
                }
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        return null;
    }

    public static Collection<Integer> getThreadIds(KernelAnalysisModule module) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return (Collection)NonNullUtils.checkNotNull((Object)Collections.EMPTY_SET);
        }
        try {
            int threadQuark = ss.getQuarkAbsolute(new String[]{"Threads"});
            TreeSet<Integer> tids = new TreeSet<Integer>();
            for (Integer quark : ss.getSubAttributes(threadQuark, false)) {
                tids.add(Integer.parseInt(ss.getAttributeName(quark.intValue())));
            }
            return tids;
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return (Collection)NonNullUtils.checkNotNull((Object)Collections.EMPTY_SET);
        }
    }

    @Nullable
    public static Integer getParentPid(KernelAnalysisModule module, Integer threadId, long ts) {
        Integer ppid = null;
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return ppid;
        }
        try {
            Integer ppidNode = ss.getQuarkAbsolute(new String[]{"Threads", threadId.toString(), "PPID"});
            ITmfStateInterval ppidInterval = ss.querySingleState(ts, ppidNode.intValue());
            ITmfStateValue ppidValue = ppidInterval.getStateValue();
            switch (ppidValue.getType()) {
                case INTEGER: {
                    ppid = (Integer)NonNullUtils.checkNotNull((Object)ppidValue.unboxInt());
                    break;
                }
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        return ppid;
    }

    @Nullable
    public static String getExecutableName(KernelAnalysisModule module, Integer threadId) {
        String execName = null;
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return execName;
        }
        try {
            Integer execNameNode = ss.getQuarkAbsolute(new String[]{"Threads", threadId.toString(), "Exec_name"});
            List execNameIntervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)execNameNode, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
            for (ITmfStateInterval interval : execNameIntervals) {
                ITmfStateValue execNameValue = interval.getStateValue();
                switch (execNameValue.getType()) {
                    case STRING: {
                        execName = (String)NonNullUtils.checkNotNull((Object)execNameValue.unboxStr());
                        break;
                    }
                }
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        return execName;
    }

    @Nullable
    public static Integer getThreadPrio(KernelAnalysisModule module, Integer threadId, long ts) {
        Integer execPrio = null;
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return execPrio;
        }
        try {
            int execPrioQuark = ss.getQuarkAbsolute(new String[]{"Threads", threadId.toString(), "Prio"});
            ITmfStateInterval interval = ss.querySingleState(ts, execPrioQuark);
            ITmfStateValue prioValue = interval.getStateValue();
            execPrio = prioValue.unboxInt();
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        return execPrio;
    }

    public static List<ITmfStateInterval> getStatusIntervalsForThread(KernelAnalysisModule module, Integer threadId, long start, long end, long resolution, IProgressMonitor monitor) {
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return (List)NonNullUtils.checkNotNull((Object)Collections.EMPTY_LIST);
        }
        try {
            int threadQuark = ss.getQuarkAbsolute(new String[]{"Threads", threadId.toString()});
            int statusQuark = ss.getQuarkRelative(threadQuark, new String[]{"Status"});
            List statusIntervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)statusQuark, (long)Math.max(start, ss.getStartTime()), (long)Math.min(end - 1L, ss.getCurrentEndTime()), (long)resolution, (IProgressMonitor)monitor);
            return statusIntervals;
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException throwable) {
            return (List)NonNullUtils.checkNotNull((Object)Collections.EMPTY_LIST);
        }
    }
}

