/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.btf.core.event;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.eclipse.tracecompass.btf.core.Messages;
import org.eclipse.tracecompass.btf.core.event.BTFPayload;
import org.eclipse.tracecompass.btf.core.trace.BtfColumnNames;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;

public class BtfEventType
extends TmfEventType {
    private static final String[] FIELD_WITH_NOTES_COLUMNS = new String[]{BtfColumnNames.EVENT.toString(), BtfColumnNames.SOURCE_INSTANCE.toString(), BtfColumnNames.TARGET_INSTANCE.toString()};
    private static final String[] FIELDS_WITHOUT_NOTES_COLUMNS = new String[]{BtfColumnNames.EVENT.toString(), BtfColumnNames.SOURCE_INSTANCE.toString(), BtfColumnNames.TARGET_INSTANCE.toString(), BtfColumnNames.NOTES.toString()};
    private static final ITmfEventField FIELDS_WITHOUT_NOTES = TmfEventField.makeRoot((String[])FIELD_WITH_NOTES_COLUMNS);
    private static final ITmfEventField FIELDS_WITH_NOTES = TmfEventField.makeRoot((String[])FIELDS_WITHOUT_NOTES_COLUMNS);
    private final String fName;
    private final String fDescription;
    private final boolean fHasNotes;
    private final List<String> fCols;
    private final ITmfEventField fFields;

    public BtfEventType(String name, String description) {
        this.fName = name;
        this.fDescription = description;
        this.fHasNotes = this.fName.equals(Messages.BtfTypeId_SIGName) || this.fName.equals(Messages.BtfTypeId_SEMName);
        this.fCols = ImmutableList.copyOf((Object[])(this.fHasNotes ? FIELDS_WITHOUT_NOTES_COLUMNS : FIELD_WITH_NOTES_COLUMNS));
        this.fFields = this.fHasNotes ? FIELDS_WITH_NOTES : FIELDS_WITHOUT_NOTES;
    }

    public boolean hasNotes() {
        return this.fHasNotes;
    }

    public String getName() {
        return this.fName;
    }

    public Collection<String> getFieldNames() {
        return this.fCols;
    }

    public ITmfEventField getRootField() {
        return this.fFields;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public ITmfEventField generateContent(String event, long sourceInstance, long targetInstance) {
        TmfEventField retField;
        TmfEventField sourceInstanceField = new TmfEventField(BtfColumnNames.SOURCE_INSTANCE.toString(), (Object)sourceInstance, null);
        TmfEventField targetInstanceField = new TmfEventField(BtfColumnNames.TARGET_INSTANCE.toString(), (Object)targetInstance, null);
        if (this.fHasNotes) {
            String[] data = event.split(",", 2);
            TmfEventField eventField = new TmfEventField(BtfColumnNames.EVENT.toString(), (Object)data[0], (ITmfEventField[])BTFPayload.getFieldDescription(data[0]));
            TmfEventField notesField = new TmfEventField(BtfColumnNames.NOTES.toString(), (Object)(data.length == 2 ? data[1] : null), null);
            retField = new TmfEventField(":root:", null, (ITmfEventField[])new TmfEventField[]{eventField, sourceInstanceField, targetInstanceField, notesField});
        } else {
            String[] data = new String[]{event};
            TmfEventField eventField = new TmfEventField(BtfColumnNames.EVENT.toString(), (Object)data[0], (ITmfEventField[])BTFPayload.getFieldDescription(data[0]));
            retField = new TmfEventField(":root:", null, (ITmfEventField[])new TmfEventField[]{eventField, sourceInstanceField, targetInstanceField});
        }
        return retField;
    }
}

