/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTrace;
import org.eclipse.tracecompass.ctf.core.trace.CTFStream;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.Metadata;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class MetadataTest {
    private static final CtfTestTrace testTrace = CtfTestTrace.KERNEL;
    private static final String mdStart = "typealias integer { size = 8; align = 8; signed = false; } := uint8_t;\n    typealias integer { size = 16; align = 8; signed = false; } := uint16_t;\n    typealias integer { size = 32; align = 8; signed = false; } := uint32_t;\n    typealias integer { size = 64; align = 8; signed = false; } := uint64_t;\n    typealias integer { size = 64; align = 8; signed = false; } := unsigned long;\n    typealias integer { size = 5; align = 1; signed = false; } := uint5_t;\n    typealias integer { size = 27; align = 1; signed = false; } := uint27_t;\n    trace {\n        major = 1;\n        minor = 8;\n        uuid = \"8b1258ba-effb-554b-b779-fbd676746000\";\n        byte_order = le;\n        packet.header := struct {\n            uint32_t magic;\n            uint8_t  uuid[16];\n            uint32_t stream_id;\n        };\n    };\n    env {\n        hostname = \"computer\";\n        domain = \"kernel\";\n        sysname = \"BeOS\";\n        kernel_release = \"95\";\n        kernel_version = \"BeWare 95\";\n        tracer_name = \"BeOS Tracer\";\n        tracer_major = 2;\n        tracer_minor = 3;\n        tracer_patchlevel = 0;\n    };\n    clock {\n        name = monotonic;\n        uuid = \"4d737a79-e3f1-4f4d-a649-42015266baf5\";\n        description = \"Monotonic Clock\";\n        freq = 1000000000; /* Frequency, in Hz */\n        /* clock value offset from Epoch is: offset * (1/freq) */\n        offset = 1383600210829415521;\n    };\n    typealias integer {\nsize = 27; align = 1; signed = false;\n        map = clock.monotonic.value;\n    } := uint27_clock_monotonic_t;\n    \n    typealias integer {\n        size = 32; align = 8; signed = false;\n        map = clock.monotonic.value;\n    } := uint32_clock_monotonic_t;\n    \n    typealias integer {\n        size = 64; align = 8; signed = false;\n        map = clock.monotonic.value;\n    } := uint64_clock_monotonic_t;\n    \n    struct packet_context {\n        uint64_clock_monotonic_t timestamp_begin;\n        uint64_clock_monotonic_t timestamp_end;\n        uint64_t content_size;\n        uint64_t packet_size;\n        unsigned long events_discarded;\n        uint32_t cpu_id;\n    };\n    \n    struct event_header_compact {\n        enum : uint5_t { compact = 0 ... 30, extended = 31 } id;\n        variant <id> {\n            struct {\n                uint27_clock_monotonic_t timestamp;\n            } compact;\n            struct {\n                uint32_t id;\n                uint64_clock_monotonic_t timestamp;\n            } extended;\n        } v;\n    } align(8);\n    \n    struct event_header_large {\n        enum : uint16_t { compact = 0 ... 65534, extended = 65535 } id;\n        variant <id> {\n            struct {\n                uint32_clock_monotonic_t timestamp;\n            } compact;\n            struct {\n                uint32_t id;\n                uint64_clock_monotonic_t timestamp;\n            } extended;\n        } v;\n    } align(8);\n    \n    stream {\n        id = 0;\n        event.header := struct event_header_compact;\n        packet.context := struct packet_context;\n    };\n    \n    event {\n        name = sched_switch;\n        id = 0;\n        stream_id = 0;\n        fields := struct {\n            integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _prev_comm[16];\n            integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _prev_tid;\n            integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _prev_prio;\n            integer { size = 64; align = 8; signed = 1; encoding = none; base = 10; } _prev_state;\n            integer { size = 8; align = 8; signed = 1; encoding = UTF8; base = 10; } _next_comm[16];\n            integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _next_tid;\n            integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } _next_prio;\n        };\n    };";
    private static final String mdSecond = "    event {\n        name = bozo_the_clown;\n        id = 1;\n        stream_id = 0;\n        fields := struct {\n            integer { size = 32; align = 8; signed = 1; encoding = none; base = 10; } clown_nose;\n        };\n    };";
    private Metadata fixture;

    @Before
    public void setUp() throws CTFException {
        Assume.assumeTrue((boolean)testTrace.exists());
        this.fixture = new Metadata(testTrace.getTrace());
    }

    @Test
    public void testMetadata() {
        Assert.assertNotNull((Object)this.fixture);
    }

    @Test
    public void testTextMD() throws CTFException {
        this.testSingleFragment();
    }

    protected CTFTrace testSingleFragment() throws CTFException {
        this.fixture = new Metadata();
        CTFTrace trace = this.fixture.getTrace();
        for (CTFStream s : trace.getStreams()) {
            Assert.fail((String)("This should be empty, has" + s.toString()));
        }
        this.fixture.parseText(mdStart);
        int count = 0;
        for (CTFStream s : trace.getStreams()) {
            ++count;
            Assert.assertNotNull((Object)s);
        }
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertEquals((long)1L, (long)trace.getEventDeclarations(Long.valueOf(0L)).size());
        return trace;
    }

    @Test
    public void testStreamTextMD() throws CTFException {
        CTFTrace trace = this.testSingleFragment();
        this.fixture.parseTextFragment(mdSecond);
        ArrayList eventDeclarations = new ArrayList(trace.getEventDeclarations(Long.valueOf(0L)));
        Assert.assertEquals((long)2L, (long)eventDeclarations.size());
        Assert.assertEquals((Object)"bozo_the_clown", (Object)((IEventDeclaration)eventDeclarations.get(1)).getName());
    }

    @Test
    public void testGetDetectedByteOrder() throws CTFException {
        this.setUp();
        ByteOrder result = this.fixture.getDetectedByteOrder();
        Assert.assertNull((Object)result);
    }

    @Test
    public void testToString() throws CTFException {
        this.setUp();
        String result = this.fixture.toString();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testParse() throws CTFException {
        this.setUp();
        Assert.assertEquals((Object)new UUID(-3346628122322547390L, -8182853812207147117L), (Object)testTrace.getTrace().getUUID());
        Assert.assertEquals((double)1.332166405241714E18, (double)testTrace.getTrace().getClock().getClockOffset(), (double)200.0);
        Assert.assertEquals((long)8L, (long)testTrace.getTrace().getEnvironment().size());
    }
}

