/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.tests.io.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EnumDeclarationTest {
    private EnumDeclaration fixture;

    @Before
    public void setUp() {
        this.fixture = new EnumDeclaration(IntegerDeclaration.createDeclaration((int)1, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)8L));
    }

    @Test
    public void testEnumDeclaration() {
        IntegerDeclaration containerType = IntegerDeclaration.createDeclaration((int)1, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)8L);
        EnumDeclaration result = new EnumDeclaration(containerType);
        Assert.assertNotNull((Object)result);
        String left = "[declaration] enum[";
        Assert.assertEquals((Object)left, (Object)result.toString().substring(0, left.length()));
    }

    @Test
    public void testAdd() {
        long low = 1L;
        long high = 1L;
        String label = "";
        boolean result = this.fixture.add(low, high, label);
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testCreateDefinition() throws CTFException {
        IDefinitionScope definitionScope = null;
        String fieldName = "";
        byte[] byArray = new byte[10];
        byArray[0] = 116;
        byArray[1] = 101;
        byArray[2] = 115;
        byArray[3] = 116;
        byArray[5] = 116;
        byArray[6] = 104;
        byArray[7] = 105;
        byArray[8] = 115;
        byte[] array = byArray;
        BitBuffer bb = new BitBuffer(Util.testMemory(ByteBuffer.wrap(array)));
        EnumDefinition result = this.fixture.createDefinition(definitionScope, fieldName, bb);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testQuery() {
        long value = 0L;
        String result = this.fixture.query(value);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testToString() {
        String result = this.fixture.toString();
        String left = "[declaration] enum[";
        Assert.assertEquals((Object)left, (Object)result.substring(0, left.length()));
    }

    @Test
    public void hashcodeTest() {
        EnumDeclaration b = new EnumDeclaration(IntegerDeclaration.createDeclaration((int)1, (boolean)false, (int)1, (ByteOrder)ByteOrder.BIG_ENDIAN, (Encoding)Encoding.ASCII, (String)"", (long)8L));
        Assert.assertEquals((long)b.hashCode(), (long)this.fixture.hashCode());
        this.fixture.add(0L, 1L, "hello");
        this.fixture.add(2L, 3L, "kitty");
        b.add(0L, 1L, "hello");
        b.add(2L, 3L, "kitty");
        Assert.assertEquals((long)this.fixture.hashCode(), (long)b.hashCode());
    }

    @Test
    public void equalsTest() {
        EnumDeclaration a = new EnumDeclaration(IntegerDeclaration.INT_8_DECL);
        EnumDeclaration b = new EnumDeclaration(IntegerDeclaration.INT_8_DECL);
        b.add(2L, 19L, "hi");
        EnumDeclaration c = new EnumDeclaration(IntegerDeclaration.INT_32B_DECL);
        EnumDeclaration d = new EnumDeclaration(IntegerDeclaration.INT_8_DECL);
        Assert.assertNotEquals((Object)a, null);
        Assert.assertNotEquals((Object)a, (Object)new Object());
        Assert.assertNotEquals((Object)a, (Object)b);
        Assert.assertNotEquals((Object)a, (Object)c);
        Assert.assertNotEquals((Object)b, (Object)c);
        Assert.assertEquals((Object)a, (Object)d);
        Assert.assertNotEquals((Object)b, (Object)a);
        Assert.assertNotEquals((Object)c, (Object)a);
        Assert.assertNotEquals((Object)c, (Object)b);
        Assert.assertEquals((Object)d, (Object)a);
        a.add(2L, 19L, "hi");
        Assert.assertEquals((Object)a, (Object)a);
        Assert.assertEquals((Object)a, (Object)b);
        Assert.assertEquals((Object)b, (Object)a);
        Assert.assertNotEquals((Object)a, (Object)d);
        Assert.assertNotEquals((Object)d, (Object)a);
        d.add(2L, 22L, "hi");
        Assert.assertNotEquals((Object)a, (Object)d);
        Assert.assertNotEquals((Object)d, (Object)a);
    }
}

