/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.parser.tests;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.tracecompass.ctf.parser.CTFLexer;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CtfParserTest {
    private CTFParser parser;

    void Matches(TreeMatcher matcher, CommonTree tree) {
        if (tree == null) {
            Assert.fail((String)"Parsing failed!");
        }
        matcher.matches(tree);
    }

    TreeMatcher All() {
        return new TreeMatcher(-1, null, null);
    }

    TreeMatcher Node(int type, TreeMatcher ... child) {
        return new TreeMatcher(type, null, child);
    }

    TreeMatcher Node(int type, String text, TreeMatcher ... child) {
        return new TreeMatcher(type, text, child);
    }

    TreeMatcher List(TreeMatcher ... child) {
        return new TreeMatcher(0, null, child);
    }

    private void setInput(String content) {
        ANTLRStringStream cs = new ANTLRStringStream(content);
        CTFLexer lexer = new CTFLexer((CharStream)cs);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        this.parser = new CTFParser((TokenStream)tokens, false);
    }

    private CommonTree primaryExpression(String content) {
        try {
            this.setInput(content);
            return this.parser.primaryExpression().getTree();
        }
        catch (RecognitionException e) {
            return null;
        }
    }

    private CommonTree unaryExpression(String content) {
        try {
            this.setInput(content);
            return this.parser.unaryExpression().getTree();
        }
        catch (RecognitionException e) {
            return null;
        }
    }

    private CommonTree declaration(String content) {
        try {
            this.setInput(content);
            return this.parser.declaration().getTree();
        }
        catch (RecognitionException e) {
            return null;
        }
    }

    @Test
    public void testPrimaryExpression() {
        CommonTree tree_empty = this.primaryExpression("");
        Assert.assertEquals(null, (Object)tree_empty);
    }

    @Test
    public void testIntegerLiteralPrimaryExpression() {
        this.Matches(this.Node(118, this.Node(21, "123", new TreeMatcher[0])), this.primaryExpression("123"));
        this.Matches(this.Node(119, this.Node(36, "0x123", new TreeMatcher[0])), this.primaryExpression("0x123"));
        this.Matches(this.Node(120, this.Node(54, "0123", new TreeMatcher[0])), this.primaryExpression("0123"));
        this.Matches(this.Node(118, this.Node(21, "123", new TreeMatcher[0]), this.Node(63, "-", new TreeMatcher[0])), this.primaryExpression("-123"));
        this.Matches(this.Node(118, this.Node(21, "123", new TreeMatcher[0]), this.Node(63, "-", new TreeMatcher[0])), this.primaryExpression("  -  123"));
        this.Matches(this.Node(118, this.Node(21, "123", new TreeMatcher[0]), this.Node(63, "-", new TreeMatcher[0]), this.Node(63, "-", new TreeMatcher[0]), this.Node(63, "+", new TreeMatcher[0])), this.primaryExpression(" - -  + 123"));
        this.Matches(this.Node(119, this.Node(36, "0x123", new TreeMatcher[0]), this.Node(63, "+", new TreeMatcher[0]), this.Node(63, "-", new TreeMatcher[0])), this.primaryExpression("+ - 0x123"));
        this.Matches(this.Node(120, this.Node(54, "0123", new TreeMatcher[0]), this.Node(63, "+", new TreeMatcher[0]), this.Node(63, "-", new TreeMatcher[0])), this.primaryExpression("+ - 0123"));
    }

    @Test
    public void testCharacterLiteralPrimaryExpression() {
        this.Matches(this.Node(10, "'a'", new TreeMatcher[0]), this.primaryExpression("'a'"));
        this.Matches(this.Node(10, "'\\n'", new TreeMatcher[0]), this.primaryExpression("'\\n'"));
    }

    @Test
    public void testStringLiteralPrimaryExpression() {
        this.Matches(this.Node(122, this.Node(70, "\"aaa\"", new TreeMatcher[0])), this.primaryExpression("\"aaa\""));
        this.Matches(this.Node(122, this.Node(70, "L\"aaa\"", new TreeMatcher[0])), this.primaryExpression("L\"aaa\""));
        this.Matches(this.Node(122, this.Node(70, "\"aaa\\n\"", new TreeMatcher[0])), this.primaryExpression("\"aaa\\n\""));
    }

    @Test
    public void testKeywordPrimaryExpression() {
        this.Matches(this.Node(121, this.Node(64, "signed", new TreeMatcher[0])), this.primaryExpression("signed"));
        this.Matches(this.Node(121, this.Node(4, "align", new TreeMatcher[0])), this.primaryExpression("align"));
    }

    @Test
    public void testIdentifierPrimaryExpression() {
        this.Matches(this.Node(121, this.Node(38, "x", new TreeMatcher[0])), this.primaryExpression("x"));
        this.Matches(this.Node(121, this.Node(38, "_123", new TreeMatcher[0])), this.primaryExpression("_123"));
    }

    @Test
    public void testUnaryExpression() {
        CommonTree tree_empty = this.unaryExpression("");
        Assert.assertEquals(null, (Object)tree_empty);
    }

    @Test
    public void testSimpleUnaryExpression() {
        this.Matches(this.Node(118, this.Node(21, "123", new TreeMatcher[0])), this.unaryExpression("123"));
        this.Matches(this.Node(121, this.Node(38, "x", new TreeMatcher[0])), this.unaryExpression("x"));
    }

    @Test
    public void testArrayUnaryExpression() {
        this.Matches(this.List(this.Node(121, this.Node(38, "x", new TreeMatcher[0])), this.Node(57, new TreeMatcher[0]), this.Node(118, this.Node(21, "1", new TreeMatcher[0]))), this.unaryExpression("x[1]"));
        this.Matches(this.List(this.Node(121, this.Node(38, "x", new TreeMatcher[0])), this.Node(57, new TreeMatcher[0]), this.Node(121, this.Node(38, "n", new TreeMatcher[0]))), this.unaryExpression("x[n]"));
        this.Matches(this.List(this.Node(121, this.Node(38, "x", new TreeMatcher[0])), this.Node(57, new TreeMatcher[0]), this.Node(121, this.Node(38, "n", new TreeMatcher[0])), this.Node(57, new TreeMatcher[0]), this.Node(118, this.Node(21, "1", new TreeMatcher[0]))), this.unaryExpression("x[n][1]"));
        this.Matches(this.List(this.Node(121, this.Node(38, "x", new TreeMatcher[0])), this.Node(57, new TreeMatcher[0]), this.Node(121, this.Node(38, "n", new TreeMatcher[0])), this.Node(57, new TreeMatcher[0]), this.Node(118, this.Node(21, "1", new TreeMatcher[0]), this.Node(63, "+", new TreeMatcher[0]))), this.unaryExpression("x[n][+1]"));
    }

    @Test
    public void testSpecialArrayUnaryExpression() {
        this.Matches(this.List(this.Node(110, new TreeMatcher[0]), this.Node(57, new TreeMatcher[0]), this.Node(121, this.Node(38, "n", new TreeMatcher[0]))), this.unaryExpression("trace[n]"));
        this.Matches(this.List(this.Node(84, new TreeMatcher[0]), this.Node(57, new TreeMatcher[0]), this.Node(121, this.Node(38, "n", new TreeMatcher[0])), this.Node(57, new TreeMatcher[0]), this.Node(118, this.Node(21, "1", new TreeMatcher[0]))), this.unaryExpression("clock[n][1]"));
    }

    @Test
    public void testMemberUnaryExpression() {
        this.Matches(this.List(this.Node(121, this.Node(38, "x", new TreeMatcher[0])), this.Node(23, this.Node(121, this.Node(38, "y", new TreeMatcher[0])))), this.unaryExpression("x.y"));
        this.Matches(this.List(this.Node(121, this.Node(38, "x", new TreeMatcher[0])), this.Node(23, this.Node(121, this.Node(38, "y", new TreeMatcher[0]))), this.Node(23, this.Node(121, this.Node(38, "z", new TreeMatcher[0])))), this.unaryExpression("x.y.z"));
    }

    @Test
    public void testPointerUnaryExpression() {
        this.Matches(this.List(this.Node(121, this.Node(38, "x", new TreeMatcher[0])), this.Node(5, this.Node(121, this.Node(38, "y", new TreeMatcher[0])))), this.unaryExpression("x->y"));
        this.Matches(this.List(this.Node(121, this.Node(38, "x", new TreeMatcher[0])), this.Node(5, this.Node(121, this.Node(38, "y", new TreeMatcher[0]))), this.Node(5, this.Node(121, this.Node(38, "z", new TreeMatcher[0])))), this.unaryExpression("x->y->z"));
    }

    @Test
    public void testMixedUnaryExpression() {
        this.Matches(this.List(this.Node(121, this.Node(38, "x", new TreeMatcher[0])), this.Node(57, new TreeMatcher[0]), this.Node(118, this.Node(21, "2", new TreeMatcher[0])), this.Node(5, this.Node(121, this.Node(38, "y", new TreeMatcher[0]))), this.Node(23, this.Node(121, this.Node(38, "z", new TreeMatcher[0]))), this.Node(57, new TreeMatcher[0]), this.Node(118, this.Node(21, "1", new TreeMatcher[0]))), this.unaryExpression("x[2]->y.z[1]"));
    }

    @Test
    public void testDeclaration() {
        CommonTree tree_empty = this.declaration("");
        Assert.assertEquals(null, (Object)tree_empty);
    }

    @Test
    public void testIntegerTypeAliasDeclaration() {
        this.Matches(this.All(), this.declaration("typealias integer { } := int;"));
        this.Matches(this.All(), this.declaration("typealias integer { signed=true; } := int;"));
    }

    @Test
    public void testFloatingTypeAliasDeclaration() {
        this.Matches(this.All(), this.declaration("typealias floating_point { } := float;"));
        this.Matches(this.All(), this.declaration("typealias floating_point { align = 32; } := float;"));
    }

    @Ignore(value="This need a fix to the grammar to support a dummy initial scope. ")
    @Test
    public void testTypedefDeclaration() {
        this.Matches(this.All(), this.declaration("typedef dummy int;"));
        this.Matches(this.All(), this.declaration("typedef integer { } int;"));
    }

    @Test
    public void testEnumDeclaration() {
        this.Matches(this.Node(89, this.Node(117, this.Node(91, this.Node(95, this.Node(38, "name", new TreeMatcher[0])), this.Node(92, this.Node(94, this.Node(121, this.Node(38, "A", new TreeMatcher[0]))))))), this.declaration("enum name { A };"));
        this.Matches(this.Node(89, this.Node(117, this.Node(91, this.Node(95, this.All()), this.Node(93, this.Node(117, this.Node(43, new TreeMatcher[0]))), this.Node(92, this.All())))), this.declaration("enum name : int { A };"));
        this.Matches(this.Node(89, this.Node(117, this.Node(91, this.Node(92, this.All())))), this.declaration("enum { A };"));
        this.Matches(this.Node(89, this.Node(117, this.Node(91, this.Node(93, this.Node(117, this.Node(43, new TreeMatcher[0]))), this.Node(92, this.All())))), this.declaration("enum : int { A };"));
    }

    @Ignore(value="The grammar needs to be fixed.")
    @Test
    public void testDeclaratorOfEnumDeclaration() {
        this.Matches(this.All(), this.declaration("enum { };"));
        this.Matches(this.Node(89, this.Node(117, this.Node(91, this.Node(92, this.Node(94, this.Node(121, this.Node(38, "A", new TreeMatcher[0]))), this.Node(94, this.Node(121, this.Node(38, "B", new TreeMatcher[0])), this.Node(96, this.Node(118, this.Node(21, "2", new TreeMatcher[0])))), this.Node(94, this.Node(121, this.Node(38, "C", new TreeMatcher[0])), this.Node(97, this.Node(118, this.Node(21, "3", new TreeMatcher[0])), this.Node(118, this.Node(21, "5", new TreeMatcher[0])))))))), this.declaration("enum { A, B=2, C=3...5 };"));
        this.Matches(this.Node(89, this.Node(117, this.Node(91, this.Node(92, this.Node(94, this.Node(122, this.Node(70, "\"A\"", new TreeMatcher[0]))), this.Node(94, this.Node(122, this.Node(70, "\"B\"", new TreeMatcher[0])), this.All()))))), this.declaration("enum { \"A\", \"B\"=2 };"));
    }

    @Ignore(value="The grammar need to be fixed to support empty ctf-body.")
    @Test
    public void testEmptyDeclaration() {
        this.Matches(this.All(), this.declaration("env { };"));
        this.Matches(this.All(), this.declaration("trace { };"));
        this.Matches(this.All(), this.declaration("stream { };"));
        this.Matches(this.All(), this.declaration("event { };"));
    }

    @Test
    public void testEnvDeclaration() {
        this.Matches(this.Node(98, this.Node(86, this.Node(87, this.Node(121, this.Node(38, "pid", new TreeMatcher[0]))), this.Node(88, this.Node(121, this.Node(38, "value", new TreeMatcher[0]))))), this.declaration("env { pid = value; };"));
        this.Matches(this.Node(98, this.Node(86, this.All(), this.All()), this.Node(86, this.All(), this.All()), this.Node(86, this.All(), this.All())), this.declaration("env { pid = value; proc_name = \"name\"; x = y;};"));
    }

    @Ignore(value="The grammar need to be fixed.")
    @Test
    public void testTraceDeclaration() {
        this.Matches(this.Node(110, this.Node(86, this.Node(87, this.Node(121, this.Node(38, "major", new TreeMatcher[0]))), this.Node(88, this.Node(118, this.Node(21, "1", new TreeMatcher[0]))))), this.declaration("trace { major = 1; };"));
        this.Matches(this.Node(110, this.Node(85, this.Node(87, this.Node(121, this.Node(38, "packet", new TreeMatcher[0])), this.Node(23, this.Node(121, this.Node(38, "header", new TreeMatcher[0])))), this.Node(88, this.Node(117, this.Node(106, this.Node(108, this.Node(38, "dummy", new TreeMatcher[0]))))))), this.declaration("trace { packet.header := struct dummy; };"));
        this.Matches(this.Node(110, this.All()), this.declaration("trace { typedef x y; };"));
        this.Matches(this.Node(110, this.Node(86, this.All(), this.All()), this.Node(86, this.All(), this.All()), this.Node(85, this.All(), this.All())), this.declaration("trace { major = 1; minor = 1;packet.header := struct dummy; };"));
    }

    private class TreeMatcher {
        int fType;
        String fText;
        TreeMatcher[] fChild;

        TreeMatcher(int type, String text, TreeMatcher[] child) {
            this.fType = type;
            this.fText = text;
            this.fChild = child;
        }

        void matches(CommonTree tree) {
            if (this.fType == -1) {
                return;
            }
            if (tree.getType() != this.fType) {
                Assert.fail((String)("Type mismatch! expected:" + this.fType + " actual:" + tree.getType()));
            }
            if (this.fText != null && tree.getText().compareTo(this.fText) != 0) {
                Assert.fail((String)("Text mismatch! expected:" + this.fText + " actual:" + tree.getText()));
            }
            if (this.fChild != null) {
                int size = this.fChild.length;
                if (tree.getChildren() == null) {
                    if (size != 0) {
                        Assert.fail((String)("Invalid children!Expect: " + size + "child"));
                    }
                } else {
                    if (tree.getChildren().size() != size) {
                        Assert.fail((String)("Invalid number of childs! expected:" + size + " actual:" + tree.getChildren().size()));
                    }
                    int i = 0;
                    while (i < size) {
                        this.fChild[i].matches((CommonTree)tree.getChild(i));
                        ++i;
                    }
                }
            }
        }
    }
}

