/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.tests.model.impl;

import java.util.LinkedList;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IBaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.IFieldInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BaseEventInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.FieldInfo;
import org.eclipse.tracecompass.lttng2.control.core.tests.model.impl.ModelImplFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseEventInfoTest {
    private IBaseEventInfo fEventInfo1 = null;
    private IBaseEventInfo fEventInfo2 = null;

    @Before
    public void setUp() {
        ModelImplFactory factory = new ModelImplFactory();
        this.fEventInfo1 = factory.getBaseEventInfo1();
        this.fEventInfo2 = factory.getBaseEventInfo2();
    }

    @Test
    public void testBaseEventInfo() {
        BaseEventInfo fixture = new BaseEventInfo("event");
        Assert.assertNotNull((Object)fixture);
        TraceEventType result = fixture.getEventType();
        Assert.assertEquals((Object)"event", (Object)fixture.getName());
        Assert.assertEquals((Object)"unknown", (Object)result.getInName());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.name());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.toString());
        Assert.assertEquals((long)4L, (long)result.ordinal());
        TraceLogLevel level = fixture.getLogLevel();
        Assert.assertEquals((Object)"TRACE_DEBUG", (Object)level.getInName());
        Assert.assertEquals((Object)"TRACE_DEBUG", (Object)level.name());
        Assert.assertEquals((Object)"TRACE_DEBUG", (Object)level.toString());
        Assert.assertEquals((long)14L, (long)level.ordinal());
    }

    @Test
    public void testEventInfoCopy() {
        BaseEventInfo info = new BaseEventInfo((BaseEventInfo)this.fEventInfo1);
        Assert.assertEquals((Object)this.fEventInfo1.getName(), (Object)info.getName());
        Assert.assertEquals((Object)this.fEventInfo1.getEventType(), (Object)info.getEventType());
        Assert.assertEquals((Object)this.fEventInfo1.getLogLevel(), (Object)info.getLogLevel());
        Assert.assertEquals((Object)this.fEventInfo1.getFilterExpression(), (Object)info.getFilterExpression());
        IFieldInfo[] orignalFields = this.fEventInfo1.getFields();
        IFieldInfo[] copiedFields = info.getFields();
        Assert.assertEquals((long)orignalFields.length, (long)copiedFields.length);
        int i = 0;
        while (i < copiedFields.length) {
            Assert.assertEquals((Object)orignalFields[i], (Object)copiedFields[i]);
            ++i;
        }
    }

    @Test
    public void testEventCopy2() {
        try {
            BaseEventInfo info = null;
            new BaseEventInfo(info);
            Assert.fail((String)"null copy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetEventType_1() {
        BaseEventInfo fixture = new BaseEventInfo("event");
        fixture.setEventType("unknown");
        TraceEventType result = fixture.getEventType();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"unknown", (Object)result.getInName());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.name());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.toString());
        Assert.assertEquals((long)4L, (long)result.ordinal());
        fixture.setEventType("");
        result = fixture.getEventType();
        Assert.assertEquals((Object)"unknown", (Object)result.getInName());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.name());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.toString());
        Assert.assertEquals((long)4L, (long)result.ordinal());
        fixture.setEventType("tracepoint");
        result = fixture.getEventType();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"tracepoint", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACEPOINT", (Object)result.name());
        Assert.assertEquals((Object)"TRACEPOINT", (Object)result.toString());
        Assert.assertEquals((long)0L, (long)result.ordinal());
        fixture.setEventType("syscall");
        result = fixture.getEventType();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"syscall", (Object)result.getInName());
        Assert.assertEquals((Object)"SYSCALL", (Object)result.name());
        Assert.assertEquals((Object)"SYSCALL", (Object)result.toString());
        Assert.assertEquals((long)1L, (long)result.ordinal());
        fixture.setEventType("probe");
        result = fixture.getEventType();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"probe", (Object)result.getInName());
        Assert.assertEquals((Object)"PROBE", (Object)result.name());
        Assert.assertEquals((Object)"PROBE", (Object)result.toString());
        Assert.assertEquals((long)2L, (long)result.ordinal());
        fixture.setEventType("function");
        result = fixture.getEventType();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"function", (Object)result.getInName());
        Assert.assertEquals((Object)"FUNCTION", (Object)result.name());
        Assert.assertEquals((Object)"FUNCTION", (Object)result.toString());
        Assert.assertEquals((long)3L, (long)result.ordinal());
    }

    @Test
    public void testSetEventType_2() {
        BaseEventInfo fixture = new BaseEventInfo("event");
        fixture.setEventType(TraceEventType.TRACEPOINT);
        TraceEventType result = fixture.getEventType();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"tracepoint", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACEPOINT", (Object)result.name());
        Assert.assertEquals((Object)"TRACEPOINT", (Object)result.toString());
        Assert.assertEquals((long)0L, (long)result.ordinal());
        fixture.setEventType(TraceEventType.UNKNOWN);
        result = fixture.getEventType();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"unknown", (Object)result.getInName());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.name());
        Assert.assertEquals((Object)"UNKNOWN", (Object)result.toString());
        Assert.assertEquals((long)4L, (long)result.ordinal());
        fixture.setEventType(TraceEventType.SYSCALL);
        result = fixture.getEventType();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"syscall", (Object)result.getInName());
        Assert.assertEquals((Object)"SYSCALL", (Object)result.name());
        Assert.assertEquals((Object)"SYSCALL", (Object)result.toString());
        Assert.assertEquals((long)1L, (long)result.ordinal());
        fixture.setEventType(TraceEventType.PROBE);
        result = fixture.getEventType();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"probe", (Object)result.getInName());
        Assert.assertEquals((Object)"PROBE", (Object)result.name());
        Assert.assertEquals((Object)"PROBE", (Object)result.toString());
        Assert.assertEquals((long)2L, (long)result.ordinal());
        fixture.setEventType(TraceEventType.FUNCTION);
        result = fixture.getEventType();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"function", (Object)result.getInName());
        Assert.assertEquals((Object)"FUNCTION", (Object)result.name());
        Assert.assertEquals((Object)"FUNCTION", (Object)result.toString());
        Assert.assertEquals((long)3L, (long)result.ordinal());
    }

    @Test
    public void testSetLogLevel1() {
        BaseEventInfo fixture = new BaseEventInfo("event");
        fixture.setEventType(TraceEventType.TRACEPOINT);
        fixture.setLogLevel(TraceLogLevel.TRACE_CRIT);
        TraceLogLevel result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_CRIT", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_CRIT", (Object)result.name());
        Assert.assertEquals((Object)"TRACE_CRIT", (Object)result.toString());
        Assert.assertEquals((long)2L, (long)result.ordinal());
        fixture.setLogLevel(TraceLogLevel.TRACE_DEBUG_FUNCTION);
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_DEBUG_FUNCTION", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_DEBUG_FUNCTION", (Object)result.name());
        Assert.assertEquals((Object)"TRACE_DEBUG_FUNCTION", (Object)result.toString());
        Assert.assertEquals((long)12L, (long)result.ordinal());
    }

    @Test
    public void testSetLogLevel2() {
        BaseEventInfo fixture = new BaseEventInfo("event");
        fixture.setEventType(TraceEventType.TRACEPOINT);
        fixture.setLogLevel("TRACE_EMERG");
        TraceLogLevel result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_EMERG", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_EMERG", (Object)result.name());
        Assert.assertEquals((long)0L, (long)result.ordinal());
        fixture.setLogLevel("TRACE_ALERT");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_ALERT", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_ALERT", (Object)result.name());
        Assert.assertEquals((long)1L, (long)result.ordinal());
        fixture.setLogLevel("TRACE_CRIT");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_CRIT", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_CRIT", (Object)result.name());
        Assert.assertEquals((long)2L, (long)result.ordinal());
        fixture.setLogLevel("TRACE_ERR");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_ERR", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_ERR", (Object)result.name());
        Assert.assertEquals((long)3L, (long)result.ordinal());
        fixture.setLogLevel("TRACE_WARNING");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_WARNING", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_WARNING", (Object)result.name());
        Assert.assertEquals((long)4L, (long)result.ordinal());
        fixture.setLogLevel("TRACE_NOTICE");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_NOTICE", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_NOTICE", (Object)result.name());
        Assert.assertEquals((long)5L, (long)result.ordinal());
        fixture.setLogLevel("TRACE_INFO");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_INFO", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_INFO", (Object)result.name());
        Assert.assertEquals((long)6L, (long)result.ordinal());
        fixture.setLogLevel("TRACE_DEBUG_SYSTEM");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_DEBUG_SYSTEM", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_DEBUG_SYSTEM", (Object)result.name());
        Assert.assertEquals((long)7L, (long)result.ordinal());
        fixture.setLogLevel("TRACE_DEBUG_PROGRAM");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_DEBUG_PROGRAM", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_DEBUG_PROGRAM", (Object)result.name());
        Assert.assertEquals((long)8L, (long)result.ordinal());
        fixture.setLogLevel("TRACE_DEBUG_PROCESS");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_DEBUG_PROCESS", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_DEBUG_PROCESS", (Object)result.name());
        Assert.assertEquals((long)9L, (long)result.ordinal());
        fixture.setLogLevel("TRACE_DEBUG_MODULE");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_DEBUG_MODULE", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_DEBUG_MODULE", (Object)result.name());
        Assert.assertEquals((long)10L, (long)result.ordinal());
        fixture.setLogLevel("TRACE_DEBUG_UNIT");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_DEBUG_UNIT", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_DEBUG_UNIT", (Object)result.name());
        Assert.assertEquals((long)11L, (long)result.ordinal());
        fixture.setLogLevel("TRACE_DEBUG_FUNCTION");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_DEBUG_FUNCTION", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_DEBUG_FUNCTION", (Object)result.name());
        Assert.assertEquals((long)12L, (long)result.ordinal());
        fixture.setLogLevel("TRACE_DEBUG_LINE");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_DEBUG_LINE", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_DEBUG_LINE", (Object)result.name());
        Assert.assertEquals((long)13L, (long)result.ordinal());
        fixture.setLogLevel("TRACE_DEBUG");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"TRACE_DEBUG", (Object)result.getInName());
        Assert.assertEquals((Object)"TRACE_DEBUG", (Object)result.name());
        Assert.assertEquals((long)14L, (long)result.ordinal());
        fixture.setLogLevel("LEVEL_UNKNOWN");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)result.getInName());
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)result.name());
        Assert.assertEquals((long)15L, (long)result.ordinal());
        fixture.setLogLevel("garbage");
        result = fixture.getLogLevel();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)result.getInName());
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)result.name());
        Assert.assertEquals((long)15L, (long)result.ordinal());
    }

    @Test
    public void testSetFields() {
        BaseEventInfo info = new BaseEventInfo((BaseEventInfo)this.fEventInfo2);
        info.setFilterExpression("stringfield==test");
        Assert.assertEquals((Object)"stringfield==test", (Object)info.getFilterExpression());
    }

    @Test
    public void testAddField() {
        BaseEventInfo info = new BaseEventInfo((BaseEventInfo)this.fEventInfo2);
        FieldInfo field = new FieldInfo("intfield");
        field.setFieldType("int");
        info.addField((IFieldInfo)field);
        IFieldInfo[] result = info.getFields();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertNotNull((Object)result[0]);
        Assert.assertTrue((boolean)field.equals(result[0]));
    }

    @Test
    public void testFields() {
        BaseEventInfo info = new BaseEventInfo((BaseEventInfo)this.fEventInfo2);
        FieldInfo field1 = new FieldInfo("intfield");
        field1.setFieldType("int");
        FieldInfo field2 = new FieldInfo("stringfield");
        field2.setFieldType("string");
        LinkedList<FieldInfo> fields = new LinkedList<FieldInfo>();
        fields.add(field1);
        fields.add(field2);
        info.setFields(fields);
        IFieldInfo[] result = info.getFields();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.length);
        int i = 0;
        while (i < result.length) {
            Assert.assertNotNull((Object)result[i]);
            Assert.assertTrue((boolean)((IFieldInfo)fields.get(i)).equals(result[i]));
            ++i;
        }
    }

    @Test
    public void testToString_1() {
        BaseEventInfo fixture = new BaseEventInfo("event");
        fixture.setName("testName");
        fixture.setEventType(TraceEventType.TRACEPOINT);
        fixture.setLogLevel(TraceLogLevel.TRACE_ERR);
        String result = fixture.toString();
        Assert.assertEquals((Object)"[BaseEventInfo([TraceInfo(Name=testName)],type=TRACEPOINT,level=TRACE_ERR)]", (Object)result);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fEventInfo1.equals(this.fEventInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fEventInfo2.equals(this.fEventInfo2));
        Assert.assertTrue((String)"equals", (!this.fEventInfo1.equals(this.fEventInfo2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fEventInfo2.equals(this.fEventInfo1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        BaseEventInfo info1 = new BaseEventInfo((BaseEventInfo)this.fEventInfo1);
        BaseEventInfo info2 = new BaseEventInfo((BaseEventInfo)this.fEventInfo2);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)this.fEventInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fEventInfo1.equals(info1));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)this.fEventInfo2));
        Assert.assertTrue((String)"equals", (boolean)this.fEventInfo2.equals(info2));
    }

    @Test
    public void testEqualsTransivity() {
        BaseEventInfo info1 = new BaseEventInfo((BaseEventInfo)this.fEventInfo1);
        BaseEventInfo info2 = new BaseEventInfo((BaseEventInfo)this.fEventInfo1);
        BaseEventInfo info3 = new BaseEventInfo((BaseEventInfo)this.fEventInfo1);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info2));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)info3));
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fEventInfo1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fEventInfo2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        BaseEventInfo info1 = new BaseEventInfo((BaseEventInfo)this.fEventInfo1);
        BaseEventInfo info2 = new BaseEventInfo((BaseEventInfo)this.fEventInfo2);
        Assert.assertTrue((String)"hashCode", (this.fEventInfo1.hashCode() == info1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fEventInfo2.hashCode() == info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fEventInfo1.hashCode() != info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fEventInfo2.hashCode() != info1.hashCode() ? 1 : 0) != 0);
    }
}

