/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.stubs.service;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.shells.LTTngToolsFileShell;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandShell;

public class TestRemoteSystemProxy
extends RemoteSystemProxy {
    private LTTngToolsFileShell fShell = null;
    private String fTestFile = null;
    private String fScenario = null;

    public TestRemoteSystemProxy(IRemoteConnection host) {
        super((IRemoteConnection)NonNullUtils.checkNotNull((Object)host));
    }

    public void connect(IProgressMonitor monitor) throws ExecutionException {
    }

    public void disconnect() {
        this.fShell = null;
    }

    public void dispose() {
    }

    public ICommandShell createCommandShell() {
        LTTngToolsFileShell shell = this.fShell;
        if (shell == null) {
            shell = new LTTngToolsFileShell();
            if (this.fTestFile != null && this.fScenario != null) {
                shell.loadScenarioFile(this.fTestFile);
                shell.setScenario(this.fScenario);
                this.fShell = shell;
            }
            this.fShell = shell;
        }
        return shell;
    }

    public void setTestFile(String testFile) {
        this.fTestFile = testFile;
    }

    public void setScenario(String scenario) {
        this.fScenario = scenario;
        if (this.fShell != null) {
            this.fShell.setScenario(this.fScenario);
        }
    }

    public void setProfileName(String profileName) {
        if (this.fShell != null) {
            this.fShell.setProfileName(profileName);
        }
    }

    public void deleteProfileFile() {
        if (this.fShell != null) {
            this.fShell.deleteProfileFile();
        }
    }

    public boolean isConnected() {
        return true;
    }
}

