/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.stubs.shells;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.remote.core.stubs.shells.TestCommandShell;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandInput;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandOutputListener;
import org.eclipse.tracecompass.tmf.remote.core.shell.ICommandResult;

public class LTTngToolsFileShell
extends TestCommandShell {
    private static final String SCENARIO_KEY = "<SCENARIO>";
    private static final String SCENARIO_END_KEY = "</SCENARIO>";
    private static final String INPUT_KEY = "<COMMAND_INPUT>";
    private static final String INPUT_END_KEY = "</COMMAND_INPUT>";
    private static final String RESULT_KEY = "<COMMAND_RESULT>";
    private static final String OUTPUT_KEY = "<COMMAND_OUTPUT>";
    private static final String OUTPUT_END_KEY = "</COMMAND_OUTPUT>";
    private static final String ERROR_OUTPUT_KEY = "<COMMAND_ERROR_OUTPUT>";
    private static final String ERROR_OUTPUT_END_KEY = "</COMMAND_ERROR_OUTPUT>";
    private static final String COMMENT_KEY = "#.*";
    private static final Pattern LTTNG_LIST_SESSION_PATTERN = Pattern.compile("lttng\\s+list\\s+(.+)");
    private static final String LTTNG_LIST_PROVIDER_PATTERN = "lttng\\s+list\\s+(-u|-k)";
    private static final Pattern LTTNG_LIST_SESSION_MI_PATTERN = Pattern.compile("lttng\\s+--mi xml\\s+list\\s+(.+)");
    private static final String LTTNG_LIST_PROVIDER_MI_PATTERN = "lttng\\s+--mi xml\\s+list\\s+(-u|-k)";
    private static final String LTTNG_USER_HOME_PATTERN = "\\$\\{userhome\\}";
    private static final String USER_HOME = System.getProperty("user.home");
    private static final Pattern LTTNG_SAVE_MI_PATTERN = Pattern.compile("lttng\\s+--mi xml\\s+save\\s+-f");
    private static final String PROFILE_PATH_STRING = String.valueOf(USER_HOME) + '/' + ".lttng" + '/' + "sessions";
    private String fScenariofile;
    private String fScenario;
    private String fProfileName = null;
    private File fProfileFile = null;
    private final Map<String, Map<String, ICommandResult>> fScenarioMap = new HashMap<String, Map<String, ICommandResult>>();
    private final Map<String, Integer> fSessionNameMap = new HashMap<String, Integer>();

    /*
     * Unable to fully structure code
     */
    public synchronized void loadScenarioFile(String scenariofile) {
        this.fScenariofile = scenariofile;
        values = this.fScenarioMap.values();
        for (Map<String, ICommandResult> map : values) {
            map.clear();
        }
        this.fScenarioMap.clear();
        try {
            iterator = null;
            var4_6 = null;
            try {
                fstream = new FileInputStream(this.fScenariofile);
                try {
                    in = new DataInputStream(fstream);
                    try {
                        br = new BufferedReader(new InputStreamReader(in));
                        try {
                            tmpSessionNameMap = new HashMap<String, Integer>();
                            block12: while ((strLine = br.readLine()) != null) {
                                if (LTTngToolsFileShell.isComment(strLine) || !"<SCENARIO>".equals(strLine)) continue;
                                strLine = br.readLine();
                                while (LTTngToolsFileShell.isComment(strLine)) {
                                    strLine = br.readLine();
                                }
                                scenario = strLine;
                                commandMap = new HashMap<String, ICommandResult>();
                                this.fScenarioMap.put(scenario, commandMap);
                                output = null;
                                errorOutput = null;
                                input = null;
                                inOutput = false;
                                inErrorOutput = false;
                                result = 0;
                                tmpSessionNameMap.clear();
                                while ((strLine = br.readLine()) != null) {
                                    if (LTTngToolsFileShell.isComment(strLine)) continue;
                                    if ("</SCENARIO>".equals(strLine)) continue block12;
                                    if ("<COMMAND_INPUT>".equals(strLine)) {
                                        strLine = br.readLine();
                                        while (LTTngToolsFileShell.isComment(strLine)) {
                                            strLine = br.readLine();
                                        }
                                        input = strLine;
                                        input = input.replaceAll("\\$\\{userhome\\}", LTTngToolsFileShell.USER_HOME);
                                        matcher = LTTngToolsFileShell.LTTNG_LIST_SESSION_PATTERN.matcher(strLine);
                                        miMatcher = LTTngToolsFileShell.LTTNG_LIST_SESSION_MI_PATTERN.matcher(strLine);
                                        if (matcher.matches() && !input.matches("lttng\\s+list\\s+(-u|-k)")) {
                                            sessionName = matcher.group(1).trim();
                                            input = String.valueOf(input) + LTTngToolsFileShell.updateSessionMap(tmpSessionNameMap, input, sessionName);
                                            continue;
                                        }
                                        if (!miMatcher.matches() || input.matches("lttng\\s+--mi xml\\s+list\\s+(-u|-k)")) continue;
                                        sessionName = miMatcher.group(1).trim();
                                        input = String.valueOf(input) + LTTngToolsFileShell.updateSessionMap(tmpSessionNameMap, input, sessionName);
                                        continue;
                                    }
                                    if ("</COMMAND_INPUT>".equals(strLine)) {
                                        output = new ArrayList<String>();
                                        errorOutput = new ArrayList<String>();
                                        continue;
                                    }
                                    if ("<COMMAND_RESULT>".equals(strLine)) {
                                        strLine = br.readLine();
                                        while (LTTngToolsFileShell.isComment(strLine)) {
                                            strLine = br.readLine();
                                        }
                                        result = Integer.parseInt(strLine);
                                        continue;
                                    }
                                    if ("</COMMAND_OUTPUT>".equals(strLine)) {
                                        if (output != null && errorOutput != null) {
                                            commandMap.put(input, this.createCommandResult(result, (String[])NonNullUtils.checkNotNull((Object)output.toArray(new String[output.size()])), (String[])NonNullUtils.checkNotNull((Object)errorOutput.toArray(new String[errorOutput.size()]))));
                                        }
                                        inOutput = false;
                                        continue;
                                    }
                                    if ("<COMMAND_OUTPUT>".equals(strLine)) {
                                        inOutput = true;
                                        continue;
                                    }
                                    if ("<COMMAND_ERROR_OUTPUT>".equals(strLine)) {
                                        inErrorOutput = true;
                                        continue;
                                    }
                                    if ("</COMMAND_ERROR_OUTPUT>".equals(strLine)) {
                                        inErrorOutput = false;
                                        continue;
                                    }
                                    if (!inOutput) continue;
                                    while (LTTngToolsFileShell.isComment(strLine)) {
                                        strLine = br.readLine();
                                    }
                                    if (errorOutput != null && inErrorOutput) {
                                        errorOutput.add(strLine);
                                        continue;
                                    }
                                    if (output == null) continue;
                                    output.add(strLine);
                                }
                            }
                        }
                        finally {
                            if (br != null) {
                                br.close();
                            }
                        }
                        ** if (in == null) goto lbl-1000
                    }
                    catch (Throwable var4_7) {
                        if (iterator == null) {
                            iterator = var4_7;
                        } else if (iterator != var4_7) {
                            iterator.addSuppressed(var4_7);
                        }
                        if (in != null) {
                            in.close();
                        }
                        throw iterator;
                    }
lbl-1000:
                    // 1 sources

                    {
                        in.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    ** if (fstream == null) goto lbl-1000
                }
                catch (Throwable var4_8) {
                    if (iterator == null) {
                        iterator = var4_8;
                    } else if (iterator != var4_8) {
                        iterator.addSuppressed(var4_8);
                    }
                    if (fstream != null) {
                        fstream.close();
                    }
                    throw iterator;
                }
lbl-1000:
                // 1 sources

                {
                    fstream.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var4_9) {
                if (iterator == null) {
                    iterator = var4_9;
                } else if (iterator != var4_9) {
                    iterator.addSuppressed(var4_9);
                }
                throw iterator;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String updateSessionMap(Map<String, Integer> tmpSessionNameMap, String input, String sessionName) {
        Integer i = tmpSessionNameMap.get(sessionName);
        i = i != null ? Integer.valueOf(i + 1) : Integer.valueOf(0);
        tmpSessionNameMap.put(sessionName, i);
        return String.valueOf(i);
    }

    public synchronized void setScenario(String scenario) {
        this.fScenario = scenario;
        this.fSessionNameMap.clear();
        if (!this.fScenarioMap.containsKey(this.fScenario)) {
            throw new IllegalArgumentException();
        }
    }

    public synchronized ICommandResult executeCommand(ICommandInput command, IProgressMonitor monitor) throws ExecutionException {
        return this.executeCommand(command, monitor, null);
    }

    public synchronized ICommandResult executeCommand(ICommandInput command, IProgressMonitor monitor, ICommandOutputListener listener) throws ExecutionException {
        String sessionName;
        String commandLine;
        Map commands = (Map)NonNullUtils.checkNotNull(this.fScenarioMap.get(this.fScenario));
        String fullCommand = commandLine = command.toString();
        Matcher matcher = LTTNG_LIST_SESSION_PATTERN.matcher(commandLine);
        Matcher miMatcher = LTTNG_LIST_SESSION_MI_PATTERN.matcher(commandLine);
        if (matcher.matches() && !commandLine.matches(LTTNG_LIST_PROVIDER_PATTERN)) {
            sessionName = matcher.group(1).trim();
            fullCommand = String.valueOf(fullCommand) + LTTngToolsFileShell.updateSessionMap(this.fSessionNameMap, fullCommand, sessionName);
        } else if (miMatcher.matches() && !commandLine.matches(LTTNG_LIST_PROVIDER_MI_PATTERN)) {
            sessionName = miMatcher.group(1).trim();
            fullCommand = String.valueOf(fullCommand) + LTTngToolsFileShell.updateSessionMap(this.fSessionNameMap, fullCommand, sessionName);
        }
        if (commands.containsKey(fullCommand)) {
            Matcher saveMatcher = LTTNG_SAVE_MI_PATTERN.matcher(fullCommand);
            if (this.fProfileName != null && saveMatcher.matches()) {
                try {
                    this.createProfileFile();
                }
                catch (IOException e) {
                    throw new ExecutionException("Profile file can't be created", (Throwable)e);
                }
            }
            return (ICommandResult)NonNullUtils.checkNotNull((Object)((ICommandResult)commands.get(fullCommand)));
        }
        String[] output = new String[]{String.valueOf("Command not found")};
        ICommandResult result = this.createCommandResult(1, output, output);
        return result;
    }

    private static boolean isComment(String line) {
        if (line == null) {
            throw new RuntimeException("line is null");
        }
        return line.matches(COMMENT_KEY);
    }

    private void createProfileFile() throws IOException {
        if (this.fProfileName != null) {
            File path = new File(PROFILE_PATH_STRING);
            if (!path.exists() && !path.mkdirs()) {
                throw new RuntimeException();
            }
            File profileFile = new File(String.valueOf(PROFILE_PATH_STRING) + '/' + this.fProfileName + ".lttng");
            if (!profileFile.exists()) {
                Throwable throwable = null;
                Object var4_5 = null;
                try (PrintWriter writer = new PrintWriter(profileFile);){
                    writer.println("This file is created by JUnit test using " + LTTngToolsFileShell.class.getCanonicalName());
                    writer.println("Can be deleted!");
                    writer.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.fProfileFile = profileFile;
        }
    }

    public void setProfileName(String profileName) {
        this.fProfileName = profileName;
    }

    public void deleteProfileFile() {
        if (this.fProfileFile != null && this.fProfileFile.exists()) {
            this.fProfileFile.delete();
        }
    }
}

