/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.model.component;

import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.service.TestRemoteSystemProxy;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.ControlView;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponentChangedListener;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceControlRoot;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.ILttngControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlServiceMI;
import org.eclipse.tracecompass.lttng2.control.ui.tests.model.component.ListenerValidator;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;

public class TraceControlComponentTest {
    private IRemoteConnection fHost = TmfRemoteConnectionFactory.getLocalConnection();

    @Test
    public void testTraceControlComponent_1() {
        String name = "node";
        TraceControlComponent result = new TraceControlComponent(name);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)name, (Object)result.getName());
        Assert.assertEquals(null, (Object)result.getParent());
        Assert.assertEquals((Object)false, (Object)result.hasChildren());
        Assert.assertEquals(null, (Object)result.getImage());
        Assert.assertEquals(null, (Object)result.getControlService());
        Assert.assertEquals(null, (Object)result.getToolTip());
    }

    @Test
    public void testTraceControlComponent_2() {
        String name = "node";
        TraceControlRoot parent = new TraceControlRoot();
        TraceControlComponent result = new TraceControlComponent(name, (ITraceControlComponent)parent);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)name, (Object)result.getName());
        Assert.assertEquals((Object)false, (Object)result.hasChildren());
        Assert.assertEquals(null, (Object)result.getImage());
        Assert.assertEquals(null, (Object)result.getControlService());
        Assert.assertEquals(null, (Object)result.getToolTip());
    }

    @Test
    public void testAddAndGetChild1() {
        TraceControlComponent fixture = new TraceControlComponent("node", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("This is the test node");
        fixture.addChild((ITraceControlComponent)new TraceControlRoot());
        TraceControlRoot component = new TraceControlRoot();
        fixture.addChild((ITraceControlComponent)component);
        ITraceControlComponent child = fixture.getChild("trace_control_root");
        Assert.assertNotNull((Object)child);
        Assert.assertEquals((Object)"trace_control_root", (Object)child.getName());
    }

    @Test
    public void testAddAndGetChild2() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        ITraceControlComponent component = null;
        fixture.addChild(component);
        Assert.assertFalse((boolean)fixture.hasChildren());
    }

    @Test
    public void testAddComponentListener_1() {
        TraceControlComponent fixture = new TraceControlComponent("", null);
        fixture.setToolTip("");
        ListenerValidator validator = new ListenerValidator();
        fixture.addComponentListener((ITraceControlComponentChangedListener)validator);
        TraceControlRoot root = new TraceControlRoot();
        fixture.addChild((ITraceControlComponent)root);
        Assert.assertTrue((boolean)validator.isAddedCalled());
        fixture.removeChild((ITraceControlComponent)root);
        Assert.assertTrue((boolean)validator.isRemovedCalled());
        fixture.fireComponentChanged((ITraceControlComponent)fixture);
        Assert.assertTrue((boolean)validator.isChangedCalled());
    }

    @Test
    public void testContainsChild_1() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        fixture.addChild((ITraceControlComponent)new TraceControlRoot());
        String name = "node";
        boolean result = fixture.containsChild(name);
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testContainsChild_2() {
        TraceControlComponent fixture = new TraceControlComponent("name", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        boolean result = fixture.containsChild("trace_control_root");
        Assert.assertEquals((Object)false, (Object)result);
    }

    @Test
    public void testFireCompenentUpdated() {
        TraceControlRoot parent = new TraceControlRoot();
        TraceControlComponent fixture = new TraceControlComponent("node", (ITraceControlComponent)parent);
        fixture.setToolTip("");
        TraceControlComponent component = new TraceControlComponent("child");
        fixture.addChild((ITraceControlComponent)component);
        ListenerValidator validator = new ListenerValidator();
        fixture.addComponentListener((ITraceControlComponentChangedListener)validator);
        fixture.fireComponentAdded((ITraceControlComponent)parent, (ITraceControlComponent)component);
        Assert.assertTrue((boolean)validator.isAddedCalled());
        Assert.assertEquals((Object)parent.getName(), (Object)validator.getSavedParent().getName());
        Assert.assertEquals((Object)component.getName(), (Object)validator.getSavedChild().getName());
        validator.initialize();
        fixture.fireComponentRemoved((ITraceControlComponent)parent, (ITraceControlComponent)component);
        Assert.assertTrue((boolean)validator.isRemovedCalled());
        Assert.assertEquals((Object)parent.getName(), (Object)validator.getSavedParent().getName());
        Assert.assertEquals((Object)component.getName(), (Object)validator.getSavedChild().getName());
        validator.initialize();
        fixture.fireComponentChanged((ITraceControlComponent)fixture);
        Assert.assertTrue((boolean)validator.isChangedCalled());
        Assert.assertEquals((Object)fixture.getName(), (Object)validator.getSavedComponent().getName());
    }

    @Test
    public void testGetAdapter() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        fixture.addChild((ITraceControlComponent)new TraceControlRoot());
        Class<Object> adapter = Object.class;
        Object result = fixture.getAdapter(adapter);
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testGetChildren_1() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        fixture.addChild((ITraceControlComponent)new TraceControlRoot());
        ITraceControlComponent[] result = fixture.getChildren();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
        Assert.assertNotNull((Object)result[0]);
        Assert.assertEquals((Object)"trace_control_root", (Object)result[0].getName());
        Assert.assertEquals(null, (Object)result[0].getParent());
        Assert.assertEquals((Object)false, (Object)result[0].hasChildren());
        Assert.assertEquals(null, (Object)result[0].getImage());
        Assert.assertEquals(null, (Object)result[0].getControlService());
        Assert.assertEquals(null, (Object)result[0].getToolTip());
    }

    @Test
    public void testGetAndSetControlService_1() throws ExecutionException {
        TraceControlComponent parent = new TraceControlComponent("parent"){
            ILttngControlService fService;
            {
                this.fService = null;
            }

            public void setControlService(ILttngControlService service) {
                this.fService = service;
            }

            public ILttngControlService getControlService() {
                return this.fService;
            }
        };
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)parent);
        parent.addChild((ITraceControlComponent)fixture);
        fixture.setToolTip("");
        TraceControlComponent child = new TraceControlComponent("child", (ITraceControlComponent)fixture);
        fixture.addChild((ITraceControlComponent)child);
        ILttngControlService result = fixture.getControlService();
        Assert.assertEquals(null, (Object)result);
        TestRemoteSystemProxy proxy = new TestRemoteSystemProxy(this.fHost);
        LTTngControlService service = new LTTngControlService(proxy.createCommandShell());
        fixture.setControlService((ILttngControlService)service);
        result = fixture.getControlService();
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)service, (Object)result);
        service = new LTTngControlServiceMI(proxy.createCommandShell(), LTTngControlServiceMI.class.getResource("mi_lttng.xsd"));
        fixture.setControlService((ILttngControlService)service);
        result = fixture.getControlService();
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)service, (Object)result);
        result = fixture.getChildren()[0].getControlService();
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)service, (Object)result);
    }

    @Test
    public void testGetImage_1() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        fixture.addChild((ITraceControlComponent)new TraceControlRoot());
        Image result = fixture.getImage();
        Assert.assertEquals(null, (Object)result);
        fixture.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
        Assert.assertNotNull((Object)fixture.getImage());
    }

    @Test
    public void testHasChildren_1() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        fixture.addChild((ITraceControlComponent)new TraceControlRoot());
        boolean result = fixture.hasChildren();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testHasChildren_2() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        boolean result = fixture.hasChildren();
        Assert.assertFalse((boolean)result);
    }

    @Test
    public void testRemoveAllChildren_2() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        fixture.addChild((ITraceControlComponent)new TraceControlRoot());
        fixture.addChild((ITraceControlComponent)new TraceControlComponent("child"));
        fixture.removeAllChildren();
        Assert.assertFalse((boolean)fixture.hasChildren());
    }

    @Test
    public void testRemoveChild_1() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        TraceControlComponent child = new TraceControlComponent("child", (ITraceControlComponent)fixture);
        fixture.addChild((ITraceControlComponent)child);
        fixture.removeChild((ITraceControlComponent)child);
        Assert.assertFalse((boolean)fixture.hasChildren());
    }

    @Test
    public void testRemoveChild_2() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        fixture.addChild((ITraceControlComponent)new TraceControlRoot());
        ITraceControlComponent component = null;
        fixture.removeChild(component);
        Assert.assertTrue((boolean)fixture.hasChildren());
    }

    @Test
    public void testRemoveComponentListener_1() {
        TraceControlComponent fixture = new TraceControlComponent("", null);
        fixture.setToolTip("");
        ListenerValidator validator = new ListenerValidator();
        fixture.addComponentListener((ITraceControlComponentChangedListener)validator);
        validator.initialize();
        fixture.removeComponentListener((ITraceControlComponentChangedListener)validator);
        TraceControlRoot root = new TraceControlRoot();
        fixture.addChild((ITraceControlComponent)root);
        Assert.assertFalse((boolean)validator.isAddedCalled());
        fixture.removeChild((ITraceControlComponent)root);
        Assert.assertFalse((boolean)validator.isRemovedCalled());
        fixture.fireComponentChanged((ITraceControlComponent)fixture);
        Assert.assertFalse((boolean)validator.isChangedCalled());
    }

    @Test
    public void testRemoveComponentListener_2() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        fixture.addChild((ITraceControlComponent)new TraceControlRoot());
        ControlView listener = new ControlView();
        fixture.removeComponentListener((ITraceControlComponentChangedListener)listener);
    }

    @Test
    public void testGetAndSetChildren() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        LinkedList<TraceControlComponent> children = new LinkedList<TraceControlComponent>();
        children.add(new TraceControlComponent("child1"));
        children.add(new TraceControlComponent("child2"));
        fixture.setChildren(children);
        ITraceControlComponent[] result = fixture.getChildren();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((Object)"child1", (Object)result[0].getName());
        Assert.assertEquals((Object)"child2", (Object)result[1].getName());
    }

    @Test
    public void testGetAndSetName() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        fixture.addChild((ITraceControlComponent)new TraceControlRoot());
        String name = "node";
        fixture.setName(name);
        Assert.assertEquals((Object)name, (Object)fixture.getName());
    }

    @Test
    public void testGetAndSetParent() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("");
        fixture.addChild((ITraceControlComponent)new TraceControlRoot());
        TraceControlRoot parent = new TraceControlRoot();
        parent.addChild((ITraceControlComponent)fixture);
        fixture.setParent((ITraceControlComponent)parent);
        ITraceControlComponent retrievedParent = fixture.getParent();
        Assert.assertNotNull((Object)retrievedParent);
        Assert.assertEquals((Object)parent.getName(), (Object)retrievedParent.getName());
        Assert.assertEquals((Object)"trace_control_root", (Object)retrievedParent.getName());
        Assert.assertEquals(null, (Object)retrievedParent.getParent());
        Assert.assertEquals((Object)true, (Object)retrievedParent.hasChildren());
    }

    @Test
    public void testGetAndSetTargetNodeState_1() {
        TraceControlComponent parent = new TraceControlComponent("parent"){
            private TargetNodeState fState;

            public void setTargetNodeState(TargetNodeState state) {
                this.fState = state;
            }

            public TargetNodeState getTargetNodeState() {
                return this.fState;
            }
        };
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)parent);
        parent.addChild((ITraceControlComponent)fixture);
        fixture.setToolTip("");
        TargetNodeState state = TargetNodeState.CONNECTED;
        fixture.setTargetNodeState(state);
        TargetNodeState result = fixture.getTargetNodeState();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)state, (Object)result);
        Assert.assertEquals((Object)state, (Object)fixture.getParent().getTargetNodeState());
        Assert.assertEquals((Object)"CONNECTED", (Object)result.name());
        Assert.assertEquals((Object)"CONNECTED", (Object)result.toString());
        Assert.assertEquals((long)2L, (long)result.ordinal());
        fixture.setTargetNodeState(TargetNodeState.DISCONNECTED);
        result = fixture.getTargetNodeState();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"DISCONNECTED", (Object)result.name());
        Assert.assertEquals((Object)"DISCONNECTED", (Object)result.toString());
        Assert.assertEquals((long)0L, (long)result.ordinal());
        state = TargetNodeState.CONNECTING;
        fixture.setTargetNodeState(state);
        result = fixture.getTargetNodeState();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"CONNECTING", (Object)result.name());
        Assert.assertEquals((Object)"CONNECTING", (Object)result.toString());
        Assert.assertEquals((long)3L, (long)result.ordinal());
        fixture.setTargetNodeState(TargetNodeState.DISCONNECTING);
        result = fixture.getTargetNodeState();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"DISCONNECTING", (Object)result.name());
        Assert.assertEquals((Object)"DISCONNECTING", (Object)result.toString());
        Assert.assertEquals((long)1L, (long)result.ordinal());
    }

    @Test
    public void testGetSndSetToolTip() {
        TraceControlComponent fixture = new TraceControlComponent("", (ITraceControlComponent)new TraceControlRoot());
        fixture.setToolTip("This is a tooltip");
        fixture.addChild((ITraceControlComponent)new TraceControlRoot());
        String result = fixture.getToolTip();
        Assert.assertEquals((Object)"This is a tooltip", (Object)result);
    }
}

