/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.model.component;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.CreateSessionDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.DestroyConfirmDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.dialogs.GetEventInfoDialogStub;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.service.TestRemoteSystemProxy;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IConfirmDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.ICreateSessionDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IGetEventInfoDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.property.TraceSessionPropertySource;
import org.eclipse.tracecompass.lttng2.control.ui.tests.model.component.TraceControlTestFacility;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TraceControlSnapshotSessionTests {
    private static final String TEST_STREAM = "CreateSessionTest2.cfg";
    private static final String SCEN_CREATE_SESSION = "ScenCreateSession";
    private TraceControlTestFacility fFacility;
    private IRemoteConnection fHost = TmfRemoteConnectionFactory.getLocalConnection();
    @NonNull
    private TestRemoteSystemProxy fProxy = new TestRemoteSystemProxy(this.fHost);
    private String fTestFile;

    @Before
    public void setUp() throws Exception {
        this.fFacility = TraceControlTestFacility.getInstance();
        this.fFacility.init();
        this.fProxy = new TestRemoteSystemProxy(this.fHost);
        URL location = FileLocator.find((Bundle)FrameworkUtil.getBundle(this.getClass()), (IPath)new Path("testfiles" + File.separator + TEST_STREAM), null);
        File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
        this.fTestFile = testfile.getAbsolutePath();
    }

    @After
    public void tearDown() {
        this.fFacility.waitForJobs();
        this.fFacility.dispose();
    }

    @Test
    public void testTraceSessionTree() throws Exception {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario("Initialize");
        ITraceControlComponent root = this.fFacility.getControlView().getTraceControlRoot();
        TargetNodeComponent node = new TargetNodeComponent("myNode", root, (RemoteSystemProxy)this.fProxy);
        root.addChild((ITraceControlComponent)node);
        this.fFacility.waitForJobs();
        this.fFacility.executeCommand((ITraceControlComponent)node, "connect");
        int i = 0;
        while (i < 10 && node.getTargetNodeState() != TargetNodeState.CONNECTED) {
            ++i;
            this.fFacility.delay(500L);
        }
        ITraceControlComponent[] groups = node.getChildren();
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)2L, (long)groups.length);
        CreateSessionDialogStub sessionDialog = new CreateSessionDialogStub();
        sessionDialog.setSnapshot(true);
        TraceControlDialogFactory.getInstance().setCreateSessionDialog((ICreateSessionDialog)sessionDialog);
        TraceControlDialogFactory.getInstance().setGetEventInfoDialog((IGetEventInfoDialog)new GetEventInfoDialogStub());
        TraceControlDialogFactory.getInstance().setConfirmDialog((IConfirmDialog)new DestroyConfirmDialogStub());
        this.fProxy.setScenario(SCEN_CREATE_SESSION);
        TraceSessionComponent session = this.fFacility.createSession(groups[1]);
        Assert.assertNotNull((Object)session);
        Assert.assertEquals((Object)"mysession", (Object)session.getName());
        Assert.assertTrue((boolean)session.isSnapshotSession());
        Assert.assertNotNull((Object)session.getSnapshotInfo());
        Assert.assertEquals((Object)"snapshot-1", (Object)session.getSnapshotInfo().getName());
        Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20130913-141651", (Object)session.getSnapshotInfo().getSnapshotPath());
        Assert.assertEquals((long)1L, (long)session.getSnapshotInfo().getId());
        this.fFacility.startSession(session);
        Assert.assertEquals((Object)TraceSessionState.ACTIVE, (Object)session.getSessionState());
        Object adapter = session.getAdapter(IPropertySource.class);
        Assert.assertNotNull((Object)adapter);
        Assert.assertTrue((boolean)(adapter instanceof TraceSessionPropertySource));
        TraceSessionPropertySource sessionSource = (TraceSessionPropertySource)adapter;
        IPropertyDescriptor[] descriptors = sessionSource.getPropertyDescriptors();
        Assert.assertNotNull((Object)descriptors);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("trace.session.name", "mysession");
        map.put("trace.snapshot.name", "snapshot-1");
        map.put("trace.snapshot.path", "/home/user/lttng-traces/mysession-20130913-141651");
        map.put("trace.snapshot.id", "1");
        map.put("trace.session.state", TraceSessionState.ACTIVE.name());
        int j = 0;
        while (j < descriptors.length) {
            String expected = (String)map.get(descriptors[j].getId());
            Assert.assertNotNull((Object)expected);
            Assert.assertEquals((Object)expected, (Object)sessionSource.getPropertyValue(descriptors[j].getId()).toString());
            ++j;
        }
        this.fFacility.executeCommand((ITraceControlComponent)session, "snapshot");
        this.fFacility.stopSession(session);
        Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
        this.fFacility.executeCommand((ITraceControlComponent)session, "snapshot");
        this.fFacility.destroySession(session);
        Assert.assertEquals((long)0L, (long)groups[1].getChildren().length);
        this.fFacility.executeCommand((ITraceControlComponent)node, "disconnect");
        Assert.assertEquals((Object)TargetNodeState.DISCONNECTED, (Object)node.getTargetNodeState());
        this.fFacility.executeCommand((ITraceControlComponent)node, "delete");
        Assert.assertEquals((long)0L, (long)this.fFacility.getControlView().getTraceControlRoot().getChildren().length);
    }
}

