/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.model.component;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.ControlView;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.junit.Assert;

public class TraceControlTestFacility {
    public static final int WAIT_FOR_JOBS_DELAY = 50;
    public static final int GUI_REFESH_DELAY = 500;
    public static final String DIRECTORY = "testfiles";
    public static final String COMMAND_CATEGORY_PREFIX = "org.eclipse.linuxtools.internal.lttng2.ui.commands.control.";
    public static final String SCEN_INIT_TEST = "Initialize";
    public static final String SCEN_SCENARIO_SESSION_HANDLING = "SessionHandling";
    public static final String SCEN_SCENARIO_SESSION_HANDLING_WITH_PATH = "SessionHandlingWithPath";
    private static TraceControlTestFacility fInstance = null;
    private ControlView fControlView = null;
    private boolean fIsInitialized = false;

    private TraceControlTestFacility() {
    }

    public static TraceControlTestFacility getInstance() {
        if (fInstance == null) {
            fInstance = new TraceControlTestFacility();
        }
        return fInstance;
    }

    public void init() {
        if (!this.fIsInitialized) {
            IViewPart view;
            try {
                view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.ui.internal.introview");
                if (view != null) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView(view);
                }
                view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
            }
            catch (PartInitException e) {
                throw new RuntimeException(e);
            }
            this.fControlView = (ControlView)view;
            this.delay(3000L);
            this.fIsInitialized = true;
        }
    }

    public void dispose() {
        if (this.fIsInitialized) {
            this.waitForJobs();
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)this.fControlView);
            this.fIsInitialized = false;
        }
    }

    public void delay(long waitTimeMillis) {
        Display display = Display.getCurrent();
        if (display != null) {
            long endTimeMillis = System.currentTimeMillis() + waitTimeMillis;
            while (System.currentTimeMillis() < endTimeMillis) {
                if (!display.readAndDispatch()) {
                    try {
                        Thread.sleep(Math.min(waitTimeMillis, 10L));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                display.update();
            }
        } else {
            try {
                Thread.sleep(waitTimeMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void waitForConnect(TargetNodeComponent node) {
        int i = 1;
        while (i < 5000 && node.getTargetNodeState() == TargetNodeState.CONNECTING) {
            try {
                Thread.sleep(i);
            }
            catch (InterruptedException e) {
                Assert.fail();
            }
            i *= 2;
        }
    }

    public void waitForJobs() {
        while (!Job.getJobManager().isIdle()) {
            this.delay(50L);
        }
    }

    public ControlView getControlView() {
        return this.fControlView;
    }

    public void executeCommand(ITraceControlComponent component, String commandId) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.setSelection(component);
        this.executeCommand(commandId);
    }

    public void executeCommand(ITraceControlComponent[] components, String commandId) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.setSelection(components);
        this.executeCommand(commandId);
    }

    public void executeCommand(String commandId) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        Object handlerServiceObject = this.fControlView.getSite().getService(IHandlerService.class);
        IHandlerService handlerService = (IHandlerService)handlerServiceObject;
        handlerService.executeCommand(COMMAND_CATEGORY_PREFIX + commandId, null);
        this.waitForJobs();
    }

    public void setSelection(ITraceControlComponent component) {
        this.fControlView.setSelection(component);
        this.waitForJobs();
    }

    public void setSelection(ITraceControlComponent[] components) {
        this.fControlView.setSelection(components);
        this.waitForJobs();
    }

    public TraceSessionComponent createSession(ITraceControlComponent group) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.executeCommand(group, "createSession");
        ITraceControlComponent[] sessions = group.getChildren();
        if (sessions == null || sessions.length == 0) {
            return null;
        }
        return (TraceSessionComponent)sessions[0];
    }

    public void destroySession(TraceSessionComponent session) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.executeCommand((ITraceControlComponent)session, "destroySession");
    }

    public void startSession(TraceSessionComponent session) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.executeCommand((ITraceControlComponent)session, "start");
    }

    public void stopSession(TraceSessionComponent session) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        this.executeCommand((ITraceControlComponent)session, "stop");
    }
}

