/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel.statesystem;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelAnalysisModule;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;

public class GenerateTestValues {
    private static CtfTmfTestTrace testTrace = CtfTmfTestTrace.TRACE2;
    private static final long targetTimestamp = 1331668248014184527L;
    private static final String INDENT = "    ";
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$tracecompass$statesystem$core$statevalue$ITmfStateValue$Type;

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws Exception {
        if (!GenerateTestValues.testTrace.exists()) {
            System.err.println("Trace files not present.");
            return;
        }
        logFile = File.createTempFile("TestValues", ".java");
        var2_2 = null;
        var3_4 = null;
        try {
            trace = GenerateTestValues.testTrace.getTrace();
            try {
                writer = new PrintWriter((Writer)new FileWriter(logFile), true);
                try {
                    module = new KernelAnalysisModule(){

                        protected String getSsFileName() {
                            return "test-values";
                        }
                    };
                    if (!module.setTrace((ITmfTrace)trace)) {
                        throw new IllegalStateException();
                    }
                    module.setId("test-values");
                    module.schedule();
                    module.waitForCompletion();
                    ssq = module.getStateSystem();
                    if (ssq == null) {
                        throw new IllegalStateException();
                    }
                    fullState = ssq.queryFullState(1331668248014184527L);
                    writer.println("interface TestValues {");
                    writer.println();
                    writer.println("    int size = " + fullState.size() + ";");
                    writer.println();
                    writer.println("    long[] startTimes = {");
                    for (ITmfStateInterval interval : fullState) {
                        writer.println("        " + String.valueOf(interval.getStartTime()) + "L,");
                    }
                    writer.println("    };");
                    writer.println();
                    writer.println("    long[] endTimes = {");
                    for (ITmfStateInterval interval : fullState) {
                        writer.println("        " + String.valueOf(interval.getEndTime()) + "L,");
                    }
                    writer.println("    };");
                    writer.println();
                    writer.println("    ITmfStateValue[] values = {");
                    for (ITmfStateInterval interval : fullState) {
                        val = interval.getStateValue();
                        writer.print("        ");
                        switch (GenerateTestValues.$SWITCH_TABLE$org$eclipse$tracecompass$statesystem$core$statevalue$ITmfStateValue$Type()[val.getType().ordinal()]) {
                            case 1: {
                                writer.println("TmfStateValue.nullValue(),");
                                break;
                            }
                            case 2: {
                                writer.println("TmfStateValue.newValueInt(" + val.unboxInt() + "),");
                                break;
                            }
                            case 3: {
                                writer.println("TmfStateValue.newValueLong(" + val.unboxLong() + "),");
                                break;
                            }
                            case 4: {
                                writer.println("TmfStateValue.newValueDouble(" + val.unboxDouble() + "),");
                                break;
                            }
                            case 5: {
                                writer.println("TmfStateValue.newValueString(\"" + val.unboxStr() + "\"),");
                                break;
                            }
                            default: {
                                writer.println(val.toString());
                            }
                        }
                    }
                    writer.println("    };");
                    writer.println("}");
                    writer.println();
                    module.dispose();
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
                ** if (trace == null) goto lbl-1000
            }
            catch (Throwable var3_5) {
                if (var2_2 == null) {
                    var2_2 = var3_5;
                } else if (var2_2 != var3_5) {
                    var2_2.addSuppressed(var3_5);
                }
                if (trace != null) {
                    trace.close();
                }
                throw var2_2;
            }
lbl-1000:
            // 1 sources

            {
                trace.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var3_6) {
            if (var2_2 == null) {
                var2_2 = var3_6;
            } else if (var2_2 != var3_6) {
                var2_2.addSuppressed(var3_6);
            }
            throw var2_2;
        }
        System.exit(0);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$tracecompass$statesystem$core$statevalue$ITmfStateValue$Type() {
        if ($SWITCH_TABLE$org$eclipse$tracecompass$statesystem$core$statevalue$ITmfStateValue$Type != null) {
            return $SWITCH_TABLE$org$eclipse$tracecompass$statesystem$core$statevalue$ITmfStateValue$Type;
        }
        int[] nArray = new int[ITmfStateValue.Type.values().length];
        try {
            nArray[ITmfStateValue.Type.DOUBLE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITmfStateValue.Type.INTEGER.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITmfStateValue.Type.LONG.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITmfStateValue.Type.NULL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITmfStateValue.Type.STRING.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$tracecompass$statesystem$core$statevalue$ITmfStateValue$Type = nArray;
        return nArray;
    }
}

