/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel.statesystem;

import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelanalysis.KernelAnalysisModule;
import org.eclipse.tracecompass.lttng2.kernel.core.tests.analysis.kernel.statesystem.StateSystemTest;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class PartialStateSystemTest
extends StateSystemTest {
    @NonNull
    private static final String TEST_FILE_NAME = "test-partial";
    private static File stateFile;
    private static TestLttngKernelAnalysisModule module;

    @BeforeClass
    public static void initialize() {
        if (!testTrace.exists()) {
            traceIsPresent = false;
            return;
        }
        traceIsPresent = true;
        stateFile = new File(String.valueOf(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)testTrace.getTrace())) + TEST_FILE_NAME);
        if (stateFile.exists()) {
            stateFile.delete();
        }
        module = new TestLttngKernelAnalysisModule(TEST_FILE_NAME);
        try {
            Assert.assertTrue((boolean)module.setTrace((ITmfTrace)testTrace.getTrace()));
        }
        catch (TmfAnalysisException e) {
            Assert.fail();
        }
        module.schedule();
        Assert.assertTrue((boolean)module.waitForCompletion());
        fixture = module.getStateSystem();
    }

    @AfterClass
    public static void cleanup() {
        if (module != null) {
            module.dispose();
        }
        if (stateFile != null) {
            stateFile.delete();
        }
        if (fixture != null) {
            fixture.dispose();
        }
        module = null;
        fixture = null;
    }

    @Override
    protected long getEndTimes(int idx) {
        return 1331668248014184527L;
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testSingleQuery1() {
        super.testSingleQuery1();
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testRangeQuery1() {
        super.testRangeQuery1();
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testRangeQuery2() {
        super.testRangeQuery2();
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testRangeQuery3() {
        super.testRangeQuery3();
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testSingleQueryInvalidTime1() throws TimeRangeException {
        super.testSingleQueryInvalidTime1();
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testSingleQueryInvalidTime2() throws TimeRangeException {
        super.testSingleQueryInvalidTime2();
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testRangeQueryInvalidTime1() throws TimeRangeException {
        super.testRangeQueryInvalidTime1();
    }

    @Override
    @Test(expected=UnsupportedOperationException.class)
    public void testRangeQueryInvalidTime2() throws TimeRangeException {
        super.testRangeQueryInvalidTime2();
    }

    @NonNullByDefault
    private static class TestLttngKernelAnalysisModule
    extends KernelAnalysisModule {
        private final String htFileName;

        public TestLttngKernelAnalysisModule(String htFileName) {
            this.htFileName = htFileName;
        }

        public boolean setTrace(@Nullable ITmfTrace trace) throws TmfAnalysisException {
            if (!(trace instanceof CtfTmfTrace)) {
                return false;
            }
            return super.setTrace(trace);
        }

        protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
            return TmfStateSystemAnalysisModule.StateSystemBackendType.PARTIAL;
        }

        protected String getSsFileName() {
            return this.htFileName;
        }
    }
}

