/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.analysis;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.statistics.ITmfStatistics;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsModule;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class StatisticsAnalysisBenchmark {
    private static final String TEST_ID = "org.eclipse.linuxtools#Statistics analysis";
    private static final int LOOP_COUNT = 25;
    private static final Map<String, Long> fDjangoClientEntriesToTest = new HashMap<String, Long>();
    private static final Map<String, Long> fDjangoHttpdEntriesToTest = new HashMap<String, Long>();

    @BeforeClass
    public static void buildTest() {
        fDjangoClientEntriesToTest.put("exit_syscall", 234013L);
        fDjangoClientEntriesToTest.put("sys_recvfrom", 133517L);
        fDjangoClientEntriesToTest.put("irq_handler_exit", 62743L);
        fDjangoClientEntriesToTest.put("irq_handler_entry", 62743L);
        fDjangoClientEntriesToTest.put("softirq_entry", 39627L);
        fDjangoHttpdEntriesToTest.put("exit_syscall", 174802L);
        fDjangoHttpdEntriesToTest.put("inet_sock_local_out", 36195L);
        fDjangoHttpdEntriesToTest.put("irq_handler_exit", 93040L);
        fDjangoHttpdEntriesToTest.put("irq_handler_entry", 93040L);
        fDjangoHttpdEntriesToTest.put("softirq_entry", 63062L);
    }

    @Test
    public void testDjangoClient() {
        StatisticsAnalysisBenchmark.runTest(CtfTmfTestTrace.DJANGO_CLIENT, "Django-client trace", fDjangoClientEntriesToTest);
    }

    @Test
    public void testDjangoHttpd() {
        StatisticsAnalysisBenchmark.runTest(CtfTmfTestTrace.DJANGO_HTTPD, "Django-Httpd trace", fDjangoHttpdEntriesToTest);
    }

    private static void runTest(CtfTmfTestTrace testTrace, String testName, Map<String, Long> testCases) {
        Assume.assumeTrue((boolean)testTrace.exists());
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter("org.eclipse.linuxtools#Statistics analysis#" + testName);
        perf.tagAsSummary(pm, "Statistics Analysis: " + testName, Dimension.CPU_TIME);
        if (testTrace == CtfTmfTestTrace.DJANGO_CLIENT) {
            perf.tagAsGlobalSummary(pm, "Statistics Analysis: " + testName, Dimension.CPU_TIME);
        }
        int i = 0;
        while (i < 25) {
            block24: {
                TmfStatisticsModule module = null;
                try {
                    try {
                        Throwable throwable = null;
                        Object var8_10 = null;
                        try (LttngKernelTrace trace = new LttngKernelTrace();){
                            module = new TmfStatisticsModule();
                            module.setId("test");
                            trace.initTrace(null, testTrace.getPath(), CtfTmfEvent.class);
                            module.setTrace((ITmfTrace)trace);
                            pm.start();
                            TmfTestHelper.executeAnalysis((IAnalysisModule)module);
                            pm.stop();
                            ITmfStatistics stats = module.getStatistics();
                            if (stats == null) {
                                throw new IllegalStateException();
                            }
                            Map map = stats.getEventTypesTotal();
                            try {
                                for (Map.Entry<String, Long> entry : testCases.entrySet()) {
                                    Assert.assertTrue((boolean)((Long)map.get(entry.getKey())).equals(entry.getValue()));
                                }
                            }
                            catch (NullPointerException e) {
                                Assert.fail((String)e.getMessage());
                            }
                            File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
                            File[] fileArray = suppDir.listFiles();
                            int n = fileArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                File file = fileArray[n2];
                                file.delete();
                                ++n2;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (TmfAnalysisException | TmfTraceException e) {
                        Assert.fail((String)e.getMessage());
                        if (module != null) {
                            module.dispose();
                        }
                        break block24;
                    }
                }
                catch (Throwable throwable) {
                    if (module != null) {
                        module.dispose();
                    }
                    throw throwable;
                }
                if (module != null) {
                    module.dispose();
                }
            }
            ++i;
        }
        pm.commit();
        testTrace.dispose();
    }
}

