/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.lttng.kernel.core.tests.shared.vm;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.trace.VirtualMachineExperiment;
import org.eclipse.tracecompass.lttng2.lttng.kernel.core.tests.shared.vm.VmTraces;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public enum VmTestExperiment {
    ONE_QEMUKVM(VmTraces.HOST_ONE_QEMUKVM, VmTraces.GUEST_ONE_QEMUKVM);

    private Set<VmTraces> fTraces = new HashSet<VmTraces>();

    private VmTestExperiment(VmTraces ... traces) {
        VmTraces[] vmTracesArray = traces;
        int n2 = traces.length;
        int n3 = 0;
        while (n3 < n2) {
            VmTraces trace = vmTracesArray[n3];
            this.fTraces.add(trace);
            ++n3;
        }
    }

    public synchronized TmfExperiment getExperiment(boolean deleteSuppFiles) {
        HashSet<ITmfTrace> traces = new HashSet<ITmfTrace>();
        for (VmTraces trace : this.fTraces) {
            traces.add(trace.getTrace());
        }
        String expName = this.name();
        VirtualMachineExperiment experiment = new VirtualMachineExperiment(expName, traces);
        if (deleteSuppFiles) {
            File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)experiment));
            File[] fileArray = suppDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
        }
        return experiment;
    }

    public boolean exists() {
        boolean exists = true;
        for (VmTraces trace : this.fTraces) {
            exists &= trace.exists();
        }
        return exists;
    }
}

