/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.tracecompass.analysis.os.linux.ui.views.controlflow.ControlFlowView;
import org.eclipse.tracecompass.analysis.os.linux.ui.views.resources.ResourcesView;
import org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests.KernelTest;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEventsEditor;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramView;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class ImportAndReadKernelSmokeTest
extends KernelTest {
    private static final CtfTmfTestTrace CTT = CtfTmfTestTrace.SYNTHETIC_TRACE;
    private ITmfEvent fDesired1;
    private ITmfEvent fDesired2;

    @Test
    public void test() {
        Matcher matcher = WidgetMatcherFactory.withPartName((String)CTT.getTrace().getName());
        IEditorPart iep = ((IEditorReference)fBot.editor(matcher).getReference()).getEditor(true);
        final TmfEventsEditor tmfEd = (TmfEventsEditor)iep;
        this.fDesired1 = ImportAndReadKernelSmokeTest.getEvent(100);
        this.fDesired2 = ImportAndReadKernelSmokeTest.getEvent(10000);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                tmfEd.setFocus();
                tmfEd.selectionChanged(new SelectionChangedEvent((ISelectionProvider)tmfEd, (ISelection)new StructuredSelection((Object)ImportAndReadKernelSmokeTest.this.fDesired1)));
            }
        });
        this.testHV(ImportAndReadKernelSmokeTest.getViewPart("Histogram"));
        ImportAndReadKernelSmokeTest.testCFV((ControlFlowView)ImportAndReadKernelSmokeTest.getViewPart("Control Flow"));
        ImportAndReadKernelSmokeTest.testRV((ResourcesView)ImportAndReadKernelSmokeTest.getViewPart("Resources"));
    }

    private static void testCFV(ControlFlowView vp) {
        Assert.assertNotNull((Object)vp);
    }

    private void testHV(IViewPart vp) {
        SWTBotView hvBot = new SWTWorkbenchBot().viewById("org.eclipse.linuxtools.tmf.ui.views.histogram");
        List hvTools = hvBot.getToolbarButtons();
        for (SWTBotToolbarButton hvTool : hvTools) {
            if (!hvTool.getToolTipText().toLowerCase().contains("lost")) continue;
            hvTool.click();
        }
        HistogramView hv = (HistogramView)vp;
        TmfSelectionRangeUpdatedSignal signal = new TmfSelectionRangeUpdatedSignal((Object)hv, this.fDesired1.getTimestamp());
        TmfSelectionRangeUpdatedSignal signal2 = new TmfSelectionRangeUpdatedSignal((Object)hv, this.fDesired2.getTimestamp());
        hv.updateTimeRange(100000L);
        SWTBotUtils.waitForJobs();
        hv.selectionRangeUpdated(signal);
        hv.broadcast((TmfSignal)signal);
        SWTBotUtils.waitForJobs();
        SWTBotUtils.delay((long)1000L);
        hv.updateTimeRange(1000000000L);
        SWTBotUtils.waitForJobs();
        hv.selectionRangeUpdated(signal2);
        hv.broadcast((TmfSignal)signal2);
        SWTBotUtils.waitForJobs();
        SWTBotUtils.delay((long)1000L);
        Assert.assertNotNull((Object)hv);
    }

    private static void testRV(ResourcesView vp) {
        Assert.assertNotNull((Object)vp);
    }

    private static CtfTmfEvent getEvent(int rank) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CtfTmfTrace trace = CtfTmfTestTrace.SYNTHETIC_TRACE.getTrace();){
            ITmfContext ctx = trace.seekEvent(0L);
            int i = 0;
            while (i < rank) {
                trace.getNext(ctx);
                ++i;
            }
            return trace.getNext(ctx);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static IViewPart getViewPart(final String viewTile) {
        final IViewPart[] vps = new IViewPart[1];
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                IViewReference[] viewRefs;
                IViewReference[] iViewReferenceArray = viewRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
                int n = viewRefs.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewRef = iViewReferenceArray[n2];
                    IViewPart vp = viewRef.getView(true);
                    if (vp.getTitle().equals(viewTile)) {
                        vps[0] = vp;
                        return;
                    }
                    ++n2;
                }
            }
        });
        return vps[0];
    }
}

