/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.BoolResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class KernelTest {
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    private static final String KERNEL_PERSPECTIVE_ID = "org.eclipse.linuxtools.lttng2.kernel.ui.perspective";
    private static final String TRACE_PROJECT_NAME = "test";
    private static final CtfTmfTestTrace CTT = CtfTmfTestTrace.SYNTHETIC_TRACE;
    protected static SWTWorkbenchBot fBot;
    private static final Logger fLogger;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        List openViews = fBot.views();
        for (SWTBotView view : openViews) {
            if (!view.getTitle().equals("Welcome")) continue;
            view.close();
            fBot.waitUntil(ConditionHelpers.ViewIsClosed((SWTBotView)view));
        }
        KernelTest.switchKernelPerspective();
        SWTBotUtils.waitForJobs();
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
    }

    @AfterClass
    public static void afterClass() {
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)fBot);
        fLogger.removeAllAppenders();
    }

    private static void switchKernelPerspective() {
        final Exception[] retE = new Exception[1];
        if (!((Boolean)UIThreadRunnable.syncExec((Result)new BoolResult(){

            public Boolean run() {
                try {
                    PlatformUI.getWorkbench().showPerspective(KernelTest.KERNEL_PERSPECTIVE_ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
                catch (WorkbenchException e) {
                    retE[0] = e;
                    return false;
                }
                return true;
            }
        })).booleanValue()) {
            Assert.fail((String)retE[0].getMessage());
        }
    }

    @Before
    public void before() {
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)CTT.getPath(), (String)TRACE_TYPE);
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)CTT.getTrace().getName());
    }

    @After
    public void after() {
        fBot.closeAllEditors();
    }
}

