/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.ui.swtbot.tests;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class CallStackViewTest {
    private static final String UST_ID = "org.eclipse.linuxtools.lttng2.ust.tracetype";
    private static final String PROJECT_NAME = "TestForCallstack";
    private static final Logger fLogger = Logger.getRootLogger();
    private static SWTWorkbenchBot fBot;
    private static final long[] TIMESTAMPS;
    private static final String[][] STACK_FRAMES;
    private static final String ALIGN_VIEWS = "Align Views";
    private static final String IMPORT_BINARY = "Import a binary file containing debugging symbols";
    private static final String IMPORT_TEXT = "Import a text file containing the mapping between addresses and function names";
    private static final String SORT_BY_NAME = "Sort threads by thread name";
    private static final String SORT_BY_ID = "Sort threads by thread id";
    private static final String SORT_BY_START = "Sort threads by start time";
    private static final String SHOW_VIEW_FILTERS = "Show View Filters";
    private static final String RESET_TIME_SCALE = "Reset the Time Scale to Default";
    private static final String SELECT_PREVIOUS_EVENT = "Select Previous Event";
    private static final String SELECT_NEXT_EVENT = "Select Next Event";
    private static final String SELECT_PREVIOUS_ITEM = "Select Previous Item";
    private static final String SELECT_NEXT_ITEM = "Select Next Item";
    private static final String ZOOM_IN = "Zoom In";
    private static final String ZOOM_OUT = "Zoom Out";
    private static final String PIN_VIEW = "Pin View";
    private static final List<String> TOOLBAR_BUTTONS_TOOLTIPS;

    static {
        TIMESTAMPS = new long[]{1378850463804898643L, 1378850463804899057L, 1378850463804900219L, 1378850463804900678L, 1378850463804901308L, 1378850463804901909L, 1378850463804902763L, 1378850463804903168L, 1378850463804903766L, 1378850463804904165L, 1378850463804904970L};
        STACK_FRAMES = new String[][]{{"40472b", "4045c8", "404412", "", ""}, {"40472b", "4045c8", "404412", "40392b", ""}, {"40472b", "4045c8", "404412", "", ""}, {"40472b", "4045c8", "", "", ""}, {"40472b", "4045c8", "404412", "", ""}, {"40472b", "4045c8", "404412", "40392b", ""}, {"40472b", "4045c8", "404412", "", ""}, {"40472b", "4045c8", "", "", ""}, {"40472b", "4045c8", "404412", "", ""}, {"40472b", "4045c8", "404412", "40392b", ""}, {"40472b", "4045c8", "404412", "", ""}};
        TOOLBAR_BUTTONS_TOOLTIPS = ImmutableList.of((Object)ALIGN_VIEWS, (Object)IMPORT_BINARY, (Object)IMPORT_TEXT, (Object)"", (Object)SORT_BY_NAME, (Object)SORT_BY_ID, (Object)SORT_BY_START, (Object)"", (Object)SHOW_VIEW_FILTERS, (Object)"", (Object)RESET_TIME_SCALE, (Object)SELECT_PREVIOUS_EVENT, (Object[])new String[]{SELECT_NEXT_EVENT, SELECT_PREVIOUS_ITEM, SELECT_NEXT_ITEM, ZOOM_IN, ZOOM_OUT, "", PIN_VIEW});
    }

    @BeforeClass
    public static void init() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)fBot);
        SWTBotUtils.switchToTracingPerspective();
        SWTBotUtils.waitForJobs();
    }

    @Before
    public void beforeTest() {
        SWTBotUtils.createProject((String)PROJECT_NAME);
        SWTBotTreeItem treeItem = SWTBotUtils.selectTracesFolder((SWTWorkbenchBot)fBot, (String)PROJECT_NAME);
        Assert.assertNotNull((Object)treeItem);
        CtfTmfTestTrace cygProfile = CtfTmfTestTrace.CYG_PROFILE;
        Assume.assumeTrue((boolean)cygProfile.exists());
        File file = new File(cygProfile.getTrace().getPath());
        SWTBotUtils.openTrace((String)PROJECT_NAME, (String)file.getAbsolutePath(), (String)UST_ID);
        SWTBotUtils.openView((String)"org.eclipse.linuxtools.tmf.ui.views.callstack");
        SWTBotUtils.waitForJobs();
    }

    @After
    public void tearDown() {
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject((String)PROJECT_NAME, (SWTWorkbenchBot)fBot);
    }

    @Test
    public void testOpenCallstack() {
        String node = "glxgears-cyg-profile";
        String childName = "glxgears-16073";
        ImmutableList expected = ImmutableList.of((Object)"40472b", (Object)"", (Object)"", (Object)"", (Object)"");
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack");
        viewBot.setFocus();
        SWTBotView viewBot1 = viewBot;
        SWTBotTree tree = viewBot1.bot().tree();
        SWTBotTreeItem treeItem = tree.getTreeItem(node);
        Assert.assertEquals((Object)childName, treeItem.getNodes().get(0));
        List names = treeItem.getNode(childName).getNodes();
        Assert.assertEquals((Object)expected, (Object)names);
    }

    @Test
    public void testGoToTimeAndCheckStack() {
        CallStackViewTest.goToTime(TIMESTAMPS[0]);
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack");
        viewBot.setFocus();
        SWTBotUtils.waitForJobs();
        List<String> names = CallStackViewTest.getVisibleStackFrames(viewBot);
        Assert.assertArrayEquals((Object[])STACK_FRAMES[0], (Object[])names.toArray());
    }

    @Test
    public void testGoToTimeGoBackAndForthAndCheckStack() {
        int currentEventOffset = 0;
        CallStackViewTest.goToTime(TIMESTAMPS[currentEventOffset]);
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack");
        int i = 0;
        while (i < 10) {
            viewBot.toolbarPushButton(SELECT_NEXT_EVENT).click();
            fBot.waitUntil(ConditionHelpers.selectionInEventsTable((SWTWorkbenchBot)fBot, (long)TIMESTAMPS[++currentEventOffset]));
            SWTBotUtils.waitForJobs();
            Assert.assertArrayEquals((Object[])STACK_FRAMES[currentEventOffset], (Object[])CallStackViewTest.getVisibleStackFrames(viewBot).toArray());
            ++i;
        }
        i = 0;
        while (i < 2) {
            viewBot.toolbarPushButton(SELECT_PREVIOUS_EVENT).click();
            fBot.waitUntil(ConditionHelpers.selectionInEventsTable((SWTWorkbenchBot)fBot, (long)TIMESTAMPS[--currentEventOffset]));
            SWTBotUtils.waitForJobs();
            Assert.assertArrayEquals((Object[])STACK_FRAMES[currentEventOffset], (Object[])CallStackViewTest.getVisibleStackFrames(viewBot).toArray());
            ++i;
        }
        viewBot.toolbarPushButton(SELECT_PREVIOUS_ITEM).click();
        SWTBotUtils.waitForJobs();
        viewBot.toolbarPushButton(SELECT_NEXT_ITEM).click();
        SWTBotUtils.waitForJobs();
        viewBot.toolbarPushButton(ZOOM_IN).click();
        SWTBotUtils.waitForJobs();
        viewBot.toolbarPushButton(ZOOM_OUT).click();
        SWTBotUtils.waitForJobs();
    }

    @Test
    public void testGoToTimeSortAndCheckStack() {
        CallStackViewTest.goToTime(TIMESTAMPS[0]);
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack");
        viewBot.setFocus();
        viewBot.toolbarToggleButton(SORT_BY_NAME).click();
        viewBot.toolbarToggleButton(SORT_BY_ID).click();
        viewBot.toolbarToggleButton(SORT_BY_START).click();
        viewBot.setFocus();
        SWTBotUtils.waitForJobs();
        List<String> names = CallStackViewTest.getVisibleStackFrames(viewBot);
        Assert.assertArrayEquals((Object[])STACK_FRAMES[0], (Object[])names.toArray());
    }

    private static List<String> getVisibleStackFrames(SWTBotView viewBot) {
        SWTBotTree tree = viewBot.bot().tree();
        ArrayList<String> names = new ArrayList<String>();
        SWTBotTreeItem[] sWTBotTreeItemArray = tree.getAllItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem swtBotTreeItem = sWTBotTreeItemArray[n2];
            SWTBotTreeItem[] sWTBotTreeItemArray2 = swtBotTreeItem.getItems();
            int n3 = sWTBotTreeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                SWTBotTreeItem items = sWTBotTreeItemArray2[n4];
                SWTBotTreeItem[] sWTBotTreeItemArray3 = items.getItems();
                int n5 = sWTBotTreeItemArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    SWTBotTreeItem item = sWTBotTreeItemArray3[n6];
                    names.add(item.cell(0));
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return names;
    }

    private static void goToTime(long timestamp) {
        SWTBotTable table = fBot.activeEditor().bot().table();
        table.setFocus();
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)table.widget, (ITmfTimestamp)new TmfNanoTimestamp(timestamp)));
        fBot.waitUntil(ConditionHelpers.selectionInEventsTable((SWTWorkbenchBot)fBot, (long)timestamp));
    }

    @Ignore
    @Test
    public void testGoToTimeAndCheckStackWithNames() {
        CallStackViewTest.goToTime(TIMESTAMPS[0]);
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack");
        viewBot.setFocus();
        SWTBotTree tree = viewBot.bot().tree();
        SWTBotUtils.waitForJobs();
        ArrayList<String> names = new ArrayList<String>();
        SWTBotTreeItem[] sWTBotTreeItemArray = tree.getAllItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem swtBotTreeItem = sWTBotTreeItemArray[n2];
            SWTBotTreeItem[] sWTBotTreeItemArray2 = swtBotTreeItem.getItems();
            int n3 = sWTBotTreeItemArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                SWTBotTreeItem items = sWTBotTreeItemArray2[n4];
                SWTBotTreeItem[] sWTBotTreeItemArray3 = items.getItems();
                int n5 = sWTBotTreeItemArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    SWTBotTreeItem item = sWTBotTreeItemArray3[n6];
                    names.add(item.cell(0));
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    @Test
    public void testCallstackNavigation() {
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.callstack");
        viewBot.setFocus();
        ArrayList<String> buttons = new ArrayList<String>();
        for (SWTBotToolbarButton swtBotToolbarButton : viewBot.getToolbarButtons()) {
            buttons.add(swtBotToolbarButton.getToolTipText());
        }
        Assert.assertEquals(TOOLBAR_BUTTONS_TOOLTIPS, buttons);
    }
}

