/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider;

import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.stateprovider.XmlStateSystemModule;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.Activator;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StateProviderModelTest {
    @NonNull
    private static final String testTrace1 = "test_traces/testTrace1.xml";

    @NonNull
    private static ITmfTrace initializeTrace(String traceFile) {
        TmfXmlTraceStub trace = new TmfXmlTraceStub();
        try {
            trace.initTrace(null, Activator.getAbsolutePath(new Path(traceFile)).toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e1) {
            Assert.fail((String)e1.getMessage());
        }
        return trace;
    }

    @NonNull
    private static XmlStateSystemModule initializeModule(TmfXmlTestFiles xmlAnalysisFile) {
        Document doc = xmlAnalysisFile.getXmlDocument();
        Assert.assertNotNull((Object)doc);
        NodeList stateproviderNodes = doc.getElementsByTagName("stateProvider");
        Assert.assertFalse((stateproviderNodes.getLength() == 0 ? 1 : 0) != 0);
        Element node = (Element)stateproviderNodes.item(0);
        XmlStateSystemModule module = new XmlStateSystemModule();
        String moduleId = node.getAttribute("id");
        Assert.assertNotNull((Object)moduleId);
        module.setId(moduleId);
        module.setXmlFile(xmlAnalysisFile.getPath());
        return module;
    }

    private static void verifyStateIntervals(String testId, @NonNull ITmfStateSystem ss, Integer quark, int[] expectedStarts, ITmfStateValue[] expectedValues) throws AttributeNotFoundException, StateSystemDisposedException {
        int expectedCount = expectedStarts.length - 1;
        List intervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)quark, (long)expectedStarts[0], (long)expectedStarts[expectedCount]);
        Assert.assertEquals((String)(String.valueOf(testId) + ": Interval count"), (long)expectedCount, (long)intervals.size());
        int i = 0;
        while (i < expectedCount) {
            ITmfStateInterval interval = (ITmfStateInterval)intervals.get(i);
            Assert.assertEquals((String)(String.valueOf(testId) + ": Start time of interval " + i), (long)expectedStarts[i], (long)interval.getStartTime());
            long actualEnd = i == expectedCount - 1 ? expectedStarts[i + 1] : expectedStarts[i + 1] - 1;
            Assert.assertEquals((String)(String.valueOf(testId) + ": End time of interval " + i), (long)actualEnd, (long)interval.getEndTime());
            Assert.assertEquals((String)(String.valueOf(testId) + ": Expected value of interval " + i), (Object)expectedValues[i], (Object)interval.getStateValue());
            ++i;
        }
    }

    @Test
    public void testEventName() {
        ITmfTrace trace = StateProviderModelTest.initializeTrace(testTrace1);
        XmlStateSystemModule module = StateProviderModelTest.initializeModule(TmfXmlTestFiles.ATTRIBUTE_FILE);
        try {
            try {
                module.setTrace(trace);
                module.schedule();
                module.waitForCompletion();
                ITmfStateSystem ss = module.getStateSystem();
                Assert.assertNotNull((Object)ss);
                List quarks = ss.getQuarks(new String[]{"*"});
                Assert.assertEquals((long)2L, (long)quarks.size());
                for (Integer quark : quarks) {
                    String name;
                    switch (name = ss.getAttributeName(quark.intValue())) {
                        case "test": {
                            int[] expectedStarts = new int[]{1, 5, 7};
                            ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.newValueInt((int)1), TmfStateValue.newValueInt((int)2)};
                            StateProviderModelTest.verifyStateIntervals("test", ss, quark, expectedStarts, expectedValues);
                            break;
                        }
                        case "test1": {
                            int[] expectedStarts = new int[]{1, 3, 7, 7};
                            ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.nullValue(), TmfStateValue.newValueInt((int)1), TmfStateValue.newValueInt((int)2)};
                            StateProviderModelTest.verifyStateIntervals("test1", ss, quark, expectedStarts, expectedValues);
                            break;
                        }
                        default: {
                            Assert.fail((String)("Wrong attribute name " + name));
                        }
                    }
                }
            }
            catch (AttributeNotFoundException | StateSystemDisposedException | TmfAnalysisException e) {
                Assert.fail((String)e.getMessage());
                module.dispose();
                trace.dispose();
            }
        }
        finally {
            module.dispose();
            trace.dispose();
        }
    }
}

