/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.event;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.junit.Assert;
import org.junit.Test;

public class TmfTimestampTest {
    private final ITmfTimestamp ts0 = new TmfTimestamp();
    private final ITmfTimestamp ts1 = new TmfTimestamp(12345L, 0);
    private final ITmfTimestamp ts2 = new TmfTimestamp(12345L, -1);
    private final ITmfTimestamp ts3 = new TmfTimestamp(12345L, 2);
    private final ITmfTimestamp ts4 = new TmfTimestamp(12345L, -3);
    private final ITmfTimestamp ts5 = new TmfTimestamp(12345L, -6);
    private final ITmfTimestamp ts6 = new TmfTimestamp(12345L, -9);
    private final ITmfTimestamp ts7 = new TmfTimestamp(-12345L, -3);
    private final ITmfTimestamp ts8 = new TmfTimestamp(-12345L, -6);
    private final ITmfTimestamp ts9 = new TmfTimestamp(-12345L, -9);

    @Test
    public void testDefaultConstructor() {
        Assert.assertEquals((String)"getValue", (long)0L, (long)this.ts0.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)this.ts0.getScale());
    }

    @Test
    public void testValueConstructor() {
        Assert.assertEquals((String)"getValue", (long)12345L, (long)this.ts1.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)this.ts1.getScale());
    }

    @Test
    public void testValueScaleConstructor() {
        Assert.assertEquals((String)"getValue", (long)12345L, (long)this.ts2.getValue());
        Assert.assertEquals((String)"getscale", (long)-1L, (long)this.ts2.getScale());
    }

    @Test
    public void testFullConstructor() {
        Assert.assertEquals((String)"getValue", (long)12345L, (long)this.ts3.getValue());
        Assert.assertEquals((String)"getscale", (long)2L, (long)this.ts3.getScale());
    }

    @Test
    public void testCopyConstructor() {
        TmfTimestamp ts = new TmfTimestamp(12345L, 2);
        TmfTimestamp copy = new TmfTimestamp((ITmfTimestamp)ts);
        Assert.assertEquals((String)"getValue", (long)ts.getValue(), (long)copy.getValue());
        Assert.assertEquals((String)"getscale", (long)ts.getScale(), (long)copy.getScale());
        Assert.assertEquals((String)"getValue", (long)12345L, (long)copy.getValue());
        Assert.assertEquals((String)"getscale", (long)2L, (long)copy.getScale());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCopyNullConstructor() {
        new TmfTimestamp(null);
    }

    @Test
    public void testCopyConstructorBigBang() {
        TmfTimestamp ts = new TmfTimestamp(TmfTimestamp.BIG_BANG);
        Assert.assertEquals((String)"getValue", (long)TmfTimestamp.BIG_BANG.getValue(), (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)TmfTimestamp.BIG_BANG.getScale(), (long)ts.getScale());
    }

    @Test
    public void testCopyConstructorBigCrunch() {
        TmfTimestamp ts = new TmfTimestamp(TmfTimestamp.BIG_CRUNCH);
        Assert.assertEquals((String)"getValue", (long)TmfTimestamp.BIG_CRUNCH.getValue(), (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)TmfTimestamp.BIG_CRUNCH.getScale(), (long)ts.getScale());
    }

    @Test
    public void testCopyConstructorZero() {
        TmfTimestamp ts = new TmfTimestamp(TmfTimestamp.ZERO);
        Assert.assertEquals((String)"getValue", (long)TmfTimestamp.ZERO.getValue(), (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)TmfTimestamp.ZERO.getScale(), (long)ts.getScale());
    }

    @Test
    public void testHashCode() {
        TmfTimestamp ts0copy = new TmfTimestamp(this.ts0);
        TmfTimestamp ts1copy = new TmfTimestamp(this.ts1);
        TmfTimestamp ts2copy = new TmfTimestamp(this.ts2);
        Assert.assertTrue((String)"hashCode", (this.ts0.hashCode() == ts0copy.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.ts1.hashCode() == ts1copy.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.ts2.hashCode() == ts2copy.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.ts0.hashCode() != this.ts1.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.ts0.equals(this.ts0));
        Assert.assertTrue((String)"equals", (boolean)this.ts1.equals(this.ts1));
        Assert.assertTrue((String)"equals", (!this.ts0.equals(this.ts1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts1.equals(this.ts0) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        TmfTimestamp ts0copy = new TmfTimestamp(this.ts0);
        Assert.assertTrue((String)"equals", (boolean)this.ts0.equals(ts0copy));
        Assert.assertTrue((String)"equals", (boolean)ts0copy.equals(this.ts0));
        TmfTimestamp ts1copy = new TmfTimestamp(this.ts1);
        Assert.assertTrue((String)"equals", (boolean)this.ts1.equals(ts1copy));
        Assert.assertTrue((String)"equals", (boolean)ts1copy.equals(this.ts1));
        TmfTimestamp ts2copy = new TmfTimestamp(this.ts2);
        Assert.assertTrue((String)"equals", (boolean)this.ts2.equals(ts2copy));
        Assert.assertTrue((String)"equals", (boolean)ts2copy.equals(this.ts2));
    }

    @Test
    public void testEqualsTransivity() {
        TmfTimestamp ts0copy1 = new TmfTimestamp(this.ts0);
        TmfTimestamp ts0copy2 = new TmfTimestamp((ITmfTimestamp)ts0copy1);
        Assert.assertTrue((String)"equals", (boolean)this.ts0.equals(ts0copy1));
        Assert.assertTrue((String)"equals", (boolean)ts0copy1.equals(ts0copy2));
        Assert.assertTrue((String)"equals", (boolean)this.ts0.equals(ts0copy2));
        TmfTimestamp ts1copy1 = new TmfTimestamp(this.ts1);
        TmfTimestamp ts1copy2 = new TmfTimestamp((ITmfTimestamp)ts1copy1);
        Assert.assertTrue((String)"equals", (boolean)this.ts1.equals(ts1copy1));
        Assert.assertTrue((String)"equals", (boolean)ts1copy1.equals(ts1copy2));
        Assert.assertTrue((String)"equals", (boolean)this.ts1.equals(ts1copy2));
        TmfTimestamp ts2copy1 = new TmfTimestamp(this.ts2);
        TmfTimestamp ts2copy2 = new TmfTimestamp((ITmfTimestamp)ts2copy1);
        Assert.assertTrue((String)"equals", (boolean)this.ts2.equals(ts2copy1));
        Assert.assertTrue((String)"equals", (boolean)ts2copy1.equals(ts2copy2));
        Assert.assertTrue((String)"equals", (boolean)this.ts2.equals(ts2copy2));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.ts0.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.ts1.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsNonTimestamp() {
        Assert.assertFalse((String)"equals", (boolean)this.ts0.equals(this.ts0.toString()));
    }

    @Test
    public void testToStringDefault() {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
        Date d0 = new Date((long)((double)this.ts0.getValue() * Math.pow(10.0, this.ts0.getScale() + 3)));
        Date d1 = new Date((long)((double)this.ts1.getValue() * Math.pow(10.0, this.ts1.getScale() + 3)));
        Date d2 = new Date((long)((double)this.ts2.getValue() * Math.pow(10.0, this.ts2.getScale() + 3)));
        Date d3 = new Date((long)((double)this.ts3.getValue() * Math.pow(10.0, this.ts3.getScale() + 3)));
        Date d4 = new Date((long)((double)this.ts4.getValue() * Math.pow(10.0, this.ts4.getScale() + 3)));
        Date d5 = new Date((long)((double)this.ts5.getValue() * Math.pow(10.0, this.ts5.getScale() + 3)));
        Date d6 = new Date((long)((double)this.ts6.getValue() * Math.pow(10.0, this.ts6.getScale() + 3)));
        Date d7 = new Date((long)((double)this.ts7.getValue() * Math.pow(10.0, this.ts7.getScale() + 3)));
        Date d8 = new Date((long)((double)this.ts8.getValue() * Math.pow(10.0, this.ts8.getScale() + 3)) - 1L);
        Date d9 = new Date((long)((double)this.ts9.getValue() * Math.pow(10.0, this.ts9.getScale() + 3)) - 1L);
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d0)) + " 000 000"), (Object)this.ts0.toString());
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d1)) + " 000 000"), (Object)this.ts1.toString());
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d2)) + " 000 000"), (Object)this.ts2.toString());
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d3)) + " 000 000"), (Object)this.ts3.toString());
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d4)) + " 000 000"), (Object)this.ts4.toString());
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d5)) + " 345 000"), (Object)this.ts5.toString());
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d6)) + " 012 345"), (Object)this.ts6.toString());
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d7)) + " 000 000"), (Object)this.ts7.toString());
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d8)) + " 655 000"), (Object)this.ts8.toString());
        Assert.assertEquals((String)"toString", (Object)(String.valueOf(df.format(d9)) + " 987 655"), (Object)this.ts9.toString());
    }

    @Test
    public void testToStringInterval() {
        Assert.assertEquals((String)"toString", (Object)"000.000 000 000", (Object)this.ts0.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"12345.000 000 000", (Object)this.ts1.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"1234.500 000 000", (Object)this.ts2.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"1234500.000 000 000", (Object)this.ts3.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"012.345 000 000", (Object)this.ts4.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"000.012 345 000", (Object)this.ts5.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"000.000 012 345", (Object)this.ts6.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"-012.345 000 000", (Object)this.ts7.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"-000.012 345 000", (Object)this.ts8.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        Assert.assertEquals((String)"toString", (Object)"-000.000 012 345", (Object)this.ts9.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
    }

    @Test
    public void testNormalizeOffset() {
        ITmfTimestamp ts = this.ts0.normalize(0L, 0);
        Assert.assertEquals((String)"getValue", (long)0L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts0.normalize(12345L, 0);
        Assert.assertEquals((String)"getValue", (long)12345L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts0.normalize(10L, 0);
        Assert.assertEquals((String)"getValue", (long)10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = this.ts0.normalize(-10L, 0);
        Assert.assertEquals((String)"getValue", (long)-10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
    }

    @Test
    public void testNormalizeOffsetLowerLimits() {
        TmfTimestamp ref = new TmfTimestamp(-9223372036854775803L, 0);
        ITmfTimestamp ts = ref.normalize(-4L, 0);
        Assert.assertEquals((String)"getValue", (long)-9223372036854775807L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = ref.normalize(-5L, 0);
        Assert.assertEquals((String)"getValue", (long)Long.MIN_VALUE, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = ref.normalize(-6L, 0);
        Assert.assertEquals((String)"getValue", (long)Long.MIN_VALUE, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
    }

    @Test
    public void testNormalizeOffsetUpperLimits() {
        TmfTimestamp ref = new TmfTimestamp(0x7FFFFFFFFFFFFFFAL, 0);
        ITmfTimestamp ts = ref.normalize(4L, 0);
        Assert.assertEquals((String)"getValue", (long)0x7FFFFFFFFFFFFFFEL, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = ref.normalize(5L, 0);
        Assert.assertEquals((String)"getValue", (long)Long.MAX_VALUE, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
        ts = ref.normalize(6L, 0);
        Assert.assertEquals((String)"getValue", (long)Long.MAX_VALUE, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
    }

    @Test
    public void testNormalizeScale() {
        ITmfTimestamp ts = this.ts0.normalize(0L, 10);
        Assert.assertEquals((String)"getValue", (long)0L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)10L, (long)ts.getScale());
        ts = this.ts0.normalize(0L, -10);
        Assert.assertEquals((String)"getValue", (long)0L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)-10L, (long)ts.getScale());
    }

    @Test
    public void testNormalizedScaleLimits() {
        int MAX_SCALE_DIFF = 19;
        try {
            this.ts1.normalize(0L, 18);
            this.ts1.normalize(0L, -18);
        }
        catch (ArithmeticException e) {
            Assert.fail((String)"normalize: scale error");
        }
        try {
            this.ts1.normalize(0L, 19);
            Assert.fail((String)"normalize: scale error");
            this.ts1.normalize(0L, -19);
            Assert.fail((String)"normalize: scale error");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        try {
            this.ts1.normalize(0L, 20);
            Assert.fail((String)"normalize: scale error");
            this.ts1.normalize(0L, -20);
            Assert.fail((String)"normalize: scale error");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
    }

    @Test
    public void testNormalizeOffsetAndScaleTrivial() {
        ITmfTimestamp ts = this.ts0.normalize(0L, 0);
        Assert.assertEquals((String)"getValue", (long)0L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)0L, (long)ts.getScale());
    }

    @Test
    public void testNormalizeOffsetAndScale() {
        int SCALE = 12;
        ITmfTimestamp ts = this.ts0.normalize(0L, 12);
        Assert.assertEquals((String)"getValue", (long)0L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)12L, (long)ts.getScale());
        ts = this.ts0.normalize(12345L, 12);
        Assert.assertEquals((String)"getValue", (long)12345L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)12L, (long)ts.getScale());
        ts = this.ts0.normalize(10L, 12);
        Assert.assertEquals((String)"getValue", (long)10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)12L, (long)ts.getScale());
        ts = this.ts0.normalize(-10L, 12);
        Assert.assertEquals((String)"getValue", (long)-10L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)12L, (long)ts.getScale());
    }

    @Test
    public void testNormalizeOffsetAndScale2() {
        int SCALE = 2;
        ITmfTimestamp ts = this.ts1.normalize(0L, SCALE);
        Assert.assertEquals((String)"getValue", (long)123L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)SCALE, (long)ts.getScale());
        ts = this.ts1.normalize(12345L, SCALE);
        Assert.assertEquals((String)"getValue", (long)12468L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)SCALE, (long)ts.getScale());
        SCALE = -2;
        ts = this.ts1.normalize(0L, SCALE);
        Assert.assertEquals((String)"getValue", (long)1234500L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)SCALE, (long)ts.getScale());
        ts = this.ts1.normalize(67L, SCALE);
        Assert.assertEquals((String)"getValue", (long)1234567L, (long)ts.getValue());
        Assert.assertEquals((String)"getscale", (long)SCALE, (long)ts.getScale());
    }

    @Test
    public void testBasicCompareTo() {
        TmfTimestamp t1 = new TmfTimestamp(900L, 0);
        TmfTimestamp t2 = new TmfTimestamp(1000L, 0);
        TmfTimestamp t3 = new TmfTimestamp(1100L, 0);
        TmfTimestamp t4 = new TmfTimestamp(1000L, 0);
        Assert.assertTrue((t1.compareTo((ITmfTimestamp)t1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo((ITmfTimestamp)t2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo((ITmfTimestamp)t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo((ITmfTimestamp)t4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo((ITmfTimestamp)t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo((ITmfTimestamp)t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo((ITmfTimestamp)t4) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo((ITmfTimestamp)t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo((ITmfTimestamp)t2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo((ITmfTimestamp)t4) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToCornerCases1() {
        TmfTimestamp ts0a = new TmfTimestamp(this.ts0);
        TmfTimestamp ts0b = new TmfTimestamp(this.ts0.getValue(), this.ts0.getScale() + 1);
        TmfTimestamp ts0c = new TmfTimestamp(this.ts0.getValue() + 1L, this.ts0.getScale());
        TmfTimestamp ts0d = new TmfTimestamp(this.ts0.getValue() + 1L, this.ts0.getScale() + 1);
        Assert.assertTrue((String)"compareTo", (this.ts0.compareTo(this.ts0) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (this.ts0.compareTo((ITmfTimestamp)ts0a) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (this.ts0.compareTo((ITmfTimestamp)ts0b) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (this.ts0.compareTo((ITmfTimestamp)ts0c) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (this.ts0.compareTo((ITmfTimestamp)ts0d) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToCornerCases2() {
        TmfTimestamp ts0a = new TmfTimestamp(Long.MAX_VALUE, 0x7FFFFFFE);
        TmfTimestamp ts0b = new TmfTimestamp(0L, Integer.MAX_VALUE);
        TmfTimestamp ts0c = new TmfTimestamp(Long.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertTrue((String)"compareTo", (ts0a.compareTo((ITmfTimestamp)ts0b) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0a.compareTo((ITmfTimestamp)ts0c) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0b.compareTo((ITmfTimestamp)ts0a) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0b.compareTo((ITmfTimestamp)ts0c) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0c.compareTo((ITmfTimestamp)ts0a) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0c.compareTo((ITmfTimestamp)ts0b) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToCornerCases3() {
        TmfTimestamp ts0a = new TmfTimestamp(Long.MIN_VALUE, 0x7FFFFFFE);
        TmfTimestamp ts0b = new TmfTimestamp(0L, Integer.MAX_VALUE);
        TmfTimestamp ts0c = new TmfTimestamp(Long.MIN_VALUE, Integer.MAX_VALUE);
        Assert.assertTrue((String)"compareTo", (ts0a.compareTo((ITmfTimestamp)ts0b) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0a.compareTo((ITmfTimestamp)ts0c) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0b.compareTo((ITmfTimestamp)ts0a) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0b.compareTo((ITmfTimestamp)ts0c) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0c.compareTo((ITmfTimestamp)ts0a) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"compareTo", (ts0c.compareTo((ITmfTimestamp)ts0b) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToCornerCases4() {
        Assert.assertTrue((String)"compareTo", (this.ts0.compareTo(null) == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToSameScale() {
        TmfTimestamp t1 = new TmfTimestamp(900L, 0);
        TmfTimestamp t2 = new TmfTimestamp(1000L, 0);
        TmfTimestamp t3 = new TmfTimestamp(1100L, 0);
        TmfTimestamp t4 = new TmfTimestamp(1000L, 0);
        Assert.assertTrue((t1.compareTo((ITmfTimestamp)t1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo((ITmfTimestamp)t2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo((ITmfTimestamp)t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo((ITmfTimestamp)t4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo((ITmfTimestamp)t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo((ITmfTimestamp)t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo((ITmfTimestamp)t4) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo((ITmfTimestamp)t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo((ITmfTimestamp)t2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo((ITmfTimestamp)t4) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToDifferentScale() {
        TmfTimestamp t1 = new TmfTimestamp(9000L, -1);
        TmfTimestamp t2 = new TmfTimestamp(1000L, 0);
        TmfTimestamp t3 = new TmfTimestamp(110L, 1);
        TmfTimestamp t4 = new TmfTimestamp(1L, 3);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo((ITmfTimestamp)t1) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo((ITmfTimestamp)t2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo((ITmfTimestamp)t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo((ITmfTimestamp)t4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo((ITmfTimestamp)t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo((ITmfTimestamp)t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo((ITmfTimestamp)t4) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo((ITmfTimestamp)t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo((ITmfTimestamp)t2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo((ITmfTimestamp)t4) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToLargeScale1() {
        TmfTimestamp t1 = new TmfTimestamp(-1L, 100);
        TmfTimestamp t2 = new TmfTimestamp(-1000L, -100);
        TmfTimestamp t3 = new TmfTimestamp(1L, 100);
        TmfTimestamp t4 = new TmfTimestamp(1000L, -100);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo((ITmfTimestamp)t2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo((ITmfTimestamp)t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t1.compareTo((ITmfTimestamp)t4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo((ITmfTimestamp)t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo((ITmfTimestamp)t3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t2.compareTo((ITmfTimestamp)t4) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo((ITmfTimestamp)t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo((ITmfTimestamp)t2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t3.compareTo((ITmfTimestamp)t4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t4.compareTo((ITmfTimestamp)t1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t4.compareTo((ITmfTimestamp)t2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (t4.compareTo((ITmfTimestamp)t3) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareToLargeScale2() {
        TmfTimestamp ts0a = new TmfTimestamp(0L, Integer.MAX_VALUE);
        TmfTimestamp ts0b = new TmfTimestamp(1L, Integer.MAX_VALUE);
        Assert.assertTrue((String)"CompareTo", (ts0a.compareTo(this.ts0) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts0.compareTo((ITmfTimestamp)ts0a) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (ts0b.compareTo(this.ts0) == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"CompareTo", (this.ts0.compareTo((ITmfTimestamp)ts0b) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testDelta() {
        TmfTimestamp t0 = new TmfTimestamp(10L, 9);
        TmfTimestamp t1 = new TmfTimestamp(5L, 9);
        TmfTimestamp exp = new TmfTimestamp(5L, 9);
        ITmfTimestamp delta = t0.getDelta((ITmfTimestamp)t1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo((ITmfTimestamp)exp));
        t0 = new TmfTimestamp(5L, 9);
        t1 = new TmfTimestamp(10L, 9);
        exp = new TmfTimestamp(-5L, 9);
        delta = t0.getDelta((ITmfTimestamp)t1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo((ITmfTimestamp)exp));
        t0 = new TmfTimestamp(5L, 9);
        t1 = new TmfTimestamp(10L, 8);
        exp = new TmfTimestamp(4L, 9);
        delta = t0.getDelta((ITmfTimestamp)t1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo((ITmfTimestamp)exp));
        t0 = new TmfTimestamp(5L, 9);
        t1 = new TmfTimestamp(10L, 7);
        exp = new TmfTimestamp(5L, 9);
        delta = t0.getDelta((ITmfTimestamp)t1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo((ITmfTimestamp)exp));
        t0 = new TmfTimestamp(10L, 9);
        t1 = new TmfTimestamp(5L, 8);
        exp = new TmfTimestamp(10L, 9);
        delta = t0.getDelta((ITmfTimestamp)t1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo((ITmfTimestamp)exp));
        t0 = new TmfTimestamp(10L, 9);
        t1 = new TmfTimestamp(5L, 9);
        exp = new TmfTimestamp(5L, 9);
        delta = t0.getDelta((ITmfTimestamp)t1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo((ITmfTimestamp)exp));
        t0 = new TmfTimestamp(5L, 9);
        t1 = new TmfTimestamp(10L, 8);
        exp = new TmfTimestamp(4L, 9);
        delta = t0.getDelta((ITmfTimestamp)t1);
        Assert.assertEquals((String)"getDelta", (long)0L, (long)delta.compareTo((ITmfTimestamp)exp));
    }
}

