/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.statesystem.mipmap;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap.AbstractTmfMipmapStateProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;

class TmfMipmapStateProviderStub
extends AbstractTmfMipmapStateProvider {
    public static final String TEST_ATTRIBUTE_NAME = "test_attribute";
    private int resolution;
    private ITmfStateValue.Type type;
    @NonNull
    private static final String MIPMAP_ID = "MIPMAP_ID";
    private final String ERROR_ATTRIBUTE_NOT_FOUND = "Error : Impossible to find the attribute";
    private final String ERROR_INVALID_STATE_VALUE = "Error : Invalid state value";
    private final String ERROR_INVALID_TIMESTAMP = "Error : Invalid timestamp";

    public TmfMipmapStateProviderStub(int resolution, ITmfStateValue.Type type) {
        super((ITmfTrace)new TmfTraceStub(), MIPMAP_ID);
        this.resolution = resolution;
        this.type = type;
    }

    protected void eventHandle(ITmfEvent ev) {
        ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        long ts = ev.getTimestamp().normalize(0L, -9).getValue();
        try {
            int quark = ss.getQuarkAbsoluteAndAdd(new String[]{TEST_ATTRIBUTE_NAME});
            ITmfStateValue value = (ITmfStateValue)ev.getContent().getValue();
            this.modifyMipmapAttribute(ts, value, quark, 14, this.resolution);
        }
        catch (TimeRangeException e) {
            Activator.logError((String)"Error : Invalid timestamp", (Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            Activator.logError((String)"Error : Impossible to find the attribute", (Throwable)e);
        }
        catch (StateValueTypeException e) {
            Activator.logError((String)"Error : Invalid state value", (Throwable)e);
        }
    }

    public int getVersion() {
        return 0;
    }

    public TmfMipmapStateProviderStub getNewInstance() {
        return new TmfMipmapStateProviderStub(this.resolution, this.type);
    }

    @NonNull
    public ITmfEvent createEvent(long time, Long longVal) {
        TmfStateValue value = longVal == null ? TmfStateValue.nullValue() : (this.type == ITmfStateValue.Type.LONG ? TmfStateValue.newValueLong((long)longVal) : (this.type == ITmfStateValue.Type.INTEGER ? TmfStateValue.newValueInt((int)longVal.intValue()) : (this.type == ITmfStateValue.Type.DOUBLE ? TmfStateValue.newValueDouble((double)longVal.doubleValue()) : TmfStateValue.nullValue())));
        TmfNanoTimestamp timestamp = new TmfNanoTimestamp(time);
        TmfEventType eventType = new TmfEventType(MIPMAP_ID, null);
        TmfEventField content = new TmfEventField(":root:", (Object)value, null);
        TmfEvent event = new TmfEvent(null, -1L, (ITmfTimestamp)timestamp, (ITmfEventType)eventType, (ITmfEventField)content);
        return event;
    }
}

