/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.statesystem.mipmap;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.statesystem.mipmap.TmfStateSystemOperations;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemFactory;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.backend.StateHistoryBackendFactory;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.tests.statesystem.mipmap.TmfMipmapStateProviderStub;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TmfMipmapStateProviderWeightedTest {
    @NonNull
    private static final String SSID = "mipmap-test";
    private static final String TEST_ATTRIBUTE_NAME = "test_attribute";
    private static final long END_TIME = 250000L;
    private static final long INTERVAL = 1000L;
    private static final int RESOLUTION = 2;
    private static final double DELTA = 1.0E-4;
    private static ITmfStateSystemBuilder ssqi;
    private static ITmfStateSystemBuilder ssqd;

    @BeforeClass
    public static void init() {
        TmfMipmapStateProviderStub mmpi = new TmfMipmapStateProviderStub(2, ITmfStateValue.Type.INTEGER);
        IStateHistoryBackend bei = StateHistoryBackendFactory.createInMemoryBackend((String)SSID, (long)0L);
        ITmfStateSystemBuilder ssbi = StateSystemFactory.newStateSystem((IStateHistoryBackend)bei);
        mmpi.assignTargetStateSystem(ssbi);
        ssqi = ssbi;
        TmfMipmapStateProviderStub mmpd = new TmfMipmapStateProviderStub(2, ITmfStateValue.Type.DOUBLE);
        IStateHistoryBackend bed = StateHistoryBackendFactory.createInMemoryBackend((String)SSID, (long)0L);
        ITmfStateSystemBuilder ssbd = StateSystemFactory.newStateSystem((IStateHistoryBackend)bed);
        mmpd.assignTargetStateSystem(ssbd);
        ssqd = ssbd;
        int i = 0;
        while ((long)i < 25L) {
            long time = (long)(i * 10) * 1000L;
            mmpi.processEvent(mmpi.createEvent(time, null));
            mmpi.processEvent(mmpi.createEvent(time + 1000L, 10L));
            mmpi.processEvent(mmpi.createEvent(time + 2000L, null));
            mmpi.processEvent(mmpi.createEvent(time + 3000L, 20L));
            mmpi.processEvent(mmpi.createEvent(time + 5000L, null));
            mmpi.processEvent(mmpi.createEvent(time + 6000L, 30L));
            mmpi.processEvent(mmpi.createEvent(time + 9000L, null));
            mmpd.processEvent(mmpd.createEvent(time, null));
            mmpd.processEvent(mmpd.createEvent(time + 1000L, 10L));
            mmpd.processEvent(mmpd.createEvent(time + 2000L, null));
            mmpd.processEvent(mmpd.createEvent(time + 3000L, 20L));
            mmpd.processEvent(mmpd.createEvent(time + 5000L, null));
            mmpd.processEvent(mmpd.createEvent(time + 6000L, 30L));
            mmpd.processEvent(mmpd.createEvent(time + 9000L, null));
            ++i;
        }
        mmpi.processEvent(mmpi.createEvent(250000L, 0L));
        mmpi.dispose();
        ssqi.waitUntilBuilt();
        mmpd.processEvent(mmpd.createEvent(250000L, 0L));
        mmpd.dispose();
        ssqd.waitUntilBuilt();
    }

    @Test
    public void testQueryMipmapRangeMaxInteger() {
        Assert.assertNotNull((Object)ssqi);
        try {
            int quark = ssqi.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME});
            Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqi, (long)0L, (long)0L, (int)quark));
            Assert.assertEquals((long)10L, (long)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqi, (long)500L, (long)1500L, (int)quark).unboxInt());
            Assert.assertEquals((long)20L, (long)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqi, (long)1500L, (long)5000L, (int)quark).unboxInt());
            Assert.assertEquals((long)30L, (long)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqi, (long)5000L, (long)10000L, (int)quark).unboxInt());
            Assert.assertEquals((long)30L, (long)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqi, (long)0L, (long)10000L, (int)quark).unboxInt());
            Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqi, (long)120000L, (long)120000L, (int)quark));
            Assert.assertEquals((long)10L, (long)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqi, (long)120500L, (long)121500L, (int)quark).unboxInt());
            Assert.assertEquals((long)20L, (long)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqi, (long)121500L, (long)125000L, (int)quark).unboxInt());
            Assert.assertEquals((long)30L, (long)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqi, (long)125000L, (long)130000L, (int)quark).unboxInt());
            Assert.assertEquals((long)30L, (long)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqi, (long)120000L, (long)130000L, (int)quark).unboxInt());
            Assert.assertEquals((long)30L, (long)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqi, (long)100000L, (long)150000L, (int)quark).unboxInt());
            Assert.assertEquals((long)30L, (long)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqi, (long)240000L, (long)250000L, (int)quark).unboxInt());
            Assert.assertEquals((long)30L, (long)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqi, (long)0L, (long)250000L, (int)quark).unboxInt());
            Assert.assertEquals((long)0L, (long)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqi, (long)250000L, (long)250000L, (int)quark).unboxInt());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testQueryMipmapRangeMinInteger() {
        Assert.assertNotNull((Object)ssqi);
        try {
            int quark = ssqi.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME});
            Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqi, (long)0L, (long)0L, (int)quark));
            Assert.assertEquals((long)10L, (long)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqi, (long)500L, (long)1500L, (int)quark).unboxInt());
            Assert.assertEquals((long)10L, (long)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqi, (long)1500L, (long)5000L, (int)quark).unboxInt());
            Assert.assertEquals((long)30L, (long)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqi, (long)5000L, (long)10000L, (int)quark).unboxInt());
            Assert.assertEquals((long)10L, (long)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqi, (long)0L, (long)10000L, (int)quark).unboxInt());
            Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqi, (long)120000L, (long)120000L, (int)quark));
            Assert.assertEquals((long)10L, (long)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqi, (long)120500L, (long)121500L, (int)quark).unboxInt());
            Assert.assertEquals((long)10L, (long)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqi, (long)121500L, (long)125000L, (int)quark).unboxInt());
            Assert.assertEquals((long)30L, (long)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqi, (long)125000L, (long)130000L, (int)quark).unboxInt());
            Assert.assertEquals((long)10L, (long)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqi, (long)120000L, (long)130000L, (int)quark).unboxInt());
            Assert.assertEquals((long)10L, (long)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqi, (long)100000L, (long)150000L, (int)quark).unboxInt());
            Assert.assertEquals((long)0L, (long)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqi, (long)240000L, (long)250000L, (int)quark).unboxInt());
            Assert.assertEquals((long)0L, (long)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqi, (long)0L, (long)250000L, (int)quark).unboxInt());
            Assert.assertEquals((long)0L, (long)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqi, (long)250000L, (long)250000L, (int)quark).unboxInt());
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testQueryMipmapRangeAvgInteger() {
        Assert.assertNotNull((Object)ssqi);
        try {
            int quark = ssqi.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME});
            Assert.assertEquals((double)0.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)0L, (long)0L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)5.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)500L, (long)1500L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)12.857142857142858, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)1500L, (long)5000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)18.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)5000L, (long)10000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)0L, (long)10000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)0L, (long)20000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)500L, (long)20500L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)1000L, (long)21000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)2000L, (long)22000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)3000L, (long)23000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)4000L, (long)24000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)5000L, (long)25000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)0.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)120000L, (long)120000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)5.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)120500L, (long)121500L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)12.857142857142858, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)121500L, (long)125000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)18.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)125000L, (long)130000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)120000L, (long)130000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)100000L, (long)150000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)240000L, (long)250000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)0L, (long)250000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)0.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqi, (long)250000L, (long)250000L, (int)quark), (double)1.0E-4);
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testQueryMipmapRangeMaxDouble() {
        Assert.assertNotNull((Object)ssqd);
        try {
            int quark = ssqd.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME});
            Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqd, (long)0L, (long)0L, (int)quark));
            Assert.assertEquals((double)10.0, (double)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqd, (long)500L, (long)1500L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)20.0, (double)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqd, (long)1500L, (long)5000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)30.0, (double)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqd, (long)5000L, (long)10000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)30.0, (double)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqd, (long)0L, (long)10000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqd, (long)120000L, (long)120000L, (int)quark));
            Assert.assertEquals((double)10.0, (double)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqd, (long)120500L, (long)121500L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)20.0, (double)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqd, (long)121500L, (long)125000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)30.0, (double)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqd, (long)125000L, (long)130000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)30.0, (double)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqd, (long)120000L, (long)130000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)30.0, (double)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqd, (long)100000L, (long)150000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)30.0, (double)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqd, (long)240000L, (long)250000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)30.0, (double)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqd, (long)0L, (long)250000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)0.0, (double)TmfStateSystemOperations.queryRangeMax((ITmfStateSystem)ssqd, (long)250000L, (long)250000L, (int)quark).unboxDouble(), (double)1.0E-4);
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testQueryMipmapRangeMinDouble() {
        Assert.assertNotNull((Object)ssqd);
        try {
            int quark = ssqd.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME});
            Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqd, (long)0L, (long)0L, (int)quark));
            Assert.assertEquals((double)10.0, (double)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqd, (long)500L, (long)1500L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)10.0, (double)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqd, (long)1500L, (long)5000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)30.0, (double)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqd, (long)5000L, (long)10000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)10.0, (double)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqd, (long)0L, (long)10000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((Object)TmfStateValue.nullValue(), (Object)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqd, (long)120000L, (long)120000L, (int)quark));
            Assert.assertEquals((double)10.0, (double)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqd, (long)120500L, (long)121500L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)10.0, (double)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqd, (long)121500L, (long)125000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)30.0, (double)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqd, (long)125000L, (long)130000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)10.0, (double)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqd, (long)120000L, (long)130000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)10.0, (double)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqd, (long)100000L, (long)150000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)0.0, (double)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqd, (long)240000L, (long)250000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)0.0, (double)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqd, (long)0L, (long)250000L, (int)quark).unboxDouble(), (double)1.0E-4);
            Assert.assertEquals((double)0.0, (double)TmfStateSystemOperations.queryRangeMin((ITmfStateSystem)ssqd, (long)250000L, (long)250000L, (int)quark).unboxDouble(), (double)1.0E-4);
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testQueryMipmapRangeAvgDouble() {
        Assert.assertNotNull((Object)ssqd);
        try {
            int quark = ssqd.getQuarkAbsolute(new String[]{TEST_ATTRIBUTE_NAME});
            Assert.assertEquals((double)0.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)0L, (long)0L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)5.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)500L, (long)1500L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)12.857142857142858, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)1500L, (long)5000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)18.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)5000L, (long)10000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)0L, (long)10000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)0L, (long)20000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)500L, (long)20500L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)1000L, (long)21000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)2000L, (long)22000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)3000L, (long)23000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)4000L, (long)24000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)5000L, (long)25000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)0.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)120000L, (long)120000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)5.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)120500L, (long)121500L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)12.857142857142858, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)121500L, (long)125000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)18.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)125000L, (long)130000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)120000L, (long)130000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)100000L, (long)150000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)240000L, (long)250000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)14.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)0L, (long)250000L, (int)quark), (double)1.0E-4);
            Assert.assertEquals((double)0.0, (double)TmfStateSystemOperations.queryRangeAverage((ITmfStateSystem)ssqd, (long)250000L, (long)250000L, (int)quark), (double)1.0E-4);
        }
        catch (AttributeNotFoundException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (TimeRangeException e) {
            Assert.fail((String)e.getMessage());
        }
        catch (StateValueTypeException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

