/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.tracecompass.internal.tmf.core.component.TmfProviderManager;
import org.eclipse.tracecompass.internal.tmf.core.trace.experiment.TmfExperimentContext;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestTrace;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;
import org.eclipse.tracecompass.tmf.tests.stubs.analysis.TestExperimentAnalysis;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfExperimentStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfTraceStub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class TmfExperimentTest {
    private static final String EXPERIMENT = "MyExperiment";
    private static int NB_EVENTS = 10000;
    private static int BLOCK_SIZE = 1000;
    private static final double DELTA = 1.0E-15;
    private ITmfTrace[] fTestTraces;
    private TmfExperimentStub fExperiment;
    private static byte SCALE = (byte)-3;

    private synchronized ITmfTrace[] setupTrace(String path) {
        if (this.fTestTraces == null) {
            this.fTestTraces = new ITmfTrace[1];
            try {
                URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(path), null);
                File test = new File(FileLocator.toFileURL((URL)location).toURI());
                TmfTraceStub trace = new TmfTraceStub(test.getPath(), 0, true, null);
                this.fTestTraces[0] = trace;
            }
            catch (TmfTraceException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.fTestTraces;
    }

    private synchronized void setupExperiment() {
        if (this.fExperiment == null) {
            this.fExperiment = new TmfExperimentStub(EXPERIMENT, this.fTestTraces, BLOCK_SIZE);
            this.fExperiment.getIndexer().buildIndex(0L, TmfTimeRange.ETERNITY, true);
        }
    }

    @Before
    public void setUp() {
        this.setupTrace(TmfTestTrace.A_TEST_10K.getFullPath());
        this.setupExperiment();
    }

    @After
    public void tearDown() {
        if (this.fExperiment != null) {
            this.fExperiment.dispose();
        }
        Assert.assertEquals((long)0L, (long)TmfProviderManager.getProviders(ITmfEvent.class).length);
    }

    @Test
    public void testSimpleTmfExperimentConstructor() {
        TmfExperiment experiment = new TmfExperiment(ITmfEvent.class, EXPERIMENT, this.fTestTraces, 5000, null);
        Assert.assertEquals((String)"GetId", (Object)EXPERIMENT, (Object)experiment.getName());
        Assert.assertEquals((String)"GetCacheSize", (long)5000L, (long)experiment.getCacheSize());
        experiment.dispose();
        experiment = new TmfExperiment(ITmfEvent.class, EXPERIMENT, null, 5000, null);
        experiment.dispose();
    }

    @Test
    public void testNormalTmfExperimentConstructor() {
        Assert.assertEquals((String)"GetId", (Object)EXPERIMENT, (Object)this.fExperiment.getName());
        Assert.assertEquals((String)"GetNbEvents", (long)NB_EVENTS, (long)this.fExperiment.getNbEvents());
        long nbExperimentEvents = this.fExperiment.getNbEvents();
        Assert.assertEquals((String)"GetNbEvents", (long)NB_EVENTS, (long)nbExperimentEvents);
        long nbTraceEvents = ((ITmfTrace)this.fExperiment.getTraces().get(0)).getNbEvents();
        Assert.assertEquals((String)"GetNbEvents", (long)NB_EVENTS, (long)nbTraceEvents);
        TmfTimeRange timeRange = this.fExperiment.getTimeRange();
        Assert.assertEquals((String)"getStartTime", (long)1L, (long)timeRange.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)NB_EVENTS, (long)timeRange.getEndTime().getValue());
    }

    @Test
    public void testExperimentInitialization() {
        TmfExperimentStub experiment = new TmfExperimentStub(EXPERIMENT, this.fTestTraces, 5000);
        experiment.getIndexer().buildIndex(0L, TmfTimeRange.ETERNITY, true);
        Assert.assertEquals((String)"GetId", (Object)EXPERIMENT, (Object)this.fExperiment.getName());
        Assert.assertEquals((String)"GetNbEvents", (long)NB_EVENTS, (long)this.fExperiment.getNbEvents());
        long nbExperimentEvents = this.fExperiment.getNbEvents();
        Assert.assertEquals((String)"GetNbEvents", (long)NB_EVENTS, (long)nbExperimentEvents);
        long nbTraceEvents = ((ITmfTrace)this.fExperiment.getTraces().get(0)).getNbEvents();
        Assert.assertEquals((String)"GetNbEvents", (long)NB_EVENTS, (long)nbTraceEvents);
        TmfTimeRange timeRange = this.fExperiment.getTimeRange();
        Assert.assertEquals((String)"getStartTime", (long)1L, (long)timeRange.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)NB_EVENTS, (long)timeRange.getEndTime().getValue());
        experiment.dispose();
    }

    @Test
    public void testGetTimestamp() {
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(1L, -3), (Object)this.fExperiment.getTimestamp(0));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(2L, -3), (Object)this.fExperiment.getTimestamp(1));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(11L, -3), (Object)this.fExperiment.getTimestamp(10));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(101L, -3), (Object)this.fExperiment.getTimestamp(100));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(1001L, -3), (Object)this.fExperiment.getTimestamp(1000));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(2001L, -3), (Object)this.fExperiment.getTimestamp(2000));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(2501L, -3), (Object)this.fExperiment.getTimestamp(2500));
        Assert.assertEquals((String)"getTimestamp", (Object)new TmfTimestamp(10000L, -3), (Object)this.fExperiment.getTimestamp(9999));
        Assert.assertNull((String)"getTimestamp", (Object)this.fExperiment.getTimestamp(10000));
    }

    @Test
    public void testGetAnalysisModules() {
        TmfExperimentStub experiment = this.fExperiment;
        Assert.assertNotNull((Object)((Object)experiment));
        Iterable modules = experiment.getAnalysisModules();
        Assert.assertFalse((boolean)modules.iterator().hasNext());
        experiment.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)experiment, null));
        modules = experiment.getAnalysisModules();
        Iterable testModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)experiment, TestExperimentAnalysis.class);
        Assert.assertTrue((boolean)modules.iterator().hasNext());
        Assert.assertTrue((boolean)testModules.iterator().hasNext());
    }

    @Test
    public void testSeekBadLocation() {
        ITmfContext context = this.fExperiment.seekEvent((ITmfLocation)new TmfLongLocation(0L));
        Assert.assertNull((String)"seekEvent", (Object)context);
    }

    @Test
    public void testSeekNoTrace() {
        TmfExperiment experiment = new TmfExperiment(ITmfEvent.class, EXPERIMENT, null, 5000, null);
        ITmfContext context = experiment.seekEvent(null);
        TmfExperimentTest.validateContextRanks(context);
        experiment.dispose();
    }

    @Test
    public void testSeekEventOnRatio() {
        ITmfContext context = this.fExperiment.seekEvent(0.0);
        Assert.assertEquals((String)"Context rank", (long)0L, (long)context.getRank());
        ITmfEvent event = this.fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)0L, (long)context.getRank());
        int midTrace = NB_EVENTS / 2;
        context = this.fExperiment.seekEvent(0.5);
        Assert.assertEquals((String)"Context rank", (long)midTrace, (long)context.getRank());
        event = this.fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)(midTrace + 1), (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)midTrace, (long)context.getRank());
        context = this.fExperiment.seekEvent(1.0);
        Assert.assertEquals((String)"Context rank", (long)NB_EVENTS, (long)context.getRank());
        event = this.fExperiment.parseEvent(context);
        Assert.assertNull((String)"Event timestamp", (Object)event);
        Assert.assertEquals((String)"Context rank", (long)NB_EVENTS, (long)context.getRank());
        context = this.fExperiment.seekEvent(1.1);
        Assert.assertEquals((String)"Context rank", (long)NB_EVENTS, (long)context.getRank());
        event = this.fExperiment.parseEvent(context);
        Assert.assertNull((String)"Event timestamp", (Object)event);
        Assert.assertEquals((String)"Context rank", (long)NB_EVENTS, (long)context.getRank());
        context = this.fExperiment.seekEvent(-0.5);
        Assert.assertEquals((String)"Context rank", (long)0L, (long)context.getRank());
        event = this.fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)0L, (long)context.getRank());
    }

    @Test
    public void testGetLocationRatio() {
        ITmfContext context = this.fExperiment.seekEvent(null);
        double ratio = this.fExperiment.getLocationRatio(context.getLocation());
        Assert.assertEquals((String)"getLocationRatio", (double)0.0, (double)ratio, (double)1.0E-15);
        context = this.fExperiment.seekEvent(NB_EVENTS / 2);
        ratio = this.fExperiment.getLocationRatio(context.getLocation());
        Assert.assertEquals((String)"getLocationRatio", (double)((double)(NB_EVENTS / 2) / (double)NB_EVENTS), (double)ratio, (double)1.0E-15);
        context = this.fExperiment.seekEvent(NB_EVENTS - 1);
        ratio = this.fExperiment.getLocationRatio(context.getLocation());
        Assert.assertEquals((String)"getLocationRatio", (double)((double)(NB_EVENTS - 1) / (double)NB_EVENTS), (double)ratio, (double)1.0E-15);
    }

    @Test
    public void testSeekRankOnCacheBoundary() {
        long cacheSize = this.fExperiment.getCacheSize();
        ITmfContext context = this.fExperiment.seekEvent(0L);
        Assert.assertEquals((String)"Context rank", (long)0L, (long)context.getRank());
        ITmfEvent event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)1L, (long)context.getRank());
        context = this.fExperiment.seekEvent(cacheSize);
        Assert.assertEquals((String)"Context rank", (long)cacheSize, (long)context.getRank());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(cacheSize + 1L), (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)(cacheSize + 1L), (long)context.getRank());
        context = this.fExperiment.seekEvent(4L * cacheSize);
        Assert.assertEquals((String)"Context rank", (long)(4L * cacheSize), (long)context.getRank());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(4L * cacheSize + 1L), (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)(4L * cacheSize + 1L), (long)context.getRank());
    }

    @Test
    public void testSeekRankNotOnCacheBoundary() {
        long cacheSize = this.fExperiment.getCacheSize();
        ITmfContext context = this.fExperiment.seekEvent(9L);
        Assert.assertEquals((String)"Context rank", (long)9L, (long)context.getRank());
        ITmfEvent event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)10L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)10L, (long)context.getRank());
        context = this.fExperiment.seekEvent(cacheSize - 1L);
        Assert.assertEquals((String)"Context rank", (long)(cacheSize - 1L), (long)context.getRank());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)cacheSize, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)cacheSize, (long)context.getRank());
        context = this.fExperiment.seekEvent(cacheSize + 1L);
        Assert.assertEquals((String)"Context rank", (long)(cacheSize + 1L), (long)context.getRank());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(cacheSize + 2L), (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)(cacheSize + 2L), (long)context.getRank());
        context = this.fExperiment.seekEvent(4500L);
        Assert.assertEquals((String)"Context rank", (long)4500L, (long)context.getRank());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)4501L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)4501L, (long)context.getRank());
    }

    @Test
    public void testSeekRankOutOfScope() {
        ITmfContext context = this.fExperiment.seekEvent(-1L);
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        ITmfEvent event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)1L, (long)context.getRank());
        context = this.fExperiment.seekEvent(NB_EVENTS);
        Assert.assertEquals((String)"Context rank", (long)NB_EVENTS, (long)context.getRank());
        event = this.fExperiment.getNext(context);
        Assert.assertNull((String)"Event", (Object)event);
        Assert.assertEquals((String)"Context rank", (long)NB_EVENTS, (long)context.getRank());
    }

    @Test
    public void testSeekTimestampOnCacheBoundary() {
        long cacheSize = this.fExperiment.getCacheSize();
        ITmfContext context = this.fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(1L, (int)SCALE));
        Assert.assertEquals((String)"Context rank", (long)0L, (long)context.getRank());
        ITmfEvent event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)1L, (long)context.getRank());
        context = this.fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(cacheSize + 1L, (int)SCALE));
        Assert.assertEquals((String)"Event rank", (long)cacheSize, (long)context.getRank());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(cacheSize + 1L), (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)(cacheSize + 1L), (long)context.getRank());
        context = this.fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(4L * cacheSize + 1L, (int)SCALE));
        Assert.assertEquals((String)"Context rank", (long)(4L * cacheSize), (long)context.getRank());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(4L * cacheSize + 1L), (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)(4L * cacheSize + 1L), (long)context.getRank());
    }

    @Test
    public void testSeekTimestampNotOnCacheBoundary() {
        ITmfContext context = this.fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(2L, (int)SCALE));
        Assert.assertEquals((String)"Context rank", (long)1L, (long)context.getRank());
        ITmfEvent event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)2L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)2L, (long)context.getRank());
        context = this.fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(10L, (int)SCALE));
        Assert.assertEquals((String)"Context rank", (long)9L, (long)context.getRank());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)10L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)10L, (long)context.getRank());
        context = this.fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(1000L, (int)SCALE));
        Assert.assertEquals((String)"Context rank", (long)999L, (long)context.getRank());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1000L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)1000L, (long)context.getRank());
        context = this.fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(1002L, (int)SCALE));
        Assert.assertEquals((String)"Context rank", (long)1001L, (long)context.getRank());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1002L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)1002L, (long)context.getRank());
        context = this.fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(4501L, (int)SCALE));
        Assert.assertEquals((String)"Context rank", (long)4500L, (long)context.getRank());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)4501L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Context rank", (long)4501L, (long)context.getRank());
    }

    @Test
    public void testSeekTimestampOutOfScope() {
        ITmfContext context = this.fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(-1L, (int)SCALE));
        Assert.assertEquals((String)"Event rank", (long)0L, (long)context.getRank());
        ITmfEvent event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)1L, (long)context.getRank());
        context = this.fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp((long)(NB_EVENTS + 1), (int)SCALE));
        event = this.fExperiment.getNext(context);
        Assert.assertNull((String)"Event location", (Object)event);
        Assert.assertEquals((String)"Event rank", (long)-1L, (long)context.getRank());
    }

    @Test
    public void testSeekLocationOnCacheBoundary() {
        long cacheSize = this.fExperiment.getCacheSize();
        ITmfContext tmpContext = this.fExperiment.seekEvent(0L);
        ITmfContext context = this.fExperiment.seekEvent(tmpContext.getLocation());
        ITmfEvent event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)2L, (long)event.getTimestamp().getValue());
        tmpContext = this.fExperiment.seekEvent(cacheSize);
        context = this.fExperiment.seekEvent(tmpContext.getLocation());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(cacheSize + 1L), (long)event.getTimestamp().getValue());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(cacheSize + 2L), (long)event.getTimestamp().getValue());
        tmpContext = this.fExperiment.seekEvent(4L * cacheSize);
        context = this.fExperiment.seekEvent(tmpContext.getLocation());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(4L * cacheSize + 1L), (long)event.getTimestamp().getValue());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(4L * cacheSize + 2L), (long)event.getTimestamp().getValue());
    }

    @Test
    public void testSeekLocationNotOnCacheBoundary() {
        long cacheSize = this.fExperiment.getCacheSize();
        ITmfContext tmpContext = this.fExperiment.seekEvent(cacheSize - 1L);
        ITmfContext context = this.fExperiment.seekEvent(tmpContext.getLocation());
        ITmfEvent event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)cacheSize, (long)event.getTimestamp().getValue());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(cacheSize + 1L), (long)event.getTimestamp().getValue());
        tmpContext = this.fExperiment.seekEvent(2L * cacheSize - 1L);
        context = this.fExperiment.seekEvent(tmpContext.getLocation());
        context = this.fExperiment.seekEvent(2L * cacheSize - 1L);
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(2L * cacheSize), (long)event.getTimestamp().getValue());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)(2L * cacheSize + 1L), (long)event.getTimestamp().getValue());
        tmpContext = this.fExperiment.seekEvent(4500L);
        context = this.fExperiment.seekEvent(tmpContext.getLocation());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)4501L, (long)event.getTimestamp().getValue());
        event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)4502L, (long)event.getTimestamp().getValue());
    }

    @Test
    public void testSeekLocationOutOfScope() {
        ITmfContext context = this.fExperiment.seekEvent(null);
        ITmfEvent event = this.fExperiment.getNext(context);
        Assert.assertEquals((String)"Event timestamp", (long)1L, (long)event.getTimestamp().getValue());
    }

    private static void validateContextRanks(ITmfContext context) {
        Assert.assertTrue((String)"Experiment context type", (boolean)(context instanceof TmfExperimentContext));
        TmfExperimentContext ctx = (TmfExperimentContext)context;
        int nbTraces = ctx.getNbTraces();
        long expRank = -nbTraces + (ctx.getLastTrace() != -1 ? 1 : 0);
        int i = 0;
        while (i < nbTraces) {
            ITmfContext subContext = ctx.getContext(i);
            Assert.assertNotNull((Object)subContext);
            long rank = subContext.getRank();
            if (rank == -1L) {
                expRank = -1L;
                break;
            }
            expRank += rank;
            ++i;
        }
        Assert.assertEquals((String)"Experiment context rank", (long)expRank, (long)ctx.getRank());
    }

    @Test
    public void testGetNextAfteSeekingOnTS_1() {
        ITmfEvent event;
        long INITIAL_TS = 1L;
        int NB_READS = 20;
        ITmfContext context = this.fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(1L, (int)SCALE));
        TmfExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = this.fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(1L + (long)i), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(1L + (long)i), (long)context.getRank());
            ++i;
        }
        event = this.fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)21L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)20L, (long)context.getRank());
        TmfExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfteSeekingOnTS_2() {
        ITmfEvent event;
        long INITIAL_TS = 2L;
        int NB_READS = 20;
        ITmfContext context = this.fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(2L, (int)SCALE));
        TmfExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = this.fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(2L + (long)i), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(2L + (long)i), (long)context.getRank());
            ++i;
        }
        event = this.fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)22L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)21L, (long)context.getRank());
        TmfExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfteSeekingOnTS_3() {
        ITmfEvent event;
        long INITIAL_TS = 500L;
        int NB_READS = 20;
        ITmfContext context = this.fExperiment.seekEvent((ITmfTimestamp)new TmfTimestamp(500L, (int)SCALE));
        TmfExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = this.fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(500L + (long)i), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(500L + (long)i), (long)context.getRank());
            ++i;
        }
        event = this.fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)520L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)519L, (long)context.getRank());
        TmfExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfterSeekingOnRank_1() {
        ITmfEvent event;
        long INITIAL_RANK = 0L;
        int NB_READS = 20;
        ITmfContext context = this.fExperiment.seekEvent(0L);
        TmfExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = this.fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(0L + (long)i + 1L), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(0L + (long)i + 1L), (long)context.getRank());
            ++i;
        }
        event = this.fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)21L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)20L, (long)context.getRank());
        TmfExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfterSeekingOnRank_2() {
        ITmfEvent event;
        long INITIAL_RANK = 1L;
        int NB_READS = 20;
        ITmfContext context = this.fExperiment.seekEvent(1L);
        TmfExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = this.fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(1L + (long)i + 1L), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(1L + (long)i + 1L), (long)context.getRank());
            ++i;
        }
        event = this.fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)22L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)21L, (long)context.getRank());
        TmfExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfterSeekingOnRank_3() {
        ITmfEvent event;
        long INITIAL_RANK = 500L;
        int NB_READS = 20;
        ITmfContext context = this.fExperiment.seekEvent(500L);
        TmfExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = this.fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(500L + (long)i + 1L), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(500L + (long)i + 1L), (long)context.getRank());
            ++i;
        }
        event = this.fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)521L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)520L, (long)context.getRank());
        TmfExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfterSeekingOnLocation_1() {
        ITmfEvent event;
        ITmfLocation INITIAL_LOC = null;
        long INITIAL_TS = 1L;
        int NB_READS = 20;
        ITmfContext context = this.fExperiment.seekEvent(INITIAL_LOC);
        TmfExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = this.fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(1L + (long)i), (long)event.getTimestamp().getValue());
            Assert.assertEquals((String)"Event rank", (long)(1L + (long)i), (long)context.getRank());
            ++i;
        }
        event = this.fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)21L, (long)event.getTimestamp().getValue());
        Assert.assertEquals((String)"Event rank", (long)20L, (long)context.getRank());
        TmfExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfterSeekingOnLocation_2() {
        ITmfEvent event;
        ITmfLocation INITIAL_LOC = this.fExperiment.seekEvent(1L).getLocation();
        long INITIAL_TS = 2L;
        int NB_READS = 20;
        ITmfContext context = this.fExperiment.seekEvent(INITIAL_LOC);
        TmfExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = this.fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(2L + (long)i), (long)event.getTimestamp().getValue());
            ++i;
        }
        event = this.fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)22L, (long)event.getTimestamp().getValue());
        TmfExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextAfterSeekingOnLocation_3() {
        ITmfEvent event;
        ITmfLocation INITIAL_LOC = this.fExperiment.seekEvent(500L).getLocation();
        long INITIAL_TS = 501L;
        int NB_READS = 20;
        ITmfContext context = this.fExperiment.seekEvent(INITIAL_LOC);
        TmfExperimentTest.validateContextRanks(context);
        int i = 0;
        while (i < 20) {
            event = this.fExperiment.getNext(context);
            Assert.assertEquals((String)"Event timestamp", (long)(501L + (long)i), (long)event.getTimestamp().getValue());
            ++i;
        }
        event = this.fExperiment.parseEvent(context);
        Assert.assertEquals((String)"Event timestamp", (long)521L, (long)event.getTimestamp().getValue());
        TmfExperimentTest.validateContextRanks(context);
    }

    @Test
    public void testGetNextLocation() {
        ITmfContext context1 = this.fExperiment.seekEvent(0L);
        this.fExperiment.getNext(context1);
        ITmfLocation location = context1.getLocation();
        ITmfEvent event1 = this.fExperiment.getNext(context1);
        ITmfContext context2 = this.fExperiment.seekEvent(location);
        ITmfEvent event2 = this.fExperiment.getNext(context2);
        Assert.assertEquals((String)"Event timestamp", (long)event1.getTimestamp().getValue(), (long)event2.getTimestamp().getValue());
    }

    @Test
    public void testGetNextEndLocation() {
        ITmfContext context1 = this.fExperiment.seekEvent(this.fExperiment.getNbEvents() - 1L);
        this.fExperiment.getNext(context1);
        ITmfLocation location = context1.getLocation();
        ITmfContext context2 = this.fExperiment.seekEvent(location);
        ITmfEvent event = this.fExperiment.getNext(context2);
        Assert.assertNull((String)"Event", (Object)event);
    }

    @Test
    public void testProcessRequestForNbEvents() throws InterruptedException {
        int nbEvents = 1000;
        final Vector requestedEvents = new Vector();
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, range, 0L, 1000, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEvents.add(event);
            }
        };
        this.fExperiment.sendRequest((ITmfEventRequest)request);
        request.waitForCompletion();
        Assert.assertEquals((String)"nbEvents", (long)1000L, (long)requestedEvents.size());
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        int i = 0;
        while (i < 1000) {
            Assert.assertEquals((String)"Distinct events", (long)(i + 1), (long)((ITmfEvent)requestedEvents.get(i)).getTimestamp().getValue());
            ++i;
        }
    }

    @Test
    public void testProcessRequestForAllEvents() throws InterruptedException {
        int nbEvents = Integer.MAX_VALUE;
        final Vector requestedEvents = new Vector();
        long nbExpectedEvents = NB_EVENTS;
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, range, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND){

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEvents.add(event);
            }
        };
        this.fExperiment.sendRequest((ITmfEventRequest)request);
        request.waitForCompletion();
        Assert.assertEquals((String)"nbEvents", (long)nbExpectedEvents, (long)requestedEvents.size());
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertFalse((String)"isCancelled", (boolean)request.isCancelled());
        int i = 0;
        while ((long)i < nbExpectedEvents) {
            Assert.assertEquals((String)"Distinct events", (long)(i + 1), (long)((ITmfEvent)requestedEvents.get(i)).getTimestamp().getValue());
            ++i;
        }
    }

    @Test
    public void testCancel() throws InterruptedException {
        int nbEvents = NB_EVENTS;
        final int limit = BLOCK_SIZE;
        final Vector requestedEvents = new Vector();
        TmfTimeRange range = new TmfTimeRange(TmfTimestamp.BIG_BANG, TmfTimestamp.BIG_CRUNCH);
        TmfEventRequest request = new TmfEventRequest(ITmfEvent.class, range, 0L, nbEvents, ITmfEventRequest.ExecutionType.FOREGROUND){
            int nbRead;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4);
                this.nbRead = 0;
            }

            public void handleData(ITmfEvent event) {
                super.handleData(event);
                requestedEvents.add(event);
                if (++this.nbRead == limit) {
                    this.cancel();
                }
            }

            public void handleCancel() {
                if (requestedEvents.size() < limit) {
                    System.out.println("aie");
                }
            }
        };
        this.fExperiment.sendRequest((ITmfEventRequest)request);
        request.waitForCompletion();
        Assert.assertEquals((String)"nbEvents", (long)limit, (long)requestedEvents.size());
        Assert.assertTrue((String)"isCompleted", (boolean)request.isCompleted());
        Assert.assertTrue((String)"isCancelled", (boolean)request.isCancelled());
    }
}

