/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.location;

import java.nio.ByteBuffer;
import org.eclipse.tracecompass.internal.tmf.core.trace.experiment.TmfExperimentLocation;
import org.eclipse.tracecompass.internal.tmf.core.trace.experiment.TmfLocationArray;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfTimestampLocation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TmfLocationTest {
    private Long aLong = 12345L;
    private TmfTimestamp aTimestamp = new TmfTimestamp();
    private TmfLocationArray aLocationArray;
    private TmfLongLocation fLocation1;
    private TmfLongLocation fLocation2;
    private TmfTimestampLocation fLocation3;
    private TmfExperimentLocation fExpLocation;

    @Before
    public void setUp() {
        this.fLocation1 = new TmfLongLocation(null);
        this.fLocation2 = new TmfLongLocation(this.aLong);
        this.fLocation3 = new TmfTimestampLocation((ITmfTimestamp)this.aTimestamp);
        this.aLocationArray = new TmfLocationArray(new ITmfLocation[]{this.fLocation1, this.fLocation2, this.fLocation3}, new long[]{1L, 2L, 3L});
        this.fExpLocation = new TmfExperimentLocation(this.aLocationArray);
    }

    @Test
    public void testTmfLocation() {
        Assert.assertNull((String)"TmfLocation", (Object)this.fLocation1.getLocationInfo());
        Assert.assertEquals((String)"TmfLocation", (Object)this.aLong, (Object)this.fLocation2.getLocationInfo());
        Assert.assertEquals((String)"TmfLocation", (Object)this.aTimestamp, (Object)this.fLocation3.getLocationInfo());
        Assert.assertEquals((String)"TmfLocation", (Object)this.aLocationArray, (Object)this.fExpLocation.getLocationInfo());
    }

    @Test
    public void testTmfLocationCopy() {
        TmfLongLocation location1 = new TmfLongLocation(this.fLocation1);
        TmfLongLocation location2 = new TmfLongLocation(this.fLocation2);
        TmfTimestampLocation location3 = new TmfTimestampLocation(this.fLocation3);
        TmfExperimentLocation expLocation = new TmfExperimentLocation(this.fExpLocation);
        Assert.assertNull((String)"TmfLocation", (Object)location1.getLocationInfo());
        Assert.assertEquals((String)"TmfLocation", (Object)this.aLong, (Object)location2.getLocationInfo());
        Assert.assertEquals((String)"TmfLocation", (Object)this.aTimestamp, (Object)location3.getLocationInfo());
        Assert.assertEquals((String)"TmfLocation", (Object)this.aLocationArray, (Object)expLocation.getLocationInfo());
    }

    @Test
    public void testHashCode() {
        TmfLongLocation location1 = new TmfLongLocation(null);
        TmfLongLocation location2 = new TmfLongLocation(this.aLong);
        TmfTimestampLocation location3 = new TmfTimestampLocation((ITmfTimestamp)this.aTimestamp);
        TmfExperimentLocation expLocation = new TmfExperimentLocation(this.fExpLocation);
        TmfLocationArray locationArray1 = new TmfLocationArray(this.aLocationArray, 2, (ITmfLocation)this.fLocation3, 5L);
        TmfExperimentLocation expLocation1 = new TmfExperimentLocation(locationArray1);
        TmfLocationArray locationArray2 = new TmfLocationArray(this.aLocationArray, 2, (ITmfLocation)this.fLocation2, 4L);
        TmfExperimentLocation expLocation2 = new TmfExperimentLocation(locationArray2);
        TmfLocationArray locationArray3 = new TmfLocationArray(new ITmfLocation[]{this.fLocation1, this.fLocation2}, new long[]{1L, 2L});
        TmfExperimentLocation expLocation3 = new TmfExperimentLocation(locationArray3);
        Assert.assertTrue((String)"hashCode", (this.fLocation1.hashCode() == location1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fLocation2.hashCode() == location2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fLocation3.hashCode() == location3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fExpLocation.hashCode() == expLocation.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fLocation2.hashCode() != location3.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fLocation3.hashCode() != location2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fExpLocation.hashCode() != expLocation1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fExpLocation.hashCode() != expLocation2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fExpLocation.hashCode() != expLocation3.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsWrongTypes() {
        TmfTestLongLocation location1 = new TmfTestLongLocation(this.aLong);
        TmfTestLongLocation2 location2 = new TmfTestLongLocation2(this.aLong);
        Assert.assertFalse((String)"equals", (boolean)((Object)((Object)location1)).equals((Object)location2));
        Assert.assertFalse((String)"equals", (boolean)location2.equals((Object)location1));
    }

    @Test
    public void testEqualsWithNulls() {
        TmfLongLocation location1 = new TmfLongLocation(this.aLong);
        TmfLongLocation location2 = new TmfLongLocation(null);
        Assert.assertFalse((String)"equals", (boolean)location1.equals(location2));
        Assert.assertFalse((String)"equals", (boolean)location2.equals(location1));
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fLocation1.equals((Object)this.fLocation1));
        Assert.assertTrue((String)"equals", (boolean)this.fLocation2.equals((Object)this.fLocation2));
        Assert.assertTrue((String)"equals", (boolean)this.fLocation3.equals((Object)this.fLocation3));
        Assert.assertTrue((String)"equals", (boolean)this.fExpLocation.equals((Object)this.fExpLocation));
        Assert.assertTrue((String)"equals", (!this.fLocation2.equals((Object)this.fLocation3) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fLocation3.equals((Object)this.fLocation2) ? 1 : 0) != 0);
        TmfLocationArray locationArray1 = new TmfLocationArray(this.aLocationArray, 2, (ITmfLocation)this.fLocation3, 5L);
        TmfExperimentLocation expLocation1 = new TmfExperimentLocation(locationArray1);
        TmfLocationArray locationArray2 = new TmfLocationArray(this.aLocationArray, 2, (ITmfLocation)this.fLocation2, 4L);
        TmfExperimentLocation expLocation2 = new TmfExperimentLocation(locationArray2);
        TmfLocationArray locationArray3 = new TmfLocationArray(new ITmfLocation[]{this.fLocation1, this.fLocation2, this.fLocation3}, new long[]{1L, 2L});
        TmfExperimentLocation expLocation3 = new TmfExperimentLocation(locationArray3);
        Assert.assertTrue((String)"equals", (!this.fExpLocation.equals((Object)expLocation1) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!expLocation1.equals((Object)this.fExpLocation) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fExpLocation.equals((Object)expLocation2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!expLocation2.equals((Object)this.fExpLocation) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fExpLocation.equals((Object)expLocation3) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!expLocation3.equals((Object)this.fExpLocation) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        TmfLongLocation location2 = new TmfLongLocation(this.aLong);
        TmfTimestampLocation location3 = new TmfTimestampLocation((ITmfTimestamp)this.aTimestamp);
        TmfExperimentLocation expLocation = new TmfExperimentLocation(this.fExpLocation);
        Assert.assertTrue((String)"equals", (boolean)location2.equals((Object)this.fLocation2));
        Assert.assertTrue((String)"equals", (boolean)this.fLocation2.equals((Object)location2));
        Assert.assertTrue((String)"equals", (boolean)location3.equals((Object)this.fLocation3));
        Assert.assertTrue((String)"equals", (boolean)this.fLocation3.equals((Object)location3));
        Assert.assertTrue((String)"equals", (boolean)expLocation.equals((Object)this.fExpLocation));
        Assert.assertTrue((String)"equals", (boolean)this.fExpLocation.equals((Object)expLocation));
    }

    @Test
    public void testEqualsTransivity() {
        TmfLongLocation location1 = new TmfLongLocation(this.aLong);
        TmfLongLocation location2 = new TmfLongLocation(this.aLong);
        TmfLongLocation location3 = new TmfLongLocation(this.aLong);
        TmfExperimentLocation expLocation1 = new TmfExperimentLocation(this.aLocationArray);
        TmfExperimentLocation expLocation2 = new TmfExperimentLocation(this.aLocationArray);
        TmfExperimentLocation expLocation3 = new TmfExperimentLocation(this.aLocationArray);
        Assert.assertTrue((String)"equals", (boolean)location1.equals((Object)location2));
        Assert.assertTrue((String)"equals", (boolean)location2.equals((Object)location3));
        Assert.assertTrue((String)"equals", (boolean)location3.equals((Object)location1));
        Assert.assertTrue((String)"equals", (boolean)expLocation1.equals((Object)expLocation2));
        Assert.assertTrue((String)"equals", (boolean)expLocation2.equals((Object)expLocation3));
        Assert.assertTrue((String)"equals", (boolean)expLocation3.equals((Object)expLocation1));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fLocation1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fLocation2.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fLocation3.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fExpLocation.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        TmfTimestamp ts = new TmfTimestamp();
        TmfLongLocation location1 = new TmfLongLocation(this.aLong);
        TmfTimestampLocation location2 = new TmfTimestampLocation((ITmfTimestamp)ts);
        TmfExperimentLocation expLocation = new TmfExperimentLocation(this.aLocationArray);
        String expected1 = "TmfLongLocation [fLocationInfo=" + this.aLong + "]";
        String expected2 = "TmfTimestampLocation [fLocationInfo=" + ts + "]";
        String expected3 = "TmfExperimentLocation [" + this.aLocationArray + "]";
        Assert.assertEquals((String)"toString", (Object)expected1, (Object)location1.toString());
        Assert.assertEquals((String)"toString", (Object)expected2, (Object)location2.toString());
        Assert.assertEquals((String)"toString", (Object)expected3, (Object)expLocation.toString());
    }

    private static class TmfTestLongLocation
    extends TmfLocation {
        public TmfTestLongLocation(Long location) {
            super((Comparable)location);
        }

        public void serialize(ByteBuffer bufferOut) {
        }
    }

    private static class TmfTestLongLocation2
    extends TmfTestLongLocation {
        public TmfTestLongLocation2(Long location) {
            super(location);
        }
    }
}

