/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.stub;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;

public class XmlStubTraceTest {
    private static final Path VALID_FILE = new Path("testfiles/stub_xml_traces/valid/test.xml");
    private static final Path VALID_PATH = new Path("testfiles/stub_xml_traces/valid");
    private static final Path INVALID_PATH = new Path("testfiles/stub_xml_traces/invalid");
    private static final String EVENT_A = "A";
    private static final String EVENT_B = "B";
    private static final String FIELD_A = "b";
    private static final String FIELD_B = "f";

    private static IPath getAbsolutePath(Path relativePath) {
        TmfCoreTestPlugin plugin = TmfCoreTestPlugin.getDefault();
        if (plugin == null) {
            throw new IllegalStateException();
        }
        URL location = FileLocator.find((Bundle)plugin.getBundle(), (IPath)relativePath, null);
        try {
            Path path = new Path(FileLocator.toFileURL((URL)location).getPath());
            return path;
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    @Test
    public void testValidate() {
        TmfXmlTraceStub trace = new TmfXmlTraceStub();
        File[] invalidFiles = XmlStubTraceTest.getAbsolutePath(INVALID_PATH).toFile().listFiles();
        Assert.assertTrue((invalidFiles.length > 0 ? 1 : 0) != 0);
        File[] fileArray = invalidFiles;
        int n = invalidFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            Assert.assertTrue((!trace.validate(null, f.getAbsolutePath()).isOK() ? 1 : 0) != 0);
            ++n2;
        }
        File[] validFiles = XmlStubTraceTest.getAbsolutePath(VALID_PATH).toFile().listFiles();
        Assert.assertTrue((validFiles.length > 0 ? 1 : 0) != 0);
        File[] fileArray2 = validFiles;
        int n3 = validFiles.length;
        n = 0;
        while (n < n3) {
            File f = fileArray2[n];
            Assert.assertTrue((boolean)trace.validate(null, f.getAbsolutePath()).isOK());
            ++n;
        }
    }

    @Test
    public void testDevelopmentTrace() {
        TmfXmlTraceStub trace = new TmfXmlTraceStub();
        IStatus status = trace.validate(null, XmlStubTraceTest.getAbsolutePath(VALID_FILE).toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, XmlStubTraceTest.getAbsolutePath(VALID_FILE).toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e1) {
            Assert.fail((String)e1.getMessage());
        }
        CustomEventRequest req = new CustomEventRequest((ITmfTrace)trace);
        trace.sendRequest((ITmfEventRequest)req);
        try {
            req.waitForCompletion();
            if (req.isCancelled()) {
                Assert.fail((String)req.getStatus().getMessage());
            }
        }
        catch (InterruptedException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)4L, (long)req.getCount());
    }

    @Test
    public void testAspects() {
        TmfXmlTraceStub trace = new TmfXmlTraceStub();
        IStatus status = trace.validate(null, XmlStubTraceTest.getAbsolutePath(VALID_FILE).toOSString());
        if (!status.isOK()) {
            Assert.fail((String)status.getException().getMessage());
        }
        try {
            trace.initTrace(null, XmlStubTraceTest.getAbsolutePath(VALID_FILE).toOSString(), TmfEvent.class);
        }
        catch (TmfTraceException e1) {
            Assert.fail((String)e1.getMessage());
        }
        ITmfEventAspect cpuAspect = null;
        ITmfEventAspect testAspect = null;
        int aspectCount = 0;
        for (ITmfEventAspect aspect : trace.getEventAspects()) {
            ++aspectCount;
            if (aspect instanceof TmfCpuAspect) {
                cpuAspect = aspect;
                continue;
            }
            if (!aspect.getName().equals("test")) continue;
            testAspect = aspect;
        }
        Assert.assertEquals((String)"Number of aspects", (long)5L, (long)aspectCount);
        Assert.assertNotNull(cpuAspect);
        Assert.assertNotNull(testAspect);
        ITmfContext ctx = trace.seekEvent(0L);
        Assert.assertNotNull((Object)ctx);
        ITmfEvent event = trace.getNext(ctx);
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((String)"Cpu aspect of event 1", (Object)1, (Object)cpuAspect.resolve(event));
        Assert.assertEquals((String)"Test aspect of event 1", (Object)"abc", (Object)testAspect.resolve(event));
        event = trace.getNext(ctx);
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((String)"Cpu aspect of event 2", (Object)1, (Object)cpuAspect.resolve(event));
        Assert.assertEquals((String)"Test aspect of event 2", (Object)"abc", (Object)testAspect.resolve(event));
        event = trace.getNext(ctx);
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((String)"Cpu aspect of event 3", (Object)2, (Object)cpuAspect.resolve(event));
        Assert.assertEquals((String)"Test aspect of event 3", (Object)"def", (Object)testAspect.resolve(event));
        event = trace.getNext(ctx);
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((String)"Cpu aspect of event 4", (Object)1, (Object)cpuAspect.resolve(event));
        Assert.assertEquals((String)"Test aspect of event 4", (Object)"def", (Object)testAspect.resolve(event));
    }

    private static IStatus testEvent(ITmfEvent event) {
        switch (event.getName()) {
            case "A": {
                ITmfEventField content = event.getContent();
                if (content.getField(new String[]{FIELD_A}) != null) break;
                return new Status(4, "org.eclipse.tracecompass.tmf.tests", String.format("Field %s does not exist in event %s", FIELD_A, EVENT_A));
            }
            case "B": {
                ITmfEventField content = event.getContent();
                if (content.getField(new String[]{FIELD_B}) != null) break;
                return new Status(4, "org.eclipse.tracecompass.tmf.tests", String.format("Field %s does not exist in event %s", FIELD_B, EVENT_B));
            }
            default: {
                return new Status(4, "org.eclipse.tracecompass.tmf.tests", "Unexpected event " + event.getType().getName());
            }
        }
        return Status.OK_STATUS;
    }

    private class CustomEventRequest
    extends TmfEventRequest {
        private final ITmfTrace fTrace;
        private IStatus fResult;
        private int fCount;

        public CustomEventRequest(ITmfTrace trace) {
            super(trace.getEventType(), TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND);
            this.fResult = Status.OK_STATUS;
            this.fCount = 0;
            this.fTrace = trace;
        }

        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (event.getTrace() == this.fTrace) {
                ++this.fCount;
                IStatus result = XmlStubTraceTest.testEvent(event);
                if (!result.isOK()) {
                    this.fResult = result;
                    this.cancel();
                }
            }
        }

        public IStatus getStatus() {
            return this.fResult;
        }

        public int getCount() {
            return this.fCount;
        }
    }
}

