/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.trace.text;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.collapse.ITmfCollapsibleEvent;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfSourceLookup;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.text.TextTrace;
import org.eclipse.tracecompass.tmf.core.trace.text.TextTraceEvent;
import org.eclipse.tracecompass.tmf.core.trace.text.TextTraceEventContent;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.text.SyslogEventType;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.text.SyslogTrace;

public class SyslogEvent
extends TextTraceEvent
implements ITmfCollapsibleEvent,
ITmfSourceLookup {
    public SyslogEvent() {
        super(null, null, (ITmfEventType)new SyslogEventType(), null);
    }

    public SyslogEvent(@NonNull SyslogEvent other) {
        super((TextTraceEvent)other);
    }

    public SyslogEvent(SyslogTrace parentTrace, ITmfTimestamp timestamp, ITmfEventType type, TextTraceEventContent content) {
        super((TextTrace)parentTrace, timestamp, type, content);
    }

    public boolean isCollapsibleWith(ITmfEvent otherEvent) {
        if (this == otherEvent) {
            return true;
        }
        if (!(otherEvent instanceof SyslogEvent)) {
            return false;
        }
        SyslogEvent other = (SyslogEvent)otherEvent;
        if (!this.getTrace().equals(other.getTrace())) {
            return false;
        }
        if (this.getType() == null ? other.getType() != null : !this.getType().equals(other.getType())) {
            return false;
        }
        TextTraceEventContent content = this.getContent();
        TextTraceEventContent otherContent = other.getContent();
        if (content == null) {
            return otherContent == null;
        }
        if (otherContent == null) {
            return false;
        }
        List fields = content.getFields();
        List otherFields = otherContent.getFields();
        int size = fields.size();
        if (size != otherFields.size()) {
            return false;
        }
        int i = 1;
        while (i < size) {
            if (!((TextTraceEventContent)fields.get(i)).equals(otherFields.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ITmfCallsite getCallsite() {
        if (this.getContent() != null) {
            long lineNo = 0L;
            try {
                lineNo = Long.valueOf((String)this.getContent().getField(new String[]{"Line"}).getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return new TmfCallsite((String)this.getContent().getField(new String[]{"File"}).getValue(), null, lineNo);
        }
        return null;
    }
}

