/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.tests.stubs.trace.xml;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfContentFieldAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomEventContent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlEvent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpointIndexer;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.Messages;
import org.xml.sax.SAXException;

public class TmfXmlTraceStub
extends TmfTrace {
    private static final String DEVELOPMENT_TRACE_PARSER_PATH = "TmfXmlDevelopmentTrace.xml";
    private static final String DEVELOPMENT_TRACE_XSD = "TmfXmlDevelopmentTrace.xsd";
    private static final String EMPTY = "";
    private static final String EVENT_NAME_FIELD = "Message";
    private static final String FIELD_NAMES_FIELD = "fields";
    private static final String VALUES_FIELD = "values";
    private static final String TYPES_FIELD = "type";
    private static final String VALUES_SEPARATOR = " \\| ";
    private static final String TYPE_INTEGER = "int";
    private static final String TYPE_LONG = "long";
    private static final String ASPECT_CPU = "cpu";
    private static final Long SECONDS_TO_NS = 1000000000L;
    private final CustomXmlTraceDefinition fDefinition;
    private CustomXmlTrace fTrace;
    private Collection<ITmfEventAspect> fAspects = TmfTrace.BASE_ASPECTS;

    public TmfXmlTraceStub() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = TmfXmlTraceStub.class.getResourceAsStream(DEVELOPMENT_TRACE_PARSER_PATH);){
                CustomXmlTraceDefinition[] definitions = CustomXmlTraceDefinition.loadAll((InputStream)in);
                if (definitions.length < 2) {
                    throw new IllegalStateException("The custom trace definition does not exist");
                }
                this.fTrace = new CustomXmlTrace(definitions[0]){

                    protected ITmfTraceIndexer createIndexer(int interval) {
                        return new TmfCheckpointIndexer((ITmfTrace)this, interval);
                    }
                };
                this.fDefinition = (CustomXmlTraceDefinition)NonNullUtils.checkNotNull((Object)definitions[1]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot open the trace parser for development traces");
        }
    }

    public void initTrace(@Nullable IResource resource, @Nullable String path, @Nullable Class<? extends ITmfEvent> type) throws TmfTraceException {
        super.initTrace(resource, path, type);
        TmfSignalManager.deregister((Object)this.fTrace);
        this.fTrace.initTrace(resource, path, type);
        ITmfContext ctx = this.seekEvent(0L);
        this.getNext(ctx);
        ctx.dispose();
        this.fTrace.dispose();
        this.fTrace = new CustomXmlTrace(this.fDefinition);
        TmfSignalManager.deregister((Object)this.fTrace);
        this.fTrace.initTrace(resource, path, type);
        ctx = this.seekEvent(0L);
        if (ctx == null) {
            return;
        }
        ITmfEvent event = this.getNext(ctx);
        if (event != null) {
            ITmfTimestamp curTime = event.getTimestamp();
            this.setStartTime(curTime);
            this.setEndTime(curTime);
        }
        ctx.dispose();
    }

    public synchronized void dispose() {
        super.dispose();
        this.fTrace.dispose();
    }

    @Nullable
    public ITmfEvent parseEvent(@Nullable ITmfContext context) {
        return this.fTrace.parseEvent(context);
    }

    @Nullable
    public ITmfLocation getCurrentLocation() {
        return this.fTrace.getCurrentLocation();
    }

    public double getLocationRatio(@Nullable ITmfLocation location) {
        return this.fTrace.getLocationRatio(location);
    }

    @Nullable
    public ITmfContext seekEvent(@Nullable ITmfLocation location) {
        return this.fTrace.seekEvent(location);
    }

    @Nullable
    public ITmfContext seekEvent(double ratio) {
        return this.fTrace.seekEvent(ratio);
    }

    public IStatus validate(@Nullable IProject project, @Nullable String path) {
        File xmlFile = new File(path);
        if (!(xmlFile.exists() && xmlFile.isFile() && xmlFile.canRead())) {
            return new Status(4, "org.eclipse.tracecompass.tmf.core", NLS.bind((String)Messages.TmfDevelopmentTrace_FileNotFound, (Object)path));
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        StreamSource xmlSource = new StreamSource(xmlFile);
        try {
            URL url = TmfXmlTraceStub.class.getResource(DEVELOPMENT_TRACE_XSD);
            Schema schema = schemaFactory.newSchema(url);
            Validator validator = schema.newValidator();
            validator.validate(xmlSource);
        }
        catch (SAXException e) {
            return new Status(4, "org.eclipse.tracecompass.tmf.core", NLS.bind((String)Messages.TmfDevelopmentTrace_ValidationError, (Object)path), (Throwable)e);
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.tracecompass.tmf.core", NLS.bind((String)Messages.TmfDevelopmentTrace_IoError, (Object)path), (Throwable)e);
        }
        IStatus status = Status.OK_STATUS;
        return status;
    }

    private static String getStringValue(ITmfEventField content, String fieldName) {
        ITmfEventField field = content.getField(new String[]{fieldName});
        if (field == null) {
            return EMPTY;
        }
        Object val = field.getValue();
        if (!(val instanceof String)) {
            return EMPTY;
        }
        return (String)val;
    }

    @Nullable
    public synchronized ITmfEvent getNext(@Nullable ITmfContext context) {
        if (context == null) {
            return null;
        }
        TmfContext savedContext = new TmfContext(context.getLocation(), context.getRank());
        CustomXmlEvent event = this.fTrace.getNext(context);
        if (event == null) {
            return null;
        }
        ITmfEventField content = event.getContent();
        if (content == null) {
            return null;
        }
        String fieldString = TmfXmlTraceStub.getStringValue(content, FIELD_NAMES_FIELD);
        String valueString = TmfXmlTraceStub.getStringValue(content, VALUES_FIELD);
        String typeString = TmfXmlTraceStub.getStringValue(content, TYPES_FIELD);
        String[] fields = fieldString.split(VALUES_SEPARATOR);
        String[] values = valueString.split(VALUES_SEPARATOR);
        String[] types = typeString.split(VALUES_SEPARATOR);
        TmfEventField[] fieldsArray = new TmfEventField[fields.length];
        int i = 0;
        while (i < fields.length) {
            Object val;
            block21: {
                String value = EMPTY;
                if (values.length > i) {
                    value = values[i];
                }
                String type = null;
                if (types.length > i) {
                    type = types[i];
                }
                val = value;
                if (type == null) break block21;
                switch (type) {
                    case "int": {
                        try {
                            val = Integer.valueOf(value);
                        }
                        catch (NumberFormatException e) {
                            Activator.logError((String)String.format("Get next XML event: cannot cast value %s to integer", value), (Throwable)e);
                            val = 0;
                        }
                        break;
                    }
                    case "long": {
                        try {
                            val = Long.valueOf(value);
                        }
                        catch (NumberFormatException e) {
                            Activator.logError((String)String.format("Get next XML event: cannot cast value %s to long", value), (Throwable)e);
                            val = 0L;
                        }
                        break;
                    }
                }
            }
            fieldsArray[i] = new TmfEventField(fields[i], val, null);
            ++i;
        }
        if (this.fTrace.getDefinition() != this.fDefinition) {
            this.generateAspects((ITmfEventField[])fieldsArray);
            return null;
        }
        ITmfEventType customEventType = event.getType();
        String eventName = TmfXmlTraceStub.getStringValue(content, EVENT_NAME_FIELD);
        TmfEventType eventType = new TmfEventType(eventName, customEventType.getRootField());
        CustomEventContent eventFields = new CustomEventContent(content.getName(), content.getValue(), (ITmfEventField[])fieldsArray);
        TmfNanoTimestamp timestamp = new TmfNanoTimestamp(event.getTimestamp().getValue() / SECONDS_TO_NS);
        TmfEvent newEvent = new TmfEvent((ITmfTrace)this, -1L, (ITmfTimestamp)timestamp, (ITmfEventType)eventType, (ITmfEventField)eventFields);
        this.updateAttributes((ITmfContext)savedContext, (ITmfEvent)event);
        return newEvent;
    }

    private void generateAspects(ITmfEventField[] fieldsArray) {
        ImmutableList aspectList;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object)ITmfEventAspect.BaseAspects.TIMESTAMP);
        builder.add((Object)ITmfEventAspect.BaseAspects.EVENT_TYPE);
        ITmfEventField[] iTmfEventFieldArray = fieldsArray;
        int n = fieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfEventField field = iTmfEventFieldArray[n2];
            String name = field.getName();
            if (name == null) break;
            TmfContentFieldAspect aspect = new TmfContentFieldAspect(name, new String[]{name});
            if (name.equals(ASPECT_CPU)) {
                builder.add((Object)new TmfCpuAspect((ITmfEventAspect)aspect){
                    private final /* synthetic */ ITmfEventAspect val$aspect;
                    {
                        this.val$aspect = iTmfEventAspect;
                    }

                    @Nullable
                    public Integer resolve(ITmfEvent event) {
                        Object result = this.val$aspect.resolve(event);
                        if (result instanceof Number) {
                            return ((Number)result).intValue();
                        }
                        return null;
                    }
                });
            } else {
                builder.add((Object)aspect);
            }
            ++n2;
        }
        builder.add((Object)ITmfEventAspect.BaseAspects.CONTENTS);
        this.fAspects = aspectList = builder.build();
    }

    public Iterable<ITmfEventAspect> getEventAspects() {
        return this.fAspects;
    }
}

