/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.statistics;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfLostEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TmfStatisticsEventTypesModule
extends TmfStateSystemAnalysisModule {
    @NonNull
    public static final String ID = "org.eclipse.linuxtools.tmf.statistics.types";
    @NonNull
    private static final String NAME = "TMF Statistics, events per type";

    public TmfStatisticsEventTypesModule() {
        this.setId(ID);
        this.setName(NAME);
    }

    @Override
    protected ITmfStateProvider createStateProvider() {
        return new StatsProviderEventTypes((ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace()));
    }

    @Override
    protected String getSsFileName() {
        return "statistics-types.ht";
    }

    class StatsProviderEventTypes
    extends AbstractTmfStateProvider {
        private static final int VERSION = 2;

        public StatsProviderEventTypes(ITmfTrace trace) {
            super(trace, TmfStatisticsEventTypesModule.NAME);
        }

        @Override
        public int getVersion() {
            return 2;
        }

        @Override
        public StatsProviderEventTypes getNewInstance() {
            return new StatsProviderEventTypes(this.getTrace());
        }

        @Override
        protected void eventHandle(ITmfEvent event) {
            ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
            long ts = event.getTimestamp().normalize(0L, -9).getValue();
            String eventName = event.getName();
            try {
                if (event instanceof ITmfLostEvent) {
                    ITmfLostEvent le = (ITmfLostEvent)event;
                    int quark = ss.getQuarkAbsoluteAndAdd(new String[]{"event_types", eventName});
                    int curVal = ss.queryOngoingState(quark).unboxInt();
                    if (curVal == -1) {
                        curVal = 0;
                    }
                    TmfStateValue value = TmfStateValue.newValueInt((int)((int)((long)curVal + le.getNbLostEvents())));
                    ss.modifyAttribute(ts, (ITmfStateValue)value, quark);
                    return;
                }
                int quark = ss.getQuarkAbsoluteAndAdd(new String[]{"event_types", eventName});
                ss.incrementAttribute(ts, quark);
            }
            catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
                e.printStackTrace();
            }
        }
    }
}

