/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.context;

import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocationInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CtfLocationTest {
    private CtfLocation fixture;

    @Before
    public void setUp() {
        this.fixture = new CtfLocation(new CtfLocationInfo(1L, 0L));
    }

    @Test
    public void testCtfLocation_long() {
        CtfLocationInfo location = new CtfLocationInfo(1L, 0L);
        CtfLocation result = new CtfLocation(location);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.getLocationInfo().getTimestamp());
    }

    @Test
    public void testCtfLocation_timestamp() {
        TmfTimestamp timestamp = new TmfTimestamp();
        CtfLocation result = new CtfLocation((ITmfTimestamp)timestamp);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.getLocationInfo().getTimestamp());
    }

    @Test
    public void testGetLocation() {
        CtfLocationInfo location = this.fixture.getLocationInfo();
        long result = location.getTimestamp();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testSetLocation() {
        CtfLocationInfo location = new CtfLocationInfo(1337L, 7331L);
        this.fixture = new CtfLocation(location);
    }

    @Test
    public void testToString_valid() {
        CtfLocation fixture2 = new CtfLocation(new CtfLocationInfo(1337L, 7331L));
        Assert.assertEquals((Object)"CtfLocation [fLocationInfo=Element [1337/7331]]", (Object)fixture2.toString());
    }

    @Test
    public void testToString_invalid() {
        CtfLocation fixture2 = new CtfLocation(new CtfLocationInfo(-1L, -1L));
        Assert.assertEquals((Object)"CtfLocation [INVALID]", (Object)fixture2.toString());
    }
}

