/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.event;

import java.util.Collection;
import java.util.Set;
import org.eclipse.tracecompass.internal.tmf.ctf.core.trace.iterator.CtfIterator;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventFactory;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class CtfTmfEventTest {
    private static final CtfTmfTestTrace testTrace = CtfTmfTestTrace.KERNEL;
    private static CtfTmfEvent nullEvent;
    private CtfTmfEvent fixture;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Before
    public void setUp() {
        Assume.assumeTrue((boolean)testTrace.exists());
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            CtfTmfTrace trace = testTrace.getTrace();
            try {
                try (CtfIterator tr = (CtfIterator)trace.createIterator();){
                    this.fixture = tr.getCurrentEvent();
                    tr.advance();
                    this.fixture = tr.getCurrentEvent();
                    nullEvent = CtfTmfEventFactory.getNullEvent((CtfTmfTrace)trace);
                }
                if (trace == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (trace == null) throw throwable;
                trace.close();
                throw throwable;
            }
            trace.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Test
    public void testCTFEvent_read() {
        Assert.assertNotNull((Object)this.fixture);
    }

    @Test
    public void testGetCPU() {
        int result = nullEvent.getCPU();
        Assert.assertEquals((long)-1L, (long)result);
    }

    @Test
    public void testGetEventName() {
        String result = nullEvent.getType().getName();
        Assert.assertEquals((Object)"Empty CTF event", (Object)result);
    }

    @Test
    public void testGetFieldNames() {
        Collection result = this.fixture.getContent().getFieldNames();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetFieldValue() {
        String fieldName = "ret";
        ITmfEventField result = this.fixture.getContent().getField(new String[]{fieldName});
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getValue());
    }

    @Test
    public void testGetFields() {
        Collection fields = nullEvent.getContent().getFields();
        Assert.assertEquals((long)0L, (long)fields.size());
    }

    @Test
    public void testGetSubFieldValue() {
        String[] names = new String[]{"ret"};
        Assert.assertNotNull((Object)this.fixture.getContent().getField(names));
        String[] names2 = new String[]{"ret", "abcd"};
        Assert.assertNull((Object)this.fixture.getContent().getField(names2));
        String[] names3 = new String[]{"pid", "abcd"};
        Assert.assertNull((Object)this.fixture.getContent().getField(names3));
    }

    @Test
    public void testGetID() {
        long result = nullEvent.getID();
        Assert.assertEquals((long)-1L, (long)result);
    }

    @Test
    public void testGetTimestamp() {
        long result = nullEvent.getTimestamp().getValue();
        Assert.assertEquals((long)-1L, (long)result);
    }

    @Test
    public void testGetters() {
        long rank = this.fixture.getRank();
        Throwable throwable = null;
        Object var4_4 = null;
        try (CtfTmfTrace trace = this.fixture.getTrace();){
            Assert.assertEquals((Object)"kernel", (Object)trace.getName());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String reference = this.fixture.getReference();
        int cpu = this.fixture.getCPU();
        ITmfEventType type = this.fixture.getType();
        Assert.assertEquals((long)-1L, (long)rank);
        Assert.assertEquals((Object)"channel0_1", (Object)reference);
        Assert.assertEquals((long)1L, (long)cpu);
        Assert.assertEquals((Object)"exit_syscall", (Object)type.toString());
    }

    @Test
    public void testCustomAttributes() {
        Set attributes = this.fixture.listCustomAttributes();
        Assert.assertEquals((long)0L, (long)attributes.size());
        String attrib = this.fixture.getCustomAttribute("bozo");
        Assert.assertNull((Object)attrib);
    }

    @Test
    public void testToString() {
        String s = this.fixture.getContent().toString();
        Assert.assertEquals((Object)"ret=4132", (Object)s);
    }

    @Test
    public void testNullEvent() {
        CtfTmfEvent nullEvent2 = CtfTmfEventFactory.getNullEvent((CtfTmfTrace)this.fixture.getTrace());
        Assert.assertSame((Object)nullEvent2, (Object)nullEvent);
        Assert.assertNotNull((Object)nullEvent);
        Assert.assertEquals((long)-1L, (long)nullEvent.getCPU());
        Assert.assertEquals((Object)"Empty CTF event", (Object)nullEvent.getType().getName());
        Assert.assertNull((Object)nullEvent.getReference());
        Assert.assertEquals((long)0L, (long)nullEvent.getContent().getFields().size());
        Assert.assertEquals((long)-1L, (long)nullEvent.getID());
        Assert.assertEquals((long)-1L, (long)nullEvent.getTimestamp().getValue());
    }
}

