/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.event;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfLostEvent;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.synchronization.TimestampTransformFactory;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class CtfTmfLostEventsTest {
    private static final CtfTmfTestTrace testTrace = CtfTmfTestTrace.HELLO_LOST;
    private CtfTmfTrace fixture = null;

    @Before
    public void setUp() {
        Assume.assumeTrue((boolean)testTrace.exists());
        this.fixture = testTrace.getTrace();
        this.fixture.indexTrace(true);
    }

    @After
    public void tearDown() {
        if (this.fixture != null) {
            this.fixture.dispose();
        }
    }

    @Test
    public void testNbEvents() {
        long expectedReal = 32300L;
        long expectedLost = 562L;
        EventCountRequest req = new EventCountRequest();
        this.fixture.sendRequest((ITmfEventRequest)req);
        try {
            req.waitForCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((long)32300L, (long)req.getReal());
        Assert.assertEquals((long)562L, (long)req.getLost());
    }

    @Test
    public void testNbEventsBug475007() {
        CtfTmfTestTrace tmfTestTrace = CtfTmfTestTrace.DYNSCOPE;
        Assume.assumeTrue((boolean)tmfTestTrace.exists());
        Throwable throwable = null;
        Object var3_4 = null;
        try (CtfTmfTrace trace = tmfTestTrace.getTrace();){
            trace.indexTrace(true);
            long expectedReal = 100003L;
            long expectedLost = 1L;
            EventCountRequest req = new EventCountRequest();
            trace.sendRequest((ITmfEventRequest)req);
            try {
                req.waitForCompletion();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Assert.assertEquals((long)100003L, (long)req.getReal());
            Assert.assertEquals((long)1L, (long)req.getLost());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testFirstLostEvent() {
        long rank = 190L;
        TmfNanoTimestamp start = new TmfNanoTimestamp(1376592664828900165L);
        TmfNanoTimestamp end = new TmfNanoTimestamp(1376592664829403076L);
        long nbLost = 859L;
        CtfTmfEvent ev = this.getOneEventTime((ITmfTimestamp)start);
        CtfTmfEvent ev2 = this.getOneEventRank(190L);
        Assert.assertEquals((Object)ev, (Object)ev2);
        Assert.assertTrue((boolean)(ev instanceof ITmfLostEvent));
        ITmfLostEvent event = (ITmfLostEvent)ev;
        Assert.assertEquals((Object)start, (Object)event.getTimestamp());
        Assert.assertEquals((Object)start, (Object)event.getTimeRange().getStartTime());
        Assert.assertEquals((Object)end, (Object)event.getTimeRange().getEndTime());
        Assert.assertEquals((long)859L, (long)event.getNbLostEvents());
    }

    @Test
    public void testSecondLostEvent() {
        long rank = 229L;
        TmfNanoTimestamp start = new TmfNanoTimestamp(1376592664829477058L);
        TmfNanoTimestamp end = new TmfNanoTimestamp(1376592664829824514L);
        long nbLost = 488L;
        CtfTmfEvent ev = this.getOneEventTime((ITmfTimestamp)start);
        CtfTmfEvent ev2 = this.getOneEventRank(229L);
        Assert.assertEquals((Object)ev, (Object)ev2);
        Assert.assertTrue((boolean)(ev instanceof ITmfLostEvent));
        ITmfLostEvent event = (ITmfLostEvent)ev;
        Assert.assertEquals((Object)start, (Object)event.getTimestamp());
        Assert.assertEquals((Object)start, (Object)event.getTimeRange().getStartTime());
        Assert.assertEquals((Object)end, (Object)event.getTimeRange().getEndTime());
        Assert.assertEquals((long)488L, (long)event.getNbLostEvents());
    }

    @Test
    public void testNormalEvent() {
        long rank = 200L;
        TmfNanoTimestamp ts = new TmfNanoTimestamp(1376592664829425780L);
        CtfTmfEvent event = this.getOneEventTime((ITmfTimestamp)ts);
        CtfTmfEvent event2 = this.getOneEventRank(200L);
        Assert.assertEquals((Object)event, (Object)event2);
        Assert.assertFalse((boolean)(event instanceof ITmfLostEvent));
        Assert.assertEquals((Object)ts, (Object)event.getTimestamp());
    }

    @Test
    public void testLostEventWithTransform() {
        CtfTmfTrace trace = testTrace.getTrace();
        long offset = 1234567890L;
        trace.setTimestampTransform(TimestampTransformFactory.createWithOffset((long)offset));
        trace.indexTrace(true);
        long rank = 190L;
        TmfNanoTimestamp start = new TmfNanoTimestamp(1376592664828900165L + offset);
        TmfNanoTimestamp end = new TmfNanoTimestamp(1376592664829403076L + offset);
        long nbLost = 859L;
        ITmfContext context = trace.seekEvent(190L);
        CtfTmfEvent ev = trace.getNext(context);
        context.dispose();
        Assert.assertTrue((boolean)(ev instanceof ITmfLostEvent));
        ITmfLostEvent event = (ITmfLostEvent)ev;
        Assert.assertEquals((Object)start, (Object)event.getTimestamp());
        Assert.assertEquals((Object)start, (Object)event.getTimeRange().getStartTime());
        Assert.assertEquals((Object)end, (Object)event.getTimeRange().getEndTime());
        Assert.assertEquals((long)859L, (long)event.getNbLostEvents());
        trace.setTimestampTransform(null);
        trace.dispose();
    }

    private CtfTmfEvent getOneEventRank(long rank) {
        OneEventRequestPerRank req = new OneEventRequestPerRank(rank);
        this.fixture.sendRequest((ITmfEventRequest)req);
        try {
            req.waitForCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return req.getEvent();
    }

    private CtfTmfEvent getOneEventTime(@NonNull ITmfTimestamp ts) {
        OneEventRequestPerTs req = new OneEventRequestPerTs(ts);
        this.fixture.sendRequest((ITmfEventRequest)req);
        try {
            req.waitForCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return req.getEvent();
    }

    private class EventCountRequest
    extends TmfEventRequest {
        private long nbReal;
        private long nbLost;

        public EventCountRequest() {
            super(CtfTmfEvent.class, TmfTimeRange.ETERNITY, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.nbReal = 0L;
            this.nbLost = 0L;
        }

        public void handleData(ITmfEvent event) {
            if (event instanceof ITmfLostEvent) {
                ++this.nbLost;
            } else {
                ++this.nbReal;
            }
        }

        public long getReal() {
            return this.nbReal;
        }

        public long getLost() {
            return this.nbLost;
        }
    }

    private class OneEventRequestPerRank
    extends TmfEventRequest {
        private CtfTmfEvent event;

        public OneEventRequestPerRank(long rank) {
            super(CtfTmfEvent.class, TmfTimeRange.ETERNITY, rank, 1, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.event = null;
        }

        public void handleData(ITmfEvent ev) {
            this.event = (CtfTmfEvent)ev;
        }

        public CtfTmfEvent getEvent() {
            return this.event;
        }
    }

    private class OneEventRequestPerTs
    extends TmfEventRequest {
        private CtfTmfEvent event;

        public OneEventRequestPerTs(ITmfTimestamp ts) {
            super(CtfTmfEvent.class, new TmfTimeRange(ts, ts), 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.event = null;
        }

        public void handleData(ITmfEvent ev) {
            this.event = (CtfTmfEvent)ev;
        }

        public CtfTmfEvent getEvent() {
            return this.event;
        }
    }
}

