/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.shared;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.stubs.CtfTmfTraceStub;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;

@NonNullByDefault
public enum CtfTmfTestTrace {
    KERNEL,
    TRACE2,
    KERNEL_VM,
    SYNC_SRC,
    SYNC_DEST,
    DJANGO_CLIENT,
    DJANGO_DB,
    DJANGO_HTTPD,
    HELLO_LOST,
    CYG_PROFILE,
    CYG_PROFILE_FAST,
    SYNTHETIC_TRACE,
    FUNKY_TRACE,
    DYNSCOPE;

    private final String fPath;
    @Nullable
    private CtfTmfTraceStub fTrace = null;

    private CtfTmfTestTrace() {
        String path;
        this.fPath = path = CtfTestTrace.valueOf((String)this.name()).getPath();
    }

    public String getPath() {
        return this.fPath;
    }

    public synchronized CtfTmfTrace getTrace() {
        CtfTmfTraceStub trace = this.fTrace;
        if (trace != null) {
            trace.close();
        }
        trace = new CtfTmfTraceStub();
        try {
            trace.initTrace(null, this.fPath, CtfTmfEvent.class);
        }
        catch (TmfTraceException e) {
            throw new RuntimeException(e);
        }
        this.fTrace = trace;
        return trace;
    }

    public boolean exists() {
        return CtfTestTrace.valueOf((String)this.name()).exists();
    }

    public void dispose() {
        if (this.fTrace != null) {
            this.fTrace.dispose();
            this.fTrace = null;
        }
    }
}

