/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.temp.statistics;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.tracecompass.tmf.core.statistics.ITmfStatistics;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.Timeout;

public abstract class TmfStatisticsTest {
    @Rule
    public TestRule globalTimeout = new Timeout(30L, TimeUnit.SECONDS);
    protected static final CtfTmfTestTrace testTrace = CtfTmfTestTrace.KERNEL;
    protected static ITmfStatistics backend;
    private static final int totalNbEvents = 695319;
    private static final long tStart = 1332170682440133097L;
    private static final long tEnd = 1332170692664579801L;
    private static final long t1 = 1332170682490946000L;
    private static final long t2 = 1332170682490947524L;
    private static final long t3 = 1332170682490948000L;
    private static final long t4 = 1332170682490949000L;
    private static final long t5 = 1332170682490949270L;
    private static final long t6 = 1332170682490949300L;
    private static final String eventType = "lttng_statedump_process_state";

    @Test
    public void testHistogramQuerySmall() {
        int NB_REQ = 10;
        List results = backend.histogramQuery(1332170682490946000L, 1332170682490949300L, 10);
        Assert.assertEquals((long)10L, (long)results.size());
        Assert.assertEquals((long)0L, (long)((Long)results.get(0)));
        Assert.assertEquals((long)0L, (long)((Long)results.get(1)));
        Assert.assertEquals((long)0L, (long)((Long)results.get(2)));
        Assert.assertEquals((long)0L, (long)((Long)results.get(3)));
        Assert.assertEquals((long)1L, (long)((Long)results.get(4)));
        Assert.assertEquals((long)0L, (long)((Long)results.get(5)));
        Assert.assertEquals((long)0L, (long)((Long)results.get(6)));
        Assert.assertEquals((long)0L, (long)((Long)results.get(7)));
        Assert.assertEquals((long)0L, (long)((Long)results.get(8)));
        Assert.assertEquals((long)1L, (long)((Long)results.get(9)));
    }

    @Test
    public void testHistogramQueryFull() {
        int NB_REQ = 10;
        List results = backend.histogramQuery(1332170682440133097L, 1332170692664579801L, 10);
        Assert.assertEquals((long)10L, (long)results.size());
        long count = 0L;
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            long val = (Long)iterator.next();
            count += val;
        }
        Assert.assertEquals((long)695319L, (long)count);
        Assert.assertEquals((long)94161L, (long)((Long)results.get(0)));
        Assert.assertEquals((long)87348L, (long)((Long)results.get(1)));
        Assert.assertEquals((long)58941L, (long)((Long)results.get(2)));
        Assert.assertEquals((long)59879L, (long)((Long)results.get(3)));
        Assert.assertEquals((long)66941L, (long)((Long)results.get(4)));
        Assert.assertEquals((long)68939L, (long)((Long)results.get(5)));
        Assert.assertEquals((long)72746L, (long)((Long)results.get(6)));
        Assert.assertEquals((long)60749L, (long)((Long)results.get(7)));
        Assert.assertEquals((long)61208L, (long)((Long)results.get(8)));
        Assert.assertEquals((long)64407L, (long)((Long)results.get(9)));
    }

    @Test
    public void testGetEventsTotal() {
        long count = backend.getEventsTotal();
        Assert.assertEquals((long)695319L, (long)count);
    }

    @Test
    public void testEventTypesTotal() {
        Map res = backend.getEventTypesTotal();
        Assert.assertEquals((long)126L, (long)res.size());
        long count = TmfStatisticsTest.sumOfEvents(res);
        Assert.assertEquals((long)695319L, (long)count);
    }

    @Test
    public void testGetEventsInRangeWholeRange() {
        long count = backend.getEventsInRange(1332170682440133097L, 1332170692664579801L);
        Assert.assertEquals((long)695319L, (long)count);
    }

    @Test
    public void testGetEventsInRangeMinusStart() {
        long count = backend.getEventsInRange(1332170682440133098L, 1332170692664579801L);
        Assert.assertEquals((long)695318L, (long)count);
    }

    @Test
    public void testGetEventsInRangeMinusEnd() {
        long count = backend.getEventsInRange(1332170682440133097L, 1332170692664579800L);
        Assert.assertEquals((long)695318L, (long)count);
    }

    @Test
    public void testGetEventsInRangeNoEventsAtEdges() {
        long count = backend.getEventsInRange(1332170682490946000L, 1332170682490949300L);
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testGetEventsInRangeEventAtStart() {
        long count = backend.getEventsInRange(1332170682490947524L, 1332170682490948000L);
        Assert.assertEquals((long)1L, (long)count);
        count = backend.getEventsInRange(1332170682490947524L, 1332170682490949300L);
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testGetEventsInRangeEventAtEnd() {
        long count = backend.getEventsInRange(1332170682490949000L, 1332170682490949270L);
        Assert.assertEquals((long)1L, (long)count);
        count = backend.getEventsInRange(1332170682490946000L, 1332170682490949270L);
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testGetEventsInRangeEventAtBoth() {
        long count = backend.getEventsInRange(1332170682490947524L, 1332170682490949270L);
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testGetEventsInRangeNoEvents() {
        long count = backend.getEventsInRange(1332170682490948000L, 1332170682490949000L);
        Assert.assertEquals((long)0L, (long)count);
    }

    @Test
    public void testGetEventTypesInRangeWholeRange() {
        Map result = backend.getEventTypesInRange(1332170682440133097L, 1332170692664579801L);
        Assert.assertEquals((Object)new Long(464L), result.get(eventType));
        long count = TmfStatisticsTest.sumOfEvents(result);
        Assert.assertEquals((long)695319L, (long)count);
    }

    @Test
    public void testGetEventTypesInRangeMinusStart() {
        Map result = backend.getEventTypesInRange(1332170682440133098L, 1332170692664579801L);
        long count = TmfStatisticsTest.sumOfEvents(result);
        Assert.assertEquals((long)695318L, (long)count);
    }

    @Test
    public void testGetEventTypesInRangeMinusEnd() {
        Map result = backend.getEventTypesInRange(1332170682440133097L, 1332170692664579800L);
        long count = TmfStatisticsTest.sumOfEvents(result);
        Assert.assertEquals((long)695318L, (long)count);
    }

    @Test
    public void testGetEventTypesInRangeNoEventsAtEdges() {
        Map result = backend.getEventTypesInRange(1332170682490946000L, 1332170682490949300L);
        Assert.assertEquals((Object)new Long(2L), result.get(eventType));
        long count = TmfStatisticsTest.sumOfEvents(result);
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testGetEventTypesInRangeEventAtStart() {
        Map result = backend.getEventTypesInRange(1332170682490947524L, 1332170682490948000L);
        Assert.assertEquals((Object)new Long(1L), result.get(eventType));
        long count = TmfStatisticsTest.sumOfEvents(result);
        Assert.assertEquals((long)1L, (long)count);
        result = backend.getEventTypesInRange(1332170682490947524L, 1332170682490949300L);
        Assert.assertEquals((Object)new Long(2L), result.get(eventType));
        count = TmfStatisticsTest.sumOfEvents(result);
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testGetEventTypesInRangeEventAtEnd() {
        Map result = backend.getEventTypesInRange(1332170682490949000L, 1332170682490949270L);
        Assert.assertEquals((Object)new Long(1L), result.get(eventType));
        long count = TmfStatisticsTest.sumOfEvents(result);
        Assert.assertEquals((long)1L, (long)count);
        result = backend.getEventTypesInRange(1332170682490946000L, 1332170682490949270L);
        Assert.assertEquals((Object)new Long(2L), result.get(eventType));
        count = TmfStatisticsTest.sumOfEvents(result);
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testGetEventTypesInRangeEventAtBoth() {
        Map result = backend.getEventTypesInRange(1332170682490947524L, 1332170682490949270L);
        Assert.assertEquals((Object)new Long(2L), result.get(eventType));
        long count = TmfStatisticsTest.sumOfEvents(result);
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void testGetEventTypesInRangeNoEvents() {
        Map result = backend.getEventTypesInRange(1332170682490948000L, 1332170682490949000L);
        long count = TmfStatisticsTest.sumOfEvents(result);
        Assert.assertEquals((long)0L, (long)count);
    }

    private static long sumOfEvents(Map<String, Long> map) {
        long count = 0L;
        for (long val : map.values()) {
            count += val;
        }
        return count;
    }
}

