/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.trace;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfNanoTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfEventTypeCollectionHelper;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocation;
import org.eclipse.tracecompass.tmf.ctf.core.context.CtfLocationInfo;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class CtfTmfTraceTest {
    private static final CtfTmfTestTrace testTrace = CtfTmfTestTrace.KERNEL;
    private CtfTmfTrace fixture;

    @Before
    public void setUp() throws TmfTraceException {
        Assume.assumeTrue((boolean)testTrace.exists());
        this.fixture = new CtfTmfTrace();
        this.fixture.initTrace(null, testTrace.getPath(), CtfTmfEvent.class);
    }

    @After
    public void tearDown() {
        if (this.fixture != null) {
            this.fixture.dispose();
        }
    }

    @Test
    public void testCtfTmfTrace() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CtfTmfTrace result = new CtfTmfTrace();){
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((long)1000L, (long)result.getCacheSize());
            Assert.assertEquals((long)0L, (long)result.getNbEvents());
            Assert.assertEquals((long)0L, (long)result.getStreamingInterval());
            Assert.assertNull((Object)result.getResource());
            Assert.assertNull((Object)result.getType());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testParseEvent() {
        ITmfContext ctx = this.fixture.seekEvent(0L);
        this.fixture.getNext(ctx);
        CtfTmfEvent event = this.fixture.parseEvent(ctx);
        Assert.assertNotNull((Object)event);
        ctx.dispose();
    }

    @Test
    public void testBroadcast() {
        TmfEndSynchSignal signal = new TmfEndSynchSignal(1);
        this.fixture.broadcast((TmfSignal)signal);
    }

    @Test
    public void testClose() {
        Throwable throwable = null;
        Object var2_2 = null;
        try {
            CtfTmfTrace emptyFixture = new CtfTmfTrace();
            if (emptyFixture != null) {
                emptyFixture.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testGetCacheSize() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CtfTmfTrace emptyFixture = new CtfTmfTrace();){
            int result = emptyFixture.getCacheSize();
            Assert.assertEquals((long)1000L, (long)result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void testGetCurrentLocation() {
        CtfLocation result = (CtfLocation)this.fixture.getCurrentLocation();
        Assert.assertNull((Object)result);
    }

    @Test
    public void testSeekEventLoc_null() {
        ITmfLocation loc = null;
        this.fixture.seekEvent(loc);
        Assert.assertNotNull((Object)this.fixture);
    }

    @Test
    public void testSeekEventLoc_timetamp() {
        CtfLocation loc = new CtfLocation((ITmfTimestamp)new TmfNanoTimestamp(0L));
        this.fixture.seekEvent((ITmfLocation)loc);
        Assert.assertNotNull((Object)this.fixture);
    }

    @Test
    public void testGetEndTime() {
        ITmfTimestamp result = this.fixture.getEndTime();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetEnvValue() {
        String key = "tracer_name";
        String result = (String)this.fixture.getTraceProperties().get(key);
        Assert.assertEquals((Object)"\"lttng-modules\"", (Object)result);
    }

    @Test
    public void testGetEventType() {
        Class result = this.fixture.getEventType();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(CtfTmfEvent.class, (Object)result);
    }

    @Test
    public void testGetContainedEventTypes() {
        Set result = this.fixture.getContainedEventTypes();
        Assert.assertNotNull((Object)result);
        Assert.assertFalse((boolean)result.isEmpty());
    }

    @Test
    public void testGetLocationRatio() {
        ITmfContext context = this.fixture.seekEvent(0L);
        long t1 = ((CtfLocationInfo)context.getLocation().getLocationInfo()).getTimestamp();
        this.fixture.getNext(context);
        long t2 = ((CtfLocationInfo)context.getLocation().getLocationInfo()).getTimestamp();
        this.fixture.getNext(context);
        long t3 = ((CtfLocationInfo)context.getLocation().getLocationInfo()).getTimestamp();
        this.fixture.getNext(context);
        context.dispose();
        double ratio1 = this.fixture.getLocationRatio((ITmfLocation)new CtfLocation(t1, 0L));
        Assert.assertEquals((double)0.0, (double)ratio1, (double)0.01);
        double ratio2 = this.fixture.getLocationRatio((ITmfLocation)new CtfLocation(t2, 0L));
        Assert.assertEquals((double)((double)(t2 - t1) / (double)(t3 - t1)), (double)ratio2, (double)0.01);
        double ratio3 = this.fixture.getLocationRatio((ITmfLocation)new CtfLocation(t3, 0L));
        Assert.assertEquals((double)1.0, (double)ratio3, (double)0.01);
    }

    @Test
    public void testGetName() {
        String result = this.fixture.getName();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetTraceProperties() {
        int result = this.fixture.getTraceProperties().size();
        Assert.assertEquals((long)10L, (long)result);
        Assert.assertEquals((Object)String.valueOf(1332166405241713987L), this.fixture.getTraceProperties().get("clock_offset"));
    }

    @Test
    public void testGetNbEvents() {
        long result = this.fixture.getNbEvents();
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void testGetNext() {
        ITmfContext context = this.fixture.seekEvent(0L);
        CtfTmfEvent result = this.fixture.getNext(context);
        Assert.assertNotNull((Object)result);
        context.dispose();
    }

    @Test
    public void testGetPath() {
        String result = this.fixture.getPath();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetResource() {
        IResource result = this.fixture.getResource();
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetStartTime() {
        ITmfTimestamp result = this.fixture.getStartTime();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetStreamingInterval() {
        long result = this.fixture.getStreamingInterval();
        Assert.assertEquals((long)0L, (long)result);
    }

    @Test
    public void testGetTimeRange() {
        TmfTimeRange result = this.fixture.getTimeRange();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testReadNextEvent() {
        ITmfContext context = this.fixture.seekEvent(0L);
        CtfTmfEvent result = this.fixture.getNext(context);
        Assert.assertNotNull((Object)result);
        context.dispose();
    }

    @Test
    public void testSeekEvent_ratio() {
        ITmfContext context = this.fixture.seekEvent(0L);
        long t1 = ((CtfLocationInfo)context.getLocation().getLocationInfo()).getTimestamp();
        this.fixture.getNext(context);
        long t2 = ((CtfLocationInfo)context.getLocation().getLocationInfo()).getTimestamp();
        this.fixture.getNext(context);
        long t3 = ((CtfLocationInfo)context.getLocation().getLocationInfo()).getTimestamp();
        this.fixture.getNext(context);
        context.dispose();
        context = this.fixture.seekEvent(0.0);
        Assert.assertEquals((long)t1, (long)((CtfLocationInfo)context.getLocation().getLocationInfo()).getTimestamp());
        context.dispose();
        context = this.fixture.seekEvent(0.5);
        Assert.assertEquals((long)t2, (long)((CtfLocationInfo)context.getLocation().getLocationInfo()).getTimestamp());
        context.dispose();
        context = this.fixture.seekEvent(1.0);
        Assert.assertEquals((long)t3, (long)((CtfLocationInfo)context.getLocation().getLocationInfo()).getTimestamp());
        context.dispose();
    }

    @Test
    public void testSeekEvent_rank() {
        long rank = 1L;
        ITmfContext result = this.fixture.seekEvent(rank);
        Assert.assertNotNull((Object)result);
        result.dispose();
    }

    @Test
    public void testSeekEvent_timestamp() {
        TmfTimestamp timestamp = new TmfTimestamp();
        ITmfContext result = this.fixture.seekEvent((ITmfTimestamp)timestamp);
        Assert.assertNotNull((Object)result);
        result.dispose();
    }

    @Test
    public void testSeekEvent_location() {
        CtfLocationInfo location2 = new CtfLocationInfo(1L, 0L);
        CtfLocation ctfLocation = new CtfLocation(location2);
        ITmfContext result = this.fixture.seekEvent((ITmfLocation)ctfLocation);
        Assert.assertNotNull((Object)result);
        result.dispose();
    }

    @Test
    public void testSeekEventInvalidLocation() {
        CtfLocation ctfLocation = new CtfLocation(CtfLocation.INVALID_LOCATION);
        ITmfContext result = this.fixture.seekEvent((ITmfLocation)ctfLocation);
        Assert.assertNull((Object)this.fixture.getNext(result));
        Assert.assertEquals((Object)CtfLocation.INVALID_LOCATION, (Object)result.getLocation().getLocationInfo());
        result.dispose();
        CtfLocationInfo invalidLocation = new CtfLocationInfo(CtfLocation.INVALID_LOCATION.getTimestamp(), CtfLocation.INVALID_LOCATION.getIndex());
        ctfLocation = new CtfLocation(invalidLocation);
        result = this.fixture.seekEvent((ITmfLocation)ctfLocation);
        Assert.assertNull((Object)this.fixture.getNext(result));
        Assert.assertEquals((Object)CtfLocation.INVALID_LOCATION, (Object)result.getLocation().getLocationInfo());
        result.dispose();
    }

    @Test
    public void testValidate() {
        IProject project = null;
        IStatus result = this.fixture.validate(project, testTrace.getPath());
        Assert.assertTrue((boolean)result.isOK());
    }

    @Test
    public void testEventLookup() {
        Set eventTypes = this.fixture.getContainedEventTypes();
        Set eventNames = TmfEventTypeCollectionHelper.getEventNames((Iterable)eventTypes);
        Assert.assertTrue((boolean)eventNames.contains("sched_switch"));
        Assert.assertFalse((boolean)eventNames.contains("Sched_switch"));
        String[] events = new String[]{"sched_switch", "sched_wakeup", "timer_init"};
        Assert.assertTrue((boolean)eventNames.containsAll(Arrays.asList(events)));
        HashSet copy = new HashSet(eventNames);
        copy.retainAll(Arrays.asList(events));
        Assert.assertFalse((boolean)copy.isEmpty());
        String[] names = new String[]{"inexistent", "sched_switch", "SomeThing"};
        copy = new HashSet(eventNames);
        copy.retainAll(Arrays.asList(names));
        Assert.assertTrue((!copy.isEmpty() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)eventNames.containsAll(Arrays.asList(names)));
    }

    @Test
    public void testCtfHostId() {
        String a = this.fixture.getHostId();
        Assert.assertEquals((Object)"\"84db105b-b3f4-4821-b662-efc51455106a\"", (Object)a);
    }
}

