/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.core.tests.trace.indexer;

import java.io.File;
import org.eclipse.tracecompass.ctf.core.tests.shared.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.TmfBTreeTraceIndexer;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpointIndex;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CtfExperimentCheckpointIndexTest {
    private static final String EXPERIMENT = "MyExperiment";
    private static final CtfTmfTestTrace TEST_TRACE1 = CtfTmfTestTrace.TRACE2;
    private static final CtfTmfTestTrace TEST_TRACE2 = CtfTmfTestTrace.KERNEL_VM;
    private static final int NB_EVENTS = CtfTestTrace.TRACE2.getNbEvents() + CtfTestTrace.KERNEL_VM.getNbEvents();
    private static final long START_TIME = 1331668247314038062L;
    private static final long END_TIME = 1363700770550261288L;
    private static final int BLOCK_SIZE = 50000;
    private static final int LAST_EVENT_RANK = NB_EVENTS - 1;
    private static final int LAST_CHECKPOINT_RANK = LAST_EVENT_RANK / 50000;
    private static final int NB_CHECKPOINTS = LAST_CHECKPOINT_RANK + 1;
    private static ITmfTrace[] fTestTraces;
    private static TmfExperiment fExperiment;
    private static TestIndexer fIndexer;

    @BeforeClass
    public static void setUpClass() {
        Assume.assumeTrue((boolean)TEST_TRACE1.exists());
        Assume.assumeTrue((boolean)TEST_TRACE2.exists());
    }

    @Before
    public void setUp() {
        CtfExperimentCheckpointIndexTest.deleteSupplementaryFiles();
        CtfExperimentCheckpointIndexTest.setUpTraces();
    }

    private static void setUpTraces() {
        fTestTraces = new ITmfTrace[2];
        CtfExperimentCheckpointIndexTest.fTestTraces[0] = TEST_TRACE1.getTrace();
        CtfExperimentCheckpointIndexTest.fTestTraces[1] = TEST_TRACE2.getTrace();
        fExperiment = new TmfExperiment(ITmfEvent.class, EXPERIMENT, fTestTraces, 50000, null){

            protected ITmfTraceIndexer createIndexer(int interval) {
                fIndexer = new TestIndexer((ITmfTrace)this, interval);
                return fIndexer;
            }
        };
        fExperiment.indexTrace(true);
    }

    @After
    public void tearDown() {
        CtfExperimentCheckpointIndexTest.deleteSupplementaryFiles();
        CtfExperimentCheckpointIndexTest.disposeTraces();
    }

    private static void deleteSupplementaryFiles() {
        String TRACE_DIRECTORY = String.valueOf(TmfTraceManager.getTemporaryDirPath()) + File.separator + EXPERIMENT;
        File supplementaryFileDir = new File(TRACE_DIRECTORY);
        if (supplementaryFileDir.exists()) {
            File[] fileArray = supplementaryFileDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
        }
    }

    private static void disposeTraces() {
        fExperiment.dispose();
        fExperiment = null;
        ITmfTrace[] iTmfTraceArray = fTestTraces;
        int n = fTestTraces.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            trace.dispose();
            ++n2;
        }
        fTestTraces = null;
    }

    @Test
    public void testIndexing() {
        Assert.assertTrue((boolean)fIndexer.getCheckpoints().isCreatedFromScratch());
        CtfExperimentCheckpointIndexTest.verifyIndexContent();
    }

    @Test
    public void testReopenIndex() {
        Assert.assertTrue((boolean)fIndexer.getCheckpoints().isCreatedFromScratch());
        CtfExperimentCheckpointIndexTest.disposeTraces();
        CtfExperimentCheckpointIndexTest.setUpTraces();
        Assert.assertFalse((boolean)fIndexer.getCheckpoints().isCreatedFromScratch());
        CtfExperimentCheckpointIndexTest.verifyIndexContent();
    }

    private static void verifyIndexContent() {
        Assert.assertEquals((String)"getTraceSize", (long)NB_EVENTS, (long)fExperiment.getNbEvents());
        Assert.assertEquals((String)"getRange-start", (long)1331668247314038062L, (long)fExperiment.getTimeRange().getStartTime().getValue());
        Assert.assertEquals((String)"getRange-end", (long)1363700770550261288L, (long)fExperiment.getTimeRange().getEndTime().getValue());
        Assert.assertEquals((String)"getStartTime", (long)1331668247314038062L, (long)fExperiment.getStartTime().getValue());
        Assert.assertEquals((String)"getEndTime", (long)1363700770550261288L, (long)fExperiment.getEndTime().getValue());
        ITmfCheckpointIndex checkpoints = fIndexer.getCheckpoints();
        Assert.assertTrue((checkpoints != null ? 1 : 0) != 0);
        Assert.assertEquals((long)NB_EVENTS, (long)checkpoints.getNbEvents());
        Assert.assertEquals((long)NB_CHECKPOINTS, (long)checkpoints.size());
        int i = 0;
        while (i < checkpoints.size()) {
            ITmfCheckpoint checkpoint = checkpoints.get((long)i);
            TmfContext context = new TmfContext(checkpoint.getLocation(), (long)(i * 50000));
            ITmfEvent event = fExperiment.parseEvent((ITmfContext)context);
            Assert.assertEquals((long)context.getRank(), (long)(i * 50000));
            Assert.assertEquals((long)0L, (long)checkpoint.getTimestamp().compareTo(event.getTimestamp()));
            ++i;
        }
        ITmfContext context = fExperiment.seekEvent(0L);
        ITmfEvent event = fExperiment.getNext(context);
        Assert.assertEquals((long)1331668247314038062L, (long)event.getTimestamp().getValue());
        context = fExperiment.seekEvent((long)(NB_EVENTS - 1));
        event = fExperiment.getNext(context);
        Assert.assertEquals((long)1363700770550261288L, (long)event.getTimestamp().getValue());
    }

    private static class TestIndexer
    extends TmfBTreeTraceIndexer {
        public TestIndexer(ITmfTrace trace, int interval) {
            super(trace, interval);
        }

        public ITmfCheckpointIndex getCheckpoints() {
            return this.getTraceIndex();
        }
    }
}

