/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.ui.swtbot.tests;

import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEventsEditor;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramView;
import org.eclipse.tracecompass.tmf.ui.views.statistics.TmfStatisticsView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public abstract class AbstractImportAndReadSmokeTest {
    protected static final String TRACE_NAME = "scp_dest";
    protected static final String TRACE_FOLDER = "synctraces";
    protected static final String TRACE_TYPE_NAME = "Generic CTF Trace";
    protected static final CtfTmfTestTrace fTrace = CtfTmfTestTrace.SYNC_DEST;
    protected static SWTWorkbenchBot fBot;
    protected static Wizard fWizard;
    protected static final Logger fLogger;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void init() {
        Assume.assumeTrue((boolean)fTrace.exists());
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 50000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new NullAppender());
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)fBot);
        SWTBotUtils.switchToTracingPerspective();
        SWTBotUtils.waitForJobs();
    }

    @AfterClass
    public static void terminate() {
        fLogger.removeAllAppenders();
    }

    protected void createProject() {
        SWTBotUtils.focusMainWindow((SWTBotShell[])fBot.shells());
        fBot.menu("File").menu("New").menu("Project...").click();
        fBot.shell("New Project").setFocus();
        SWTBotTree tree = fBot.tree();
        Assert.assertNotNull((Object)tree);
        String tracingKey = "Tracing";
        fBot.waitUntil(ConditionHelpers.IsTreeNodeAvailable((String)"Tracing", (SWTBotTree)tree));
        SWTBotTreeItem tracingNode = tree.expandNode(new String[]{"Tracing"});
        tracingNode.select();
        String projectKey = "Tracing Project";
        fBot.waitUntil(ConditionHelpers.IsTreeChildNodeAvailable((String)"Tracing Project", (SWTBotTreeItem)tracingNode));
        SWTBotTreeItem tracingProject = tracingNode.getNode("Tracing Project");
        Assert.assertNotNull((Object)tracingProject);
        tracingProject.select();
        tracingProject.click();
        SWTBotButton nextButton = fBot.button("Next >");
        fBot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)nextButton));
        nextButton.click();
        fBot.shell("Tracing Project").setFocus();
        SWTBotText text = fBot.text();
        text.setText(this.getProjectName());
        fBot.button("Finish").click();
        SWTBotUtils.waitForJobs();
    }

    protected void importFinish() {
        SWTBotShell shell = fBot.activeShell();
        SWTBotButton finishButton = fBot.button("Finish");
        finishButton.click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)shell));
        SWTBotUtils.waitForJobs();
    }

    protected abstract String getProjectName();

    protected void testPropertyView(IViewPart vp) {
        PropertySheet pv = (PropertySheet)vp;
        Assert.assertNotNull((Object)pv);
    }

    protected void testHistogramView(IViewPart vp, final TmfEventsEditor tmfEd) {
        final CtfTmfEvent desiredEvent1 = this.getEvent(100);
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                tmfEd.setFocus();
                tmfEd.selectionChanged(new SelectionChangedEvent((ISelectionProvider)tmfEd, (ISelection)new StructuredSelection((Object)desiredEvent1)));
            }
        });
        SWTBotUtils.waitForJobs();
        SWTBotUtils.delay((long)1000L);
        CtfTmfEvent desiredEvent2 = this.getEvent(10000);
        SWTBotView hvBot = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.histogram");
        List hvTools = hvBot.getToolbarButtons();
        for (SWTBotToolbarButton hvTool : hvTools) {
            if (!hvTool.getToolTipText().toLowerCase().contains("lost")) continue;
            hvTool.click();
        }
        HistogramView hv = (HistogramView)vp;
        TmfSelectionRangeUpdatedSignal signal = new TmfSelectionRangeUpdatedSignal((Object)hv, desiredEvent1.getTimestamp());
        TmfSelectionRangeUpdatedSignal signal2 = new TmfSelectionRangeUpdatedSignal((Object)hv, desiredEvent2.getTimestamp());
        hv.updateTimeRange(100000L);
        SWTBotUtils.waitForJobs();
        hv.selectionRangeUpdated(signal);
        hv.broadcast((TmfSignal)signal);
        SWTBotUtils.waitForJobs();
        SWTBotUtils.delay((long)1000L);
        hv.updateTimeRange(1000000000L);
        SWTBotUtils.waitForJobs();
        hv.selectionRangeUpdated(signal2);
        hv.broadcast((TmfSignal)signal2);
        SWTBotUtils.waitForJobs();
        SWTBotUtils.delay((long)1000L);
        Assert.assertNotNull((Object)hv);
    }

    protected void testStatisticsView(IViewPart vp) {
        TmfStatisticsView sv = (TmfStatisticsView)vp;
        Assert.assertNotNull((Object)sv);
    }

    protected CtfTmfEvent getEvent(int rank) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (CtfTmfTrace trace = fTrace.getTrace();){
            ITmfContext ctx = trace.seekEvent(0L);
            int i = 0;
            while (i < rank) {
                trace.getNext(ctx);
                ++i;
            }
            return trace.getNext(ctx);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected IViewPart getViewPart(final String viewTile) {
        final IViewPart[] vps = new IViewPart[1];
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                IViewReference[] viewRefs;
                IViewReference[] iViewReferenceArray = viewRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
                int n = viewRefs.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference viewRef = iViewReferenceArray[n2];
                    IViewPart vp = viewRef.getView(true);
                    if (vp.getTitle().equals(viewTile)) {
                        vps[0] = vp;
                        return;
                    }
                    ++n2;
                }
            }
        });
        return vps[0];
    }
}

