/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ctf.ui.swtbot.tests;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCheckBox;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotRadio;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportTraceWizard;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportTraceWizardPage;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.ctf.ui.swtbot.tests.AbstractImportAndReadSmokeTest;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEventsEditor;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class StandardImportAndReadSmokeTest
extends AbstractImportAndReadSmokeTest {
    private static final String TRACE_FOLDER_PARENT_PATH = String.valueOf(fTrace.getPath()) + File.separator + ".." + File.separator + ".." + File.separator;
    private static final String ARCHIVE_FILE_NAME = "synctraces.tar.gz";
    private static final String EMPTY_ARCHIVE_FOLDER = "emptyArchiveFolder";
    private static final String EMPTY_FILE_NAME = "emptyFile";
    private static final String TRACE_ARCHIVE_PATH = String.valueOf(TRACE_FOLDER_PARENT_PATH) + "synctraces.tar.gz";
    private static final String TRACE_FOLDER_PARENT_NAME = "traces";
    private static final String TRACE_PROJECT_NAME = "Tracing";
    private static final String ARCHIVE_ROOT_ELEMENT_NAME = "/";
    private static final String GENERATED_ARCHIVE_NAME = "testtraces.zip";
    private static final String URI_SEPARATOR = "/";
    private static final String URI_FILE_SCHEME = "file:";
    private static final String URI_JAR_FILE_SCHEME = "jar:file:";
    private static final boolean IS_WIN32 = System.getProperty("os.name").startsWith("Windows");
    private static final String URI_DEVICE_SEPARATOR = IS_WIN32 ? "/" : "";

    @Test
    public void testImportFromDirectory() throws Exception {
        this.testImport(0, false, false);
    }

    @Test
    public void testImportFromDirectoryLinks() throws Exception {
        this.testImport(4, false, false);
    }

    @Test
    public void testImportFromDirectoryPreserveFolder() throws Exception {
        this.testImport(2, false, false);
    }

    @Test
    public void testImportFromDirectoryLinksPreserveFolder() throws Exception {
        int options = 6;
        this.testImport(options, false, false);
    }

    @Test
    public void testImportFromDirectoryOverwrite() throws Exception {
        this.testImport(0, false, false);
        this.testImport(16, false, false);
    }

    @Test
    public void testImportFromArchive() throws Exception {
        this.testImport(2, true, true);
    }

    @Test
    public void testImportFromArchivePreserveFolder() throws Exception {
        this.testImport(2, false, true);
    }

    @Test
    public void testImportFromArchiveOverwrite() throws Exception {
        this.testImport(0, false, true);
        this.testImport(16, false, true);
    }

    @Test
    public void testExtractArchivesFromDirectory() throws Exception {
        this.testImportAndExtractArchives(16, false);
    }

    @Test
    public void testExtractArchivesFromDirectoryLinks() throws Exception {
        this.testImportAndExtractArchives(20, false);
    }

    @Test
    public void testExtractArchivesFromDirectoryLinksPreserveStruture() throws Exception {
        this.testImportAndExtractArchives(22, false);
    }

    @Test
    public void testExtractArchivesFromArchive() throws Exception {
        this.testImportAndExtractArchives(16, true);
    }

    @Test
    public void testExtractArchivesFromArchivePreserveFolder() throws Exception {
        this.testImportAndExtractArchives(18, true);
    }

    @Test
    public void testEmptyArchive() throws Exception {
        this.createProject();
        String testArchivePath = this.createEmptyArchive();
        StandardImportAndReadSmokeTest.openImportWizard();
        StandardImportAndReadSmokeTest.selectImportFromArchive(testArchivePath);
        StandardImportAndReadSmokeTest.selectFolder("/");
        StandardImportAndReadSmokeTest.setOptions(0, ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        this.importFinish();
        this.assertNoTraces();
        SWTBotUtils.deleteProject((String)this.getProjectName(), (SWTWorkbenchBot)fBot);
    }

    @Test
    public void testEmptyDirectory() throws Exception {
        this.createProject();
        String testDirectoryPath = this.createEmptyDirectory().getLocation().toOSString();
        StandardImportAndReadSmokeTest.openImportWizard();
        StandardImportAndReadSmokeTest.selectImportFromDirectory(testDirectoryPath);
        StandardImportAndReadSmokeTest.selectFolder(EMPTY_ARCHIVE_FOLDER);
        StandardImportAndReadSmokeTest.setOptions(0, ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        this.importFinish();
        this.assertNoTraces();
        SWTBotUtils.deleteProject((String)this.getProjectName(), (SWTWorkbenchBot)fBot);
    }

    @Test
    public void testEmptyFile() throws Exception {
        this.createProject();
        IFolder folder = this.createEmptyDirectory();
        StandardImportAndReadSmokeTest.createEmptyFile(folder);
        String testDirectoryPath = folder.getLocation().toOSString();
        StandardImportAndReadSmokeTest.openImportWizard();
        StandardImportAndReadSmokeTest.selectImportFromDirectory(testDirectoryPath);
        StandardImportAndReadSmokeTest.selectFile(EMPTY_FILE_NAME, EMPTY_ARCHIVE_FOLDER);
        StandardImportAndReadSmokeTest.setOptions(8, ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        this.importFinish();
        this.assertNoTraces();
        SWTBotUtils.deleteProject((String)this.getProjectName(), (SWTWorkbenchBot)fBot);
    }

    @Test
    public void testDirectoryWithEmptyArchive() throws Exception {
        this.createProject();
        this.createEmptyArchive();
        StandardImportAndReadSmokeTest.openImportWizard();
        StandardImportAndReadSmokeTest.selectImportFromDirectory(this.getProjectResource().getLocation().toOSString());
        StandardImportAndReadSmokeTest.selectFile(GENERATED_ARCHIVE_NAME, this.getProjectName());
        StandardImportAndReadSmokeTest.setOptions(0, ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        this.importFinish();
        this.assertNoTraces();
        SWTBotUtils.deleteProject((String)this.getProjectName(), (SWTWorkbenchBot)fBot);
    }

    @Test
    public void testNestedEmptyArchive() throws Exception {
        this.createProject();
        IProject project = this.getProjectResource();
        String testArchivePath = this.createEmptyArchive();
        project.refreshLocal(1, null);
        IFile[] files = project.getWorkspace().getRoot().findFilesForLocationURI(new File(testArchivePath).toURI());
        IFile archiveFile = files[0];
        String newEmptyArchiveName = "nested" + archiveFile.getName();
        IPath dest = archiveFile.getFullPath().removeLastSegments(1).append(newEmptyArchiveName);
        archiveFile.move(dest, true, null);
        IFile renamedArchiveFile = archiveFile.getWorkspace().getRoot().getFile(dest);
        StandardImportAndReadSmokeTest.createArchive((IResource)renamedArchiveFile);
        StandardImportAndReadSmokeTest.openImportWizard();
        StandardImportAndReadSmokeTest.selectImportFromArchive(testArchivePath);
        StandardImportAndReadSmokeTest.selectFolder("/");
        StandardImportAndReadSmokeTest.setOptions(0, ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        this.importFinish();
        this.assertNoTraces();
        SWTBotUtils.deleteProject((String)this.getProjectName(), (SWTWorkbenchBot)fBot);
    }

    private void assertNoTraces() {
        TmfProjectElement tmfProject = TmfProjectRegistry.getProject((IProject)this.getProjectResource(), (boolean)true);
        Assert.assertNotNull((Object)tmfProject);
        TmfTraceFolder tracesFolder = tmfProject.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertTrue((boolean)traces.isEmpty());
    }

    private void testImport(int options, boolean testViews, boolean fromArchive) throws Exception {
        this.createProject();
        String expectedSourceLocation = null;
        StandardImportAndReadSmokeTest.openImportWizard();
        if (fromArchive) {
            expectedSourceLocation = URI_JAR_FILE_SCHEME + URI_DEVICE_SEPARATOR + new Path(new File(TRACE_ARCHIVE_PATH).getCanonicalPath()) + "!" + "/" + "synctraces" + "/" + "scp_dest" + "/";
            StandardImportAndReadSmokeTest.selectImportFromArchive(TRACE_ARCHIVE_PATH);
            StandardImportAndReadSmokeTest.selectFolder("/");
            SWTBotCheckBox checkBox = fBot.checkBox(Messages.ImportTraceWizard_CreateLinksInWorkspace);
            Assert.assertFalse((boolean)checkBox.isEnabled());
        } else {
            String sourcePath = String.valueOf(TRACE_FOLDER_PARENT_PATH) + File.separator + "synctraces" + File.separator + "scp_dest";
            expectedSourceLocation = URI_FILE_SCHEME + URI_DEVICE_SEPARATOR + new Path(new File(sourcePath).getCanonicalPath()) + "/";
            StandardImportAndReadSmokeTest.selectImportFromDirectory(TRACE_FOLDER_PARENT_PATH);
            StandardImportAndReadSmokeTest.selectFolder(TRACE_FOLDER_PARENT_NAME, "synctraces");
        }
        StandardImportAndReadSmokeTest.setOptions(options, ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        this.importFinish();
        Path expectedElementPath = new Path("scp_dest");
        if ((options & 2) != 0) {
            expectedElementPath = new Path("synctraces").append((IPath)expectedElementPath);
        }
        this.checkOptions(options, expectedSourceLocation, (IPath)expectedElementPath);
        TmfEventsEditor tmfEd = SWTBotUtils.openEditor((SWTWorkbenchBot)fBot, (String)this.getProjectName(), (IPath)expectedElementPath);
        if (testViews) {
            this.testViews(tmfEd);
        }
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject((String)this.getProjectName(), (SWTWorkbenchBot)fBot);
    }

    private void testImportAndExtractArchives(int options, boolean fromArchive) throws Exception {
        IPath expectedElementPath;
        String expectedSourceLocation;
        this.createProject();
        if (fromArchive) {
            String testArchivePath = this.createNestedArchive();
            StandardImportAndReadSmokeTest.openImportWizard();
            StandardImportAndReadSmokeTest.selectImportFromArchive(testArchivePath);
            StandardImportAndReadSmokeTest.selectFile(ARCHIVE_FILE_NAME, "/", TRACE_PROJECT_NAME, TRACE_FOLDER_PARENT_NAME);
            expectedSourceLocation = URI_JAR_FILE_SCHEME + URI_DEVICE_SEPARATOR + new Path(new File(testArchivePath).getCanonicalPath()) + "!" + "/" + TRACE_PROJECT_NAME + "/" + TRACE_FOLDER_PARENT_NAME + "/" + ARCHIVE_FILE_NAME + "/" + "synctraces" + "/" + "scp_dest" + "/";
            expectedElementPath = new Path(TRACE_PROJECT_NAME).append(TRACE_FOLDER_PARENT_NAME).append(ARCHIVE_FILE_NAME).append("synctraces").append("scp_dest");
        } else {
            StandardImportAndReadSmokeTest.openImportWizard();
            StandardImportAndReadSmokeTest.selectImportFromDirectory(TRACE_FOLDER_PARENT_PATH);
            StandardImportAndReadSmokeTest.selectFile(ARCHIVE_FILE_NAME, TRACE_FOLDER_PARENT_NAME);
            expectedElementPath = new Path(ARCHIVE_FILE_NAME).append("synctraces").append("scp_dest");
            expectedSourceLocation = URI_FILE_SCHEME + URI_DEVICE_SEPARATOR + new Path(new File(TRACE_FOLDER_PARENT_PATH).getCanonicalPath()) + "/" + ARCHIVE_FILE_NAME + "/" + "synctraces" + "/" + "scp_dest" + "/";
        }
        if ((options & 2) == 0) {
            expectedElementPath = new Path("scp_dest");
        }
        StandardImportAndReadSmokeTest.setOptions(options, ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        this.importFinish();
        int expectedOptions = options & 0xFFFFFFFB;
        this.checkOptions(expectedOptions, expectedSourceLocation, expectedElementPath);
        TmfEventsEditor editor = SWTBotUtils.openEditor((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME, (IPath)expectedElementPath);
        this.testViews(editor);
        SWTBotUtils.deleteProject((String)this.getProjectName(), (SWTWorkbenchBot)fBot);
    }

    private String createNestedArchive() throws IOException, CoreException, URISyntaxException {
        IProject project = this.getProjectResource();
        String canonicalPath = new File(TRACE_FOLDER_PARENT_PATH).getCanonicalPath();
        IFolder folder = project.getFolder(TRACE_FOLDER_PARENT_NAME);
        folder.createLink((IPath)new Path(canonicalPath), 256, null);
        IFile file = folder.getFile(ARCHIVE_FILE_NAME);
        return StandardImportAndReadSmokeTest.createArchive((IResource)file);
    }

    private String createEmptyArchive() throws CoreException, URISyntaxException {
        return StandardImportAndReadSmokeTest.createArchive((IResource)this.createEmptyDirectory());
    }

    private IFolder createEmptyDirectory() throws CoreException {
        IProject project = this.getProjectResource();
        IFolder folder = project.getFolder(EMPTY_ARCHIVE_FOLDER);
        folder.create(true, true, null);
        return folder;
    }

    private static void createEmptyFile(IFolder folder) throws CoreException {
        IFile file = folder.getFile(EMPTY_FILE_NAME);
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
    }

    private static String createArchive(IResource sourceResource) throws URISyntaxException {
        IPath exportedPath = sourceResource.getFullPath();
        SWTBotTreeItem traceFilesProject = SWTBotUtils.selectProject((SWTWorkbenchBot)fBot, (String)TRACE_PROJECT_NAME);
        traceFilesProject.contextMenu("Export...").click();
        fBot.waitUntil(Conditions.shellIsActive((String)"Export"));
        SWTBotShell activeShell = fBot.activeShell();
        SWTBotTree exportWizardsTree = fBot.tree();
        SWTBotTreeItem treeItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)exportWizardsTree, (String[])new String[]{"General", "Archive File"});
        treeItem.select();
        fBot.button("Next >").click();
        fBot.button("&Deselect All").click();
        if (sourceResource instanceof IFile) {
            String[] folderPath = exportedPath.removeLastSegments(1).segments();
            String fileName = exportedPath.lastSegment();
            StandardImportAndReadSmokeTest.selectFile(fileName, folderPath);
        } else {
            StandardImportAndReadSmokeTest.selectFolder(exportedPath.segments());
        }
        String workspacePath = URIUtil.toFile((URI)URIUtil.fromString((String)System.getProperty("osgi.instance.area"))).getAbsolutePath();
        String archiveDestinationPath = String.valueOf(workspacePath) + File.separator + TRACE_PROJECT_NAME + File.separator + GENERATED_ARCHIVE_NAME;
        fBot.comboBox().setText(archiveDestinationPath);
        fBot.button("&Finish").click();
        fBot.waitUntil(Conditions.shellCloses((SWTBotShell)activeShell));
        return archiveDestinationPath;
    }

    private void testViews(TmfEventsEditor editor) {
        this.testHistogramView(this.getViewPart("Histogram"), editor);
        this.testPropertyView(this.getViewPart("Properties"));
        this.testStatisticsView(this.getViewPart("Statistics"));
    }

    private static void openImportWizard() {
        fWizard = new ImportTraceWizard();
        UIThreadRunnable.asyncExec((VoidResult)new VoidResult(){

            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (workbench != null) {
                    IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                    Shell shell = activeWorkbenchWindow.getShell();
                    Assert.assertNotNull((Object)shell);
                    ((ImportTraceWizard)fWizard).init(PlatformUI.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
                    WizardDialog dialog = new WizardDialog(shell, (IWizard)fWizard);
                    dialog.open();
                }
            }
        });
        fBot.waitUntil(ConditionHelpers.isWizardReady((Wizard)fWizard));
    }

    private static void selectImportFromDirectory(String directoryPath) {
        SWTBotRadio button = fBot.radio("Select roo&t directory:");
        button.click();
        SWTBotCombo sourceCombo = fBot.comboBox();
        File traceFolderParent = new File(directoryPath);
        sourceCombo.setText(traceFolderParent.getAbsolutePath());
        SWTBotText text = fBot.text();
        text.setFocus();
    }

    private static void selectImportFromArchive(String archivePath) {
        SWTBotRadio button = fBot.radio("Select &archive file:");
        button.click();
        SWTBotCombo sourceCombo = fBot.comboBox(1);
        sourceCombo.setText(new File(archivePath).getAbsolutePath());
        SWTBotText text = fBot.text();
        text.setFocus();
    }

    private static void selectFolder(String ... treePath) {
        StandardImportAndReadSmokeTest.selectFolder(true, treePath);
    }

    private static void selectFolder(boolean check, String ... treePath) {
        SWTBotTree tree = fBot.tree();
        fBot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)tree));
        SWTBotTreeItem folderNode = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)tree, (String[])treePath);
        if (check) {
            folderNode.check();
        } else {
            folderNode.select();
        }
    }

    private static void selectFile(String fileName, String ... folderTreePath) {
        StandardImportAndReadSmokeTest.selectFolder(false, folderTreePath);
        SWTBotTable fileTable = fBot.table();
        fBot.waitUntil(Conditions.widgetIsEnabled((AbstractSWTBot)fileTable));
        fBot.waitUntil(ConditionHelpers.isTableItemAvailable((String)fileName, (SWTBotTable)fileTable));
        SWTBotTableItem tableItem = fileTable.getTableItem(fileName);
        tableItem.check();
    }

    private static void setOptions(int optionFlags, String traceTypeName) {
        SWTBotCheckBox checkBox = fBot.checkBox(Messages.ImportTraceWizard_CreateLinksInWorkspace);
        if (checkBox.isEnabled()) {
            if ((optionFlags & 4) != 0) {
                checkBox.select();
            } else {
                checkBox.deselect();
            }
        }
        checkBox = fBot.checkBox(Messages.ImportTraceWizard_PreserveFolderStructure);
        if ((optionFlags & 2) != 0) {
            checkBox.select();
        } else {
            checkBox.deselect();
        }
        checkBox = fBot.checkBox(Messages.ImportTraceWizard_ImportUnrecognized);
        if ((optionFlags & 8) != 0) {
            checkBox.select();
        } else {
            checkBox.deselect();
        }
        checkBox = fBot.checkBox(Messages.ImportTraceWizard_OverwriteExistingTrace);
        if ((optionFlags & 0x10) != 0) {
            checkBox.select();
        } else {
            checkBox.deselect();
        }
        SWTBotCombo comboBox = fBot.comboBoxWithLabel(Messages.ImportTraceWizard_TraceType);
        if (traceTypeName != null && !traceTypeName.isEmpty()) {
            comboBox.setSelection(traceTypeName);
        } else {
            comboBox.setSelection(ImportTraceWizardPage.TRACE_TYPE_AUTO_DETECT);
        }
    }

    private void checkOptions(int optionFlags, String expectedSourceLocation, IPath expectedElementPath) throws CoreException {
        IProject project = this.getProjectResource();
        Assert.assertTrue((boolean)project.exists());
        TmfProjectElement tmfProject = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
        Assert.assertNotNull((Object)tmfProject);
        TmfTraceFolder tracesFolder = tmfProject.getTracesFolder();
        Assert.assertNotNull((Object)tracesFolder);
        List traces = tracesFolder.getTraces();
        Assert.assertFalse((boolean)traces.isEmpty());
        Collections.sort(traces, new Comparator<TmfTraceElement>(){

            @Override
            public int compare(TmfTraceElement arg0, TmfTraceElement arg1) {
                return arg0.getElementPath().compareTo(arg1.getElementPath());
            }
        });
        TmfTraceElement tmfTraceElement = (TmfTraceElement)traces.get(0);
        IResource traceResource = tmfTraceElement.getResource();
        Assert.assertEquals((Object)((optionFlags & 4) != 0 ? 1 : 0), (Object)traceResource.isLinked());
        IPath expectedPath = Path.ROOT.append((IPath)new Path(TRACE_PROJECT_NAME)).append("Traces").append(expectedElementPath);
        Assert.assertEquals((Object)expectedPath, (Object)traceResource.getFullPath());
        String sourceLocation = traceResource.getPersistentProperty(TmfCommonConstants.SOURCE_LOCATION);
        Assert.assertNotNull((Object)sourceLocation);
        Assert.assertEquals((Object)expectedSourceLocation, (Object)sourceLocation);
    }

    @Override
    protected String getProjectName() {
        return TRACE_PROJECT_NAME;
    }

    private IProject getProjectResource() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }
}

