/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.pcap.core.tests.shared;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.PcapEvent;
import org.eclipse.tracecompass.internal.tmf.pcap.core.trace.PcapTrace;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.pcap.core.tests.stubs.PcapTmfTraceStub;

@NonNullByDefault
public enum PcapTmfTestTrace {
    BAD_PCAPFILE,
    EMPTY_PCAP,
    MOSTLY_TCP,
    MOSTLY_UDP,
    SHORT_BIG_ENDIAN,
    SHORT_LITTLE_ENDIAN,
    BENCHMARK_TRACE,
    KERNEL_DIRECTORY,
    KERNEL_TRACE;

    private final String fPath;
    @Nullable
    private PcapTmfTraceStub fTrace = null;

    private PcapTmfTestTrace() {
        String path;
        this.fPath = path = PcapTestTrace.valueOf((String)this.name()).getPath().toString();
    }

    public String getPath() {
        return this.fPath;
    }

    public synchronized PcapTrace getTrace() {
        PcapTmfTraceStub trace = this.fTrace;
        if (trace != null) {
            trace.dispose();
        }
        trace = new PcapTmfTraceStub();
        try {
            trace.initTrace(null, this.fPath, PcapEvent.class);
        }
        catch (TmfTraceException e) {
            throw new RuntimeException(e);
        }
        this.fTrace = trace;
        return trace;
    }

    public boolean exists() {
        return PcapTestTrace.valueOf((String)this.name()).exists();
    }

    public void dispose() {
        if (this.fTrace != null) {
            this.fTrace.dispose();
            this.fTrace = null;
        }
    }
}

