/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.tracecompass.tmf.core.tests.TmfCoreTestPlugin;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class CallsiteEventsInTableTest {
    private static final String TRACE_PROJECT_NAME = "test";
    private static final String CALLSITE_TRACE_NAME = "syslog_collapse";
    private static final String CALLSITE_TRACE_PATH = "testfiles/syslog_collapse";
    private static final String CALLSITE_TRACE_TYPE = "org.eclipse.linuxtools.tmf.tests.stubs.trace.text.testsyslog";
    private static final String SOURCE_FILE_NAME = "SourceFile";
    private static final String SOURCE_FILE_PATH = "testfiles/SourceFile";
    private static File fTestFile = null;
    private static File fSourceFile = null;
    private static SWTWorkbenchBot fBot;
    private static final Logger fLogger;

    static {
        fLogger = Logger.getRootLogger();
    }

    @BeforeClass
    public static void init() {
        URI uri;
        SWTBotUtils.initialize();
        URL location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(CALLSITE_TRACE_PATH), null);
        try {
            uri = FileLocator.toFileURL((URL)location).toURI();
            fTestFile = new File(uri);
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            Assert.fail();
        }
        Assume.assumeTrue((boolean)fTestFile.exists());
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", "MMM d HH:mm:ss");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec", "");
        TmfTimestampFormat.updateDefaultFormats();
        location = FileLocator.find((Bundle)TmfCoreTestPlugin.getDefault().getBundle(), (IPath)new Path(SOURCE_FILE_PATH), null);
        try {
            uri = FileLocator.toFileURL((URL)location).toURI();
            fSourceFile = new File(uri);
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            Assert.fail();
        }
        Assume.assumeTrue((boolean)fSourceFile.exists());
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout(), "System.out"));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("Welcome", fBot);
        SWTBotUtils.switchToTracingPerspective();
        SWTBotUtils.waitForJobs();
    }

    @AfterClass
    public static void tearDown() {
        fLogger.removeAllAppenders();
        IEclipsePreferences defaultPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.tracecompass.tmf.core");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.datime", "HH:mm:ss");
        defaultPreferences.put("org.eclipse.linuxtools.tmf.core.prefs.time.format.subsec", "SSS SSS SSS");
        TmfTimestampFormat.updateDefaultFormats();
    }

    @Test
    public void test() {
        SWTBotUtils.createProject(TRACE_PROJECT_NAME);
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, fSourceFile.getAbsolutePath(), null);
        SWTBotUtils.openTrace(TRACE_PROJECT_NAME, fTestFile.getAbsolutePath(), CALLSITE_TRACE_TYPE);
        SWTBotEditor editorBot = SWTBotUtils.activateEditor(fBot, fTestFile.getName());
        SWTBotTable tableBot = editorBot.bot().table();
        SWTBotUtils.maximizeTable(tableBot);
        SWTBotTableItem tableItem = tableBot.getTableItem(1);
        SWTBotMenu menuBot = tableItem.contextMenu("Open Source Code");
        menuBot.click();
        Matcher matcher = WidgetMatcherFactory.withPartName((String)fSourceFile.getName());
        SWTBotEditor sourceEditorBot = fBot.editor(matcher);
        Assert.assertTrue((boolean)sourceEditorBot.isActive());
        SWTBotUtils.maximizeTable(tableBot);
        fBot.closeAllEditors();
        SWTBotUtils.deleteProject(TRACE_PROJECT_NAME, fBot);
    }
}

