/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCombo;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTableItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class FilterViewerTest {
    private static final String COMPARE = "COMPARE";
    private static final String CONTAINS = "CONTAINS";
    private static final String XMLSTUB_ID = "org.eclipse.linuxtools.tmf.core.tests.xmlstub";
    private static final String TRACETYPE = "Test trace : XML Trace Stub";
    private static final String AND = "AND";
    private static final String WITH_TRACETYPE = "WITH TRACETYPE Test trace : XML Trace Stub";
    private static final String FILTER_TEST = "FILTER ";
    private static final String TIMESTAMP = "Timestamp";
    private static final String CONTENTS = "Contents";
    private static final String TRACE_START = "<trace>";
    private static final String EVENT_BEGIN = "<event timestamp=\"";
    private static final String EVENT_MIDDLE = " \" name=\"event\"><field name=\"field\" value=\"";
    private static final String EVENT_END = "\" type=\"int\" /></event>";
    private static final String TRACE_END = "</trace>";
    private static final String PROJECT_NAME = "TestForFiltering";
    private static final Logger fLogger = Logger.getRootLogger();
    private static final String OR = "OR";
    private static SWTWorkbenchBot fBot;
    private static File fFileLocation;

    private static String makeEvent(int ts, int val) {
        return EVENT_BEGIN + Integer.toString(ts) + EVENT_MIDDLE + Integer.toString(val) + EVENT_END + "\n";
    }

    @BeforeClass
    public static void init() throws IOException {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBot Thread");
        SWTBotPreferences.TIMEOUT = 20000L;
        fLogger.removeAllAppenders();
        fLogger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView("welcome", fBot);
        SWTBotUtils.switchToTracingPerspective();
        SWTBotUtils.waitForJobs();
        fFileLocation = File.createTempFile("sample", ".xml");
        Throwable throwable = null;
        Object var1_2 = null;
        try (BufferedRandomAccessFile braf = new BufferedRandomAccessFile(fFileLocation, "rw");){
            braf.writeBytes(TRACE_START);
            int i = 0;
            while (i < 100) {
                braf.writeBytes(FilterViewerTest.makeEvent(i * 100, i % 4));
                ++i;
            }
            braf.writeBytes(TRACE_END);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Before
    public void beforeTest() {
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.createProject(PROJECT_NAME);
        SWTBotTreeItem treeItem = SWTBotUtils.selectTracesFolder(bot, PROJECT_NAME);
        Assert.assertNotNull((Object)treeItem);
        SWTBotUtils.openTrace(PROJECT_NAME, fFileLocation.getAbsolutePath(), XMLSTUB_ID);
        SWTBotUtils.openView("org.eclipse.linuxtools.tmf.ui.views.filter");
    }

    @AfterClass
    public static void cleanUp() {
        fFileLocation.delete();
        SWTBotUtils.deleteProject(PROJECT_NAME, fBot);
        fLogger.removeAllAppenders();
        SWTBotUtils.closeViewById("org.eclipse.linuxtools.tmf.ui.views.filter", fBot);
    }

    @After
    public void tearDown() {
        fBot.closeAllEditors();
    }

    @Test
    public void testTimestampFilter() {
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.filter");
        viewBot.setFocus();
        SWTBot filterBot = viewBot.bot();
        SWTBotTree treeBot = filterBot.tree();
        viewBot.toolbarButton("Add new filter").click();
        treeBot.getTreeItem("FILTER <name>").select();
        SWTBotText textBot = filterBot.text();
        textBot.setFocus();
        String filterName = "timestamp";
        textBot.setText(filterName);
        SWTBotTreeItem filterNodeBot = treeBot.getTreeItem(FILTER_TEST + filterName);
        filterNodeBot.click();
        filterNodeBot.contextMenu("TRACETYPE").click();
        filterNodeBot.expand();
        SWTBotCombo comboBot = filterBot.comboBox();
        comboBot.setSelection(TRACETYPE);
        filterNodeBot.getNode(WITH_TRACETYPE).expand();
        filterNodeBot.getNode(WITH_TRACETYPE).contextMenu(AND).click();
        filterNodeBot.getNode(WITH_TRACETYPE).getNode(AND).contextMenu(CONTAINS).click();
        filterNodeBot.getNode(WITH_TRACETYPE).getNode(AND).expand();
        comboBot = filterBot.comboBox(1);
        comboBot.setSelection(TIMESTAMP);
        textBot = filterBot.text();
        textBot.setFocus();
        textBot.setText("100");
        filterNodeBot.getNode(WITH_TRACETYPE).getNode(AND).getNode("Timestamp CONTAINS \"100\"").select();
        filterNodeBot.getNode(WITH_TRACETYPE).getNode(AND).select();
        viewBot.toolbarButton("Save filters").click();
        String ret = FilterViewerTest.applyFilter(fBot, filterName);
        Assert.assertEquals((Object)"10/100", (Object)ret);
    }

    @Test
    public void testTimestampEqualsOr() {
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.filter");
        viewBot.setFocus();
        SWTBot filterBot = viewBot.bot();
        SWTBotTree treeBot = filterBot.tree();
        viewBot.toolbarButton("Add new filter").click();
        treeBot.getTreeItem("FILTER <name>").select();
        SWTBotText textBot = filterBot.text();
        textBot.setFocus();
        String filterName = "matchAndEquals";
        textBot.setText(filterName);
        SWTBotTreeItem filterNodeBot = treeBot.getTreeItem(FILTER_TEST + filterName);
        filterNodeBot.click();
        filterNodeBot.contextMenu("TRACETYPE").click();
        filterNodeBot.expand();
        SWTBotCombo comboBot = filterBot.comboBox();
        comboBot.setSelection(TRACETYPE);
        filterNodeBot.getNode(WITH_TRACETYPE).expand();
        filterNodeBot.getNode(WITH_TRACETYPE).contextMenu(OR).click();
        SWTBotTreeItem orNode = filterNodeBot.getNode(WITH_TRACETYPE).getNode(OR);
        orNode.contextMenu("EQUALS").click();
        orNode.expand();
        orNode.getNode(0).select();
        comboBot = filterBot.comboBox(1);
        comboBot.setSelection(TIMESTAMP);
        textBot = filterBot.text();
        textBot.setFocus();
        textBot.setText("19:00:00.000 000 300");
        orNode.contextMenu("MATCHES").click();
        orNode.expand();
        orNode.getNode(1).select();
        comboBot = filterBot.comboBox(1);
        comboBot.setSelection(CONTENTS);
        textBot = filterBot.text(0);
        textBot.setFocus();
        textBot.setText("field");
        textBot = filterBot.text(1);
        textBot.setFocus();
        textBot.setText("1");
        viewBot.toolbarButton("Save filters").click();
        String ret = FilterViewerTest.applyFilter(fBot, filterName);
        Assert.assertEquals((Object)"26/100", (Object)ret);
    }

    @Test
    public void testField01() {
        SWTBotView viewBot = fBot.viewById("org.eclipse.linuxtools.tmf.ui.views.filter");
        viewBot.setFocus();
        SWTBot filterBot = viewBot.bot();
        SWTBotTree treeBot = filterBot.tree();
        viewBot.toolbarButton("Add new filter").click();
        treeBot.getTreeItem("FILTER <name>").select();
        SWTBotText textBot = filterBot.text();
        textBot.setFocus();
        String filterName = "field";
        textBot.setText(filterName);
        SWTBotTreeItem filterNodeBot = treeBot.getTreeItem(FILTER_TEST + filterName);
        filterNodeBot.click();
        filterNodeBot.contextMenu("TRACETYPE").click();
        filterNodeBot.expand();
        SWTBotCombo comboBot = filterBot.comboBox();
        comboBot.setSelection(TRACETYPE);
        filterNodeBot.getNode(WITH_TRACETYPE).expand();
        filterNodeBot.getNode(WITH_TRACETYPE).contextMenu(COMPARE).click();
        SWTBotTreeItem contentNode = filterNodeBot.getNode(WITH_TRACETYPE).getNode("<select aspect> = <value>");
        contentNode.expand();
        comboBot = filterBot.comboBox(1);
        comboBot.setSelection(CONTENTS);
        textBot = filterBot.text(0);
        textBot.setFocus();
        textBot.setText(filterName);
        textBot = filterBot.text(1);
        textBot.setFocus();
        textBot.setText("1.5");
        filterBot.radio(">").click();
        viewBot.toolbarButton("Save filters").click();
        String ret = FilterViewerTest.applyFilter(fBot, filterName);
        Assert.assertEquals((Object)"50/100", (Object)ret);
    }

    private static String applyFilter(SWTWorkbenchBot bot, String filterName) {
        SWTBotUtils.waitForJobs();
        SWTBotTable eventsTable = SWTBotUtils.activeEventsEditor(bot).bot().table();
        SWTBotTableItem tableItem = eventsTable.getTableItem(2);
        tableItem.contextMenu(filterName).click();
        fBot.waitUntil(ConditionHelpers.isTableCellFilled(eventsTable, "/100", 1, 1));
        return eventsTable.cell(1, 1);
    }
}

