/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.viewers.events.TestRefreshTextTrace;
import org.eclipse.tracecompass.tmf.ui.tests.TmfUITestPlugin;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class TestRefreshCustomTextTrace
extends TestRefreshTextTrace {
    private static final String TRACE_LOCATION = String.valueOf(TmfTraceManager.getTemporaryDirPath()) + File.separator + "test.txt";
    private static final String DEFINITION_PATH = "tracesets" + File.separator + "txt" + File.separator + "testTxtDefinition.xml";
    private static final String TRACE_TYPE_CUSTOM_TEXT = "custom.txt.trace:Custom Text:testtxt";
    private static final String TIMESTAMP_FORMAT = "dd/MM/yyyy HH:mm:ss:SSS";
    private static final long SECOND_TO_MILLISECOND = 1000L;
    private static final long SECOND_TO_NANOSECOND = 1000000000L;
    private long fNbWrittenEvents = 0L;

    @Override
    protected String createTrace(long nbEvents) throws Exception {
        TestRefreshCustomTextTrace.createDefinition();
        this.writeToTrace(nbEvents, false);
        return TRACE_LOCATION;
    }

    private static void createDefinition() throws URISyntaxException, IOException {
        CustomTxtTraceDefinition[] definitions;
        File file = TestRefreshCustomTextTrace.getBundleFile(TmfUITestPlugin.getDefault().getBundle(), (IPath)new Path(DEFINITION_PATH));
        CustomTxtTraceDefinition[] customTxtTraceDefinitionArray = definitions = CustomTxtTraceDefinition.loadAll((String)file.toString());
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            CustomTxtTraceDefinition text = customTxtTraceDefinitionArray[n2];
            text.save();
            ++n2;
        }
    }

    private static File getBundleFile(Bundle bundle, IPath relativePath) throws URISyntaxException, IOException {
        return new File(FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)relativePath, null)).toURI());
    }

    @Override
    protected void appendToTrace(long nbEvents) throws IOException {
        this.writeToTrace(nbEvents, true);
    }

    private void writeToTrace(long nbEvents, boolean append) throws IOException {
        File file = new File(TRACE_LOCATION);
        Throwable throwable = null;
        Object var6_6 = null;
        try (FileWriter writer = new FileWriter(file, append);){
            int i = 0;
            while ((long)i < nbEvents) {
                SimpleDateFormat f = new SimpleDateFormat(TIMESTAMP_FORMAT);
                String eventStr = String.valueOf(f.format(new Date(this.fNbWrittenEvents * 1000L))) + " hello world\n";
                writer.write(eventStr);
                ++this.fNbWrittenEvents;
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected long getExpectedEndTimeStamp() {
        return (this.fNbWrittenEvents - 1L) * 1000000000L;
    }

    @Override
    protected String getTraceType() {
        return TRACE_TYPE_CUSTOM_TEXT;
    }

    @Override
    protected long getNbWrittenEvents() {
        return this.fNbWrittenEvents;
    }
}

