/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.project.model;

import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisOutputElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.tests.shared.ProjectModelTestData;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProjectModelOutputTest {
    private TmfProjectElement fixture;

    @Before
    public void setUp() {
        try {
            this.fixture = ProjectModelTestData.getFilledProject();
        }
        catch (CoreException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void cleanUp() {
        ProjectModelTestData.deleteProject(this.fixture);
    }

    private TmfTraceElement getTraceElement() {
        TmfTraceElement trace = null;
        for (ITmfProjectModelElement element : this.fixture.getTracesFolder().getChildren()) {
            TmfTraceElement traceElement;
            if (!(element instanceof TmfTraceElement) || !(traceElement = (TmfTraceElement)element).getName().equals(ProjectModelTestData.getTraceName())) continue;
            trace = traceElement;
        }
        Assert.assertNotNull(trace);
        return trace;
    }

    private TmfAnalysisElement getTestAnalysisUi() {
        TmfTraceElement trace = this.getTraceElement();
        List analysisList = trace.getAvailableAnalysis();
        Assert.assertFalse((boolean)analysisList.isEmpty());
        TmfAnalysisElement analysis = null;
        for (TmfAnalysisElement analysisElement : analysisList) {
            if (!analysisElement.getAnalysisId().equals("org.eclipse.linuxtools.tmf.ui.tests.test")) continue;
            analysis = analysisElement;
        }
        Assert.assertNotNull(analysis);
        return analysis;
    }

    @Test
    public void testListOutputs() {
        TmfAnalysisElement analysis = this.getTestAnalysisUi();
        analysis.activateParent();
        try {
            ProjectModelTestData.delayUntilTraceOpened(analysis.getParent());
        }
        catch (TimeoutException e) {
            Assert.fail((String)"The analysis parent did not open in a reasonable time");
        }
        List outputList = analysis.getAvailableOutputs();
        Assert.assertFalse((boolean)outputList.isEmpty());
        boolean found = false;
        for (ITmfProjectModelElement element : outputList) {
            TmfAnalysisOutputElement outputElement;
            if (!(element instanceof TmfAnalysisOutputElement) || !(outputElement = (TmfAnalysisOutputElement)element).getName().equals("Test Analysis View")) continue;
            found = true;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testOpenView() {
        TmfAnalysisElement analysis = this.getTestAnalysisUi();
        analysis.activateParent();
        try {
            ProjectModelTestData.delayUntilTraceOpened(analysis.getParent());
        }
        catch (TimeoutException e) {
            Assert.fail((String)"The analysis parent did not open in a reasonable time");
        }
        List outputList = analysis.getAvailableOutputs();
        Assert.assertFalse((boolean)outputList.isEmpty());
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
        IViewPart view = activePage.findView("org.eclipse.linuxtools.tmf.ui.tests.testAnalysisView");
        if (view != null) {
            activePage.hideView(view);
        }
        TmfAnalysisOutputElement outputElement = null;
        for (ITmfProjectModelElement element : outputList) {
            TmfAnalysisOutputElement el;
            if (!(element instanceof TmfAnalysisOutputElement) || !(el = (TmfAnalysisOutputElement)element).getName().equals("Test Analysis View")) continue;
            outputElement = el;
        }
        Assert.assertNotNull(outputElement);
        outputElement.outputAnalysis();
        ProjectModelTestData.delayThread(1000L);
        view = activePage.findView("org.eclipse.linuxtools.tmf.ui.tests.testAnalysisView");
        Assert.assertNotNull((Object)view);
    }
}

