/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader;

import org.eclipse.tracecompass.tmf.core.component.TmfComponent;
import org.eclipse.tracecompass.tmf.core.signal.TmfEndSynchSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartSynchSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader.IUml2SdSignalValidator;

public class Uml2SDSignalValidator
extends TmfComponent
implements IUml2SdSignalValidator {
    private int fSignalDepth = 0;
    private boolean fIsSignalReceived = false;
    private boolean fIsSignalError = false;
    private boolean fIsSourceError = false;
    private boolean fIsCurrentTimeError = false;
    private boolean fIsRangeError = false;
    private Object fSource = null;
    private TmfTimestamp fCurrentTimestamp = null;
    private TmfTimeRange fCurrentTimeRange = null;

    @TmfSignalHandler
    public void synchToTime(TmfSelectionRangeUpdatedSignal signal) {
        this.setSignalReceived(true);
        this.setSourceError(this.getSource() != signal.getSource());
        this.setCurrentTimeError(!this.getCurrentTime().equals((Object)signal.getBeginTime()));
    }

    @TmfSignalHandler
    public void synchToTimeRange(TmfWindowRangeUpdatedSignal signal) {
        this.setSignalReceived(true);
        if (this.getSource() != null) {
            this.setSourceError(this.getSource() != signal.getSource());
        }
        if (this.getCurrentRange() != null) {
            this.setRangeError(!this.getCurrentRange().equals((Object)signal.getCurrentRange()));
        }
    }

    @TmfSignalHandler
    public void startSynch(TmfStartSynchSignal signal) {
        ++this.fSignalDepth;
        this.setSignalError(this.fSignalDepth > 1);
    }

    @TmfSignalHandler
    public void endSynch(TmfEndSynchSignal signal) {
        this.fSignalDepth = this.fSignalDepth > 0 ? this.fSignalDepth - 1 : 0;
    }

    @Override
    public boolean isSignalReceived() {
        return this.fIsSignalReceived;
    }

    @Override
    public void setSignalReceived(boolean received) {
        this.fIsSignalReceived = received;
    }

    @Override
    public boolean isSourceError() {
        return this.fIsSourceError;
    }

    @Override
    public void setSourceError(boolean fIsSourceError) {
        this.fIsSourceError = fIsSourceError;
    }

    @Override
    public boolean isCurrentTimeError() {
        return this.fIsCurrentTimeError;
    }

    @Override
    public void setCurrentTimeError(boolean fIsCurrentTimeError) {
        this.fIsCurrentTimeError = fIsCurrentTimeError;
    }

    @Override
    public boolean isRangeError() {
        return this.fIsRangeError;
    }

    @Override
    public void setRangeError(boolean fIsRangeError) {
        this.fIsRangeError = fIsRangeError;
    }

    @Override
    public boolean isSignalError() {
        return this.fIsSignalError;
    }

    @Override
    public void setSignalError(boolean fIsSignalError) {
        this.fIsSignalError = fIsSignalError;
    }

    @Override
    public Object getSource() {
        return this.fSource;
    }

    @Override
    public void setSource(Object source) {
        this.fSource = source;
    }

    @Override
    public TmfTimestamp getCurrentTime() {
        return this.fCurrentTimestamp;
    }

    @Override
    public void setCurrentTime(TmfTimestamp currentTime) {
        this.fCurrentTimestamp = currentTime == null ? null : new TmfTimestamp((ITmfTimestamp)currentTime);
    }

    @Override
    public TmfTimeRange getCurrentRange() {
        return this.fCurrentTimeRange;
    }

    @Override
    public void setCurrentRange(TmfTimeRange currentRange) {
        this.fCurrentTimeRange = currentRange == null ? null : currentRange;
    }
}

