/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.test.stub.views;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphSelectionEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.test.stub.adaption.TsfImplProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.test.stub.model.EventImpl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.test.stub.model.TraceImpl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.test.stub.model.TraceModelImplFactory;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class TsfTraceAnalysisView
extends ViewPart
implements ITimeGraphSelectionListener,
ITimeGraphTimeListener,
ITimeGraphRangeListener {
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Action action1;
    private Action action2;
    private Action resetScale;
    private Action nextEvent;
    private Action prevEvent;
    private Action nextTrace;
    private Action prevTrace;
    private Action showLegent;
    private Action zoomIn;
    private Action zoomOut;
    private Action events300K;
    private Action doubleClickAction;
    private TimeGraphViewer tsfviewer;
    private TimeGraphViewer tsfviewer2;
    private static SimpleDateFormat stimeformat = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
    private TraceModelImplFactory fact;

    public void createPartControl(Composite parent) {
        SashForm sashForm = new SashForm(parent, 0);
        SashForm sashForm2 = new SashForm((Composite)sashForm, 0);
        this.tsfviewer = new TimeGraphViewer((Composite)sashForm2, 0);
        this.tsfviewer.setTimeGraphProvider((ITimeGraphPresentationProvider)new TsfImplProvider());
        this.tsfviewer2 = new TimeGraphViewer((Composite)sashForm2, 0);
        this.tsfviewer2.setTimeGraphProvider((ITimeGraphPresentationProvider)new TsfImplProvider());
        this.viewer = new TreeViewer((Composite)sashForm, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        sashForm.setWeights(new int[]{5, 1});
        sashForm2.setWeights(new int[]{1, 1});
        this.fact = new TraceModelImplFactory();
        TraceImpl[] traceArr = this.fact.createTraces();
        this.tsfviewer.setInput((Object)traceArr);
        this.tsfviewer.addSelectionListener((ITimeGraphSelectionListener)this);
        this.tsfviewer.addRangeListener((ITimeGraphRangeListener)this);
        this.tsfviewer.setTimeFormat(Utils.TimeFormat.CALENDAR);
        this.tsfviewer2.setInput((Object)traceArr);
        this.tsfviewer2.addSelectionListener((ITimeGraphSelectionListener)this);
        this.tsfviewer2.addRangeListener((ITimeGraphRangeListener)this);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TsfTraceAnalysisView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.action2);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resetScale);
        manager.add((IAction)this.nextEvent);
        manager.add((IAction)this.prevEvent);
        manager.add((IAction)this.nextTrace);
        manager.add((IAction)this.prevTrace);
        manager.add((IAction)this.showLegent);
        manager.add((IAction)this.zoomIn);
        manager.add((IAction)this.zoomOut);
        manager.add((IAction)this.events300K);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private TimeGraphViewer getActiveTsfCtrl() {
        TimeGraphViewer inFocusViewer = null;
        if (this.tsfviewer.isInFocus()) {
            inFocusViewer = this.tsfviewer;
        } else if (this.tsfviewer2.isInFocus()) {
            inFocusViewer = this.tsfviewer2;
        }
        return inFocusViewer;
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                TsfTraceAnalysisView.this.showMessage("Action 1 executed");
            }
        };
        this.action1.setText("Action 1");
        this.action1.setToolTipText("Action 1 tooltip");
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.action2 = new Action(){

            public void run() {
                TsfTraceAnalysisView.this.showMessage("Action 2 executed");
            }
        };
        this.action2.setText("Action 2");
        this.action2.setToolTipText("Action 2 tooltip");
        this.action2.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.resetScale = new Action(){

            public void run() {
                TimeGraphViewer inFocusViewer = TsfTraceAnalysisView.this.getActiveTsfCtrl();
                if (inFocusViewer != null) {
                    inFocusViewer.resetStartFinishTime();
                }
            }
        };
        this.resetScale.setText("Reset");
        this.resetScale.setToolTipText("Reset the Time Scale to Default");
        this.nextEvent = new Action(){

            public void run() {
                TimeGraphViewer inFocusViewer = TsfTraceAnalysisView.this.getActiveTsfCtrl();
                if (inFocusViewer != null) {
                    inFocusViewer.selectNextEvent(false);
                }
            }
        };
        this.nextEvent.setText("NextEv");
        this.nextEvent.setToolTipText("Next Event");
        this.prevEvent = new Action(){

            public void run() {
                TimeGraphViewer inFocusViewer = TsfTraceAnalysisView.this.getActiveTsfCtrl();
                if (inFocusViewer != null) {
                    inFocusViewer.selectPrevEvent(false);
                }
            }
        };
        this.prevEvent.setText("PrevEv");
        this.prevEvent.setToolTipText("Previous Event");
        this.nextTrace = new Action(){

            public void run() {
                TimeGraphViewer inFocusViewer = TsfTraceAnalysisView.this.getActiveTsfCtrl();
                if (inFocusViewer != null) {
                    inFocusViewer.selectNextItem();
                }
            }
        };
        this.nextTrace.setText("NextTrace");
        this.nextTrace.setToolTipText("Select Next Event");
        this.prevTrace = new Action(){

            public void run() {
                TimeGraphViewer inFocusViewer = TsfTraceAnalysisView.this.getActiveTsfCtrl();
                if (inFocusViewer != null) {
                    inFocusViewer.selectPrevItem();
                }
            }
        };
        this.prevTrace.setText("PrevTrace");
        this.prevTrace.setToolTipText("Select Previous Trace");
        this.showLegent = new Action(){

            public void run() {
                TimeGraphViewer inFocusViewer = TsfTraceAnalysisView.this.getActiveTsfCtrl();
                if (inFocusViewer != null) {
                    inFocusViewer.showLegend();
                }
            }
        };
        this.showLegent.setText("Legend");
        this.showLegent.setToolTipText("Show Legend");
        this.zoomIn = new Action(){

            public void run() {
                TimeGraphViewer inFocusViewer = TsfTraceAnalysisView.this.getActiveTsfCtrl();
                if (inFocusViewer != null) {
                    inFocusViewer.zoomIn();
                }
            }
        };
        this.zoomIn.setText("Zoom In");
        this.zoomIn.setToolTipText("Zoom In");
        this.zoomOut = new Action(){

            public void run() {
                TimeGraphViewer inFocusViewer = TsfTraceAnalysisView.this.getActiveTsfCtrl();
                if (inFocusViewer != null) {
                    inFocusViewer.zoomOut();
                }
            }
        };
        this.zoomOut.setText("Zoom Out");
        this.zoomOut.setToolTipText("Zoom Out");
        this.events300K = new Action(){

            public void run() {
                TimeGraphViewer inFocusViewer = TsfTraceAnalysisView.this.getActiveTsfCtrl();
                if (inFocusViewer != null) {
                    TraceImpl[] traceArr = TsfTraceAnalysisView.this.fact.createLargeTraces(60);
                    inFocusViewer.setInput((Object)traceArr);
                }
            }
        };
        this.events300K.setText("300K Events");
        this.events300K.setToolTipText("Add 300K Events");
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = TsfTraceAnalysisView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                TsfTraceAnalysisView.this.showMessage("Double-click detected on " + obj.toString());
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TsfTraceAnalysisView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"TsfTrace Analysis View", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void selectionChanged(TimeGraphSelectionEvent event) {
        Object source = event.getSource();
        if (source == null || !(source instanceof TimeGraphViewer)) {
            return;
        }
        TimeGraphViewer rViewer = (TimeGraphViewer)event.getSource();
        TimeGraphViewer synchViewer = null;
        synchViewer = this.tsfviewer == rViewer ? this.tsfviewer2 : this.tsfviewer;
        ITimeGraphEntry selection = event.getSelection();
        if (selection instanceof EventImpl) {
            EventImpl selEvent = (EventImpl)selection;
            System.out.println("TsfTraceAnalysisView.selectionChanged() Selected Event: \nType: " + selEvent.getType().toString() + "\nTime: " + selEvent.getTime() + "\nTrace Name: " + selEvent.getEntry().getName());
            synchViewer.setSelectedEvent((ITimeEvent)selEvent, source);
        } else if (selection instanceof TraceImpl) {
            TraceImpl selTrace = (TraceImpl)selection;
            System.out.println("TsfTraceAnalysisView.selectionChanged() Selected Trace: \nName: " + selTrace.getName().toString() + "\nClass Name: " + selTrace.getClassName());
            synchViewer.setSelection((ITimeGraphEntry)selTrace);
        } else {
            System.out.println("TsfTmIncubatorListener.tsfTmProcessEvent() Unexpected event source received: " + selection.getClass().getName());
        }
    }

    public void timeSelected(TimeGraphTimeEvent event) {
        TimeGraphViewer rViewer = (TimeGraphViewer)event.getSource();
        TimeGraphViewer synchViewer = null;
        synchViewer = this.tsfviewer == rViewer ? this.tsfviewer2 : this.tsfviewer;
        long selTimens = event.getBeginTime();
        long tms = (long)((double)selTimens * 1.0E-6);
        Date date = new Date(tms);
        String fDate = stimeformat.format(date);
        String ns = this.formatNs(selTimens);
        System.out.println("TsfTraceAnalysisView.timeSelected() Selected Event: \nTime: " + event.getBeginTime() + "\nSelected Time: " + selTimens + " " + fDate + " " + ns);
        synchViewer.setSelectedTime(event.getBeginTime(), true);
    }

    public void timeRangeUpdated(TimeGraphRangeUpdateEvent event) {
        if (event == null) {
            return;
        }
        Object source = event.getSource();
        if (source == null || !(source instanceof TimeGraphViewer)) {
            return;
        }
        TimeGraphRangeUpdateEvent rEvent = event;
        TimeGraphViewer rViewer = (TimeGraphViewer)event.getSource();
        TimeGraphViewer synchViewer = null;
        synchViewer = this.tsfviewer == rViewer ? this.tsfviewer2 : this.tsfviewer;
        synchViewer.setSelectVisTimeWindow(rEvent.getStartTime(), rEvent.getEndTime(), source);
    }

    public String formatNs(long v) {
        boolean neg;
        StringBuffer str = new StringBuffer();
        long val = v;
        boolean bl = neg = val < 0L;
        if (neg) {
            val = -val;
            str.append('-');
        }
        String strVal = String.valueOf(val);
        if (val < 1000000000L) {
            return strVal;
        }
        return strVal.substring(strVal.length() - 9);
    }

    static class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class TreeObject
    extends PlatformObject {
        private final String name;
        private TreeParent parent;

        public TreeObject(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setParent(TreeParent parent) {
            this.parent = parent;
        }

        public TreeParent getParent() {
            return this.parent;
        }

        public String toString() {
            return this.getName();
        }
    }

    class TreeParent
    extends TreeObject {
        private final ArrayList<TreeObject> children;

        public TreeParent(String name) {
            super(name);
            this.children = new ArrayList();
        }

        public void addChild(TreeObject child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeObject child) {
            this.children.remove((Object)child);
            child.setParent(null);
        }

        public TreeObject[] getChildren() {
            return this.children.toArray(new TreeObject[this.children.size()]);
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        private TreeParent invisibleRoot;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent.equals(TsfTraceAnalysisView.this.getViewSite())) {
                if (this.invisibleRoot == null) {
                    this.initialize();
                }
                return this.getChildren((Object)this.invisibleRoot);
            }
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeObject) {
                return ((TreeObject)((Object)child)).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)((Object)parent)).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)((Object)parent)).hasChildren();
            }
            return false;
        }

        private void initialize() {
            TreeObject to1 = new TreeObject("Leaf 1");
            TreeObject to2 = new TreeObject("Leaf 2");
            TreeObject to3 = new TreeObject("Leaf 3");
            TreeParent p1 = new TreeParent("Parent 1");
            p1.addChild(to1);
            p1.addChild(to2);
            p1.addChild(to3);
            TreeObject to4 = new TreeObject("Leaf 4");
            TreeParent p2 = new TreeParent("Parent 2");
            p2.addChild(to4);
            TreeParent root = new TreeParent("Root");
            root.addChild(p1);
            root.addChild(p2);
            this.invisibleRoot = new TreeParent("");
            this.invisibleRoot.addChild(root);
        }
    }

    static class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            if (obj instanceof TreeParent) {
                imageKey = "IMG_OBJ_FOLDER";
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }
}

