/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.statistics.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.Messages;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfBaseColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsFormatter;
import org.eclipse.tracecompass.tmf.ui.viewers.statistics.model.TmfStatisticsTreeNode;
import org.eclipse.ui.PlatformUI;

@Deprecated
public class TmfBaseColumnDataProvider {
    private static final String LEVEL_COLUMN = Messages.TmfStatisticsView_LevelColumn;
    private static final String EVENTS_COUNT_COLUMN = Messages.TmfStatisticsView_NbEventsColumn;
    private static final String PARTIAL_EVENTS_COUNT_COLUMN = Messages.TmfStatisticsView_NbEventsTimeRangeColumn;
    private static final String LEVEL_COLUMN_TIP = Messages.TmfStatisticsView_LevelColumnTip;
    private static final String EVENTS_COUNT_COLUMN_TIP = Messages.TmfStatisticsView_NbEventsTip;
    private static final String PARTIAL_COUNT_COLUMN_TIP = Messages.TmfStatisticsView_NbEventsTimeRangeTip;
    public static final Set<String> HIDDEN_FOLDER_LEVELS = ImmutableSet.of((Object)"Event Types");
    private static final String EMPTY_STRING = "";
    private final List<TmfBaseColumnData> fColumnData;

    public TmfBaseColumnDataProvider() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object)new TmfBaseColumnData(LEVEL_COLUMN, 200, 16384, LEVEL_COLUMN_TIP, new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((TmfStatisticsTreeNode)element).getName();
            }

            public Image getImage(Object element) {
                TmfStatisticsTreeNode node = (TmfStatisticsTreeNode)element;
                if (HIDDEN_FOLDER_LEVELS.contains(node.getName())) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
            }
        }, new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TmfStatisticsTreeNode n1 = (TmfStatisticsTreeNode)e1;
                TmfStatisticsTreeNode n2 = (TmfStatisticsTreeNode)e2;
                return n1.getName().compareTo(n2.getName());
            }
        }, null));
        builder.add((Object)new TmfBaseColumnData(EVENTS_COUNT_COLUMN, 140, 131072, EVENTS_COUNT_COLUMN_TIP, new ColumnLabelProvider(){

            public String getText(Object element) {
                TmfStatisticsTreeNode node = (TmfStatisticsTreeNode)element;
                if (!HIDDEN_FOLDER_LEVELS.contains(node.getName())) {
                    return TmfStatisticsFormatter.toColumnData(node, StatsColumn.TOTAL);
                }
                return TmfBaseColumnDataProvider.EMPTY_STRING;
            }
        }, new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TmfStatisticsTreeNode n1 = (TmfStatisticsTreeNode)e1;
                TmfStatisticsTreeNode n2 = (TmfStatisticsTreeNode)e2;
                return (int)(n1.getValues().getTotal() - n2.getValues().getTotal());
            }
        }, new TmfBaseColumnData.ITmfColumnPercentageProvider(){

            @Override
            public double getPercentage(TmfStatisticsTreeNode node) {
                TmfStatisticsTreeNode top = node.getTop();
                return top == null || top.getValues().getTotal() == 0L ? 0.0 : (double)node.getValues().getTotal() / (double)top.getValues().getTotal();
            }
        }));
        builder.add((Object)new TmfBaseColumnData(PARTIAL_EVENTS_COUNT_COLUMN, 140, 131072, PARTIAL_COUNT_COLUMN_TIP, new ColumnLabelProvider(){

            public String getText(Object element) {
                TmfStatisticsTreeNode node = (TmfStatisticsTreeNode)element;
                if (!HIDDEN_FOLDER_LEVELS.contains(node.getName())) {
                    return TmfStatisticsFormatter.toColumnData(node, StatsColumn.PARTIAL);
                }
                return TmfBaseColumnDataProvider.EMPTY_STRING;
            }
        }, new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TmfStatisticsTreeNode n1 = (TmfStatisticsTreeNode)e1;
                TmfStatisticsTreeNode n2 = (TmfStatisticsTreeNode)e2;
                return (int)(n1.getValues().getPartial() - n2.getValues().getPartial());
            }
        }, new TmfBaseColumnData.ITmfColumnPercentageProvider(){

            @Override
            public double getPercentage(TmfStatisticsTreeNode node) {
                TmfStatisticsTreeNode top = node.getTop();
                return top == null || top.getValues().getPartial() == 0L ? 0.0 : (double)node.getValues().getPartial() / (double)top.getValues().getPartial();
            }
        }));
        builder.add((Object)new TmfBaseColumnData(EMPTY_STRING, 1, 131072, EMPTY_STRING, new ColumnLabelProvider(){

            public String getText(Object element) {
                return TmfBaseColumnDataProvider.EMPTY_STRING;
            }
        }, new ViewerComparator(), new TmfBaseColumnData.ITmfColumnPercentageProvider(){

            @Override
            public double getPercentage(TmfStatisticsTreeNode node) {
                return 0.0;
            }
        }));
        this.fColumnData = builder.build();
    }

    public List<TmfBaseColumnData> getColumnData() {
        return this.fColumnData;
    }

    public static enum StatsColumn {
        EVENT(0),
        TOTAL(1),
        PARTIAL(2),
        DUMMY(3);

        private final int colIndex;

        private StatsColumn(int index) {
            this.colIndex = index;
        }

        public int getIndex() {
            return this.colIndex;
        }

        public static StatsColumn getColumn(int index) {
            switch (index) {
                case 0: {
                    return EVENT;
                }
                case 1: {
                    return TOTAL;
                }
                case 2: {
                    return PARTIAL;
                }
                case 3: {
                    return DUMMY;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

