/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;

public class EventIterator
implements Iterator<ITimeEvent> {
    private final long fStartTime;
    private final long fEndTime;
    private List<ITimeEvent> fEventList;
    private List<ITimeEvent> fZoomedEventList;
    private long fZoomedStartTime;
    private long fZoomedEndTime;
    private int fIndex = 0;
    private int fZoomedIndex = 0;
    private ITimeEvent fNext = null;
    private ITimeEvent fSplitNext = null;
    private ITimeEvent fZoomedNext = null;

    public EventIterator(List<ITimeEvent> eventList, List<ITimeEvent> zoomedEventList) {
        this(eventList, zoomedEventList, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public EventIterator(List<ITimeEvent> eventList, List<ITimeEvent> zoomedEventList, long startTime, long endTime) {
        this.fEventList = eventList;
        this.fZoomedEventList = zoomedEventList;
        if (zoomedEventList != null && zoomedEventList.size() > 0) {
            this.fZoomedStartTime = zoomedEventList.get(0).getTime();
            ITimeEvent lastEvent = zoomedEventList.get(zoomedEventList.size() - 1);
            this.fZoomedEndTime = lastEvent.getTime() + lastEvent.getDuration();
        } else {
            this.fZoomedStartTime = Long.MAX_VALUE;
            this.fZoomedEndTime = Long.MIN_VALUE;
        }
        this.fStartTime = startTime;
        this.fEndTime = endTime;
    }

    @Override
    public boolean hasNext() {
        ITimeEvent event;
        if (this.fNext == null && this.fEventList != null) {
            while (this.fIndex < this.fEventList.size()) {
                if ((event = this.fEventList.get(this.fIndex++)).getTime() + event.getDuration() < this.fStartTime || event.getTime() > this.fEndTime || event.getTime() >= this.fZoomedStartTime && event.getTime() + event.getDuration() <= this.fZoomedEndTime) continue;
                this.fNext = event;
                if (event.getTime() < this.fZoomedEndTime && event.getTime() + event.getDuration() > this.fZoomedStartTime) {
                    this.fNext = null;
                    if (event.getTime() + event.getDuration() > this.fZoomedEndTime && this.fZoomedEndTime < this.fEndTime) {
                        this.fNext = event.splitAfter(this.fZoomedEndTime);
                    }
                    if (event.getTime() < this.fZoomedStartTime && this.fZoomedStartTime > this.fStartTime) {
                        this.fSplitNext = this.fNext;
                        this.fNext = event.splitBefore(this.fZoomedStartTime);
                    }
                }
                if (this.fNext != null) break;
            }
            if (this.fNext == null) {
                this.fEventList = null;
            }
        }
        if (this.fZoomedNext == null && this.fZoomedEventList != null) {
            while (this.fZoomedIndex < this.fZoomedEventList.size()) {
                if ((event = this.fZoomedEventList.get(this.fZoomedIndex++)).getTime() + event.getDuration() < this.fStartTime || event.getTime() > this.fEndTime) continue;
                this.fZoomedNext = event;
                break;
            }
            if (this.fZoomedNext == null) {
                this.fZoomedEventList = null;
            }
        }
        return this.fNext != null || this.fZoomedNext != null;
    }

    @Override
    public ITimeEvent next() {
        if (this.hasNext()) {
            if (this.fZoomedNext != null && (this.fNext == null || this.fZoomedNext.getTime() <= this.fNext.getTime())) {
                ITimeEvent event = this.fZoomedNext;
                this.fZoomedNext = null;
                return event;
            }
            ITimeEvent event = this.fNext;
            this.fNext = this.fSplitNext;
            this.fSplitNext = null;
            return event;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

