/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTypeSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalParameterPack;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SignatureBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PlatformObject;

public abstract class CPPDependentEvaluation
extends CPPEvaluation {
    private IBinding fTemplateDefinition;
    private IScope fTemplateDefinitionScope;

    CPPDependentEvaluation(IBinding templateDefinition) {
        this.fTemplateDefinition = templateDefinition;
    }

    @Override
    public IBinding getTemplateDefinition() {
        if (this.fTemplateDefinition instanceof DeferredResolutionBinding) {
            IBinding toResolve = this.fTemplateDefinition;
            this.fTemplateDefinition = null;
            this.fTemplateDefinition = ((DeferredResolutionBinding)toResolve).resolve();
        }
        return this.fTemplateDefinition;
    }

    protected IScope getTemplateDefinitionScope() {
        IBinding templateDefinition;
        if (this.fTemplateDefinitionScope == null && (templateDefinition = this.getTemplateDefinition()) != null) {
            if (templateDefinition instanceof ICPPClassType) {
                this.fTemplateDefinitionScope = ((ICPPClassType)templateDefinition).getCompositeScope();
            }
            try {
                this.fTemplateDefinitionScope = templateDefinition.getScope();
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return this.fTemplateDefinitionScope;
    }

    protected static IBinding findEnclosingTemplate(IASTNode node) {
        while (node != null) {
            if (node instanceof ICPPASTTemplateDeclaration) {
                ICPPASTTemplateDeclaration templateDecl = (ICPPASTTemplateDeclaration)node;
                IASTName templateName = CPPTemplates.getTemplateName(templateDecl);
                if (templateName == null) {
                    return null;
                }
                return new DeferredResolutionBinding(templateName);
            }
            node = node.getParent();
        }
        return null;
    }

    protected void marshalTemplateDefinition(ITypeMarshalBuffer buffer) throws CoreException {
        if (!(buffer instanceof SignatureBuilder)) {
            buffer.marshalBinding(this.getTemplateDefinition());
        }
    }

    protected static ICPPEvaluation[] instantiateCommaSeparatedSubexpressions(ICPPEvaluation[] subexpressions, ICPPTemplateParameterMap tpMap, int packOffset, ICPPTypeSpecialization within, int maxdepth, IASTNode point) {
        ICPPEvaluation[] result = subexpressions;
        int resultShift = 0;
        int i = 0;
        while (i < subexpressions.length) {
            block11: {
                ICPPEvaluation newEval;
                ICPPEvaluation origEval;
                block8: {
                    block6: {
                        int packSize;
                        ICPPEvaluation pattern;
                        block10: {
                            block9: {
                                block7: {
                                    origEval = subexpressions[i];
                                    if (!(origEval instanceof EvalParameterPack)) break block6;
                                    pattern = ((EvalParameterPack)origEval).getExpansionPattern();
                                    if (pattern != null) break block7;
                                    newEval = EvalFixed.INCOMPLETE;
                                    break block8;
                                }
                                packSize = pattern.determinePackSize(tpMap);
                                if (packSize != -2 && packSize != Integer.MAX_VALUE) break block9;
                                newEval = EvalFixed.INCOMPLETE;
                                break block8;
                            }
                            if (packSize != -1) break block10;
                            newEval = origEval;
                            break block8;
                        }
                        int shift = packSize - 1;
                        ICPPEvaluation[] newResult = new ICPPEvaluation[subexpressions.length + resultShift + shift];
                        System.arraycopy(result, 0, newResult, 0, i + resultShift);
                        int j = 0;
                        while (j < packSize) {
                            newResult[i + resultShift + j] = newEval = pattern.instantiate(tpMap, j, within, maxdepth, point);
                            ++j;
                        }
                        result = newResult;
                        resultShift += shift;
                        break block11;
                    }
                    newEval = origEval.instantiate(tpMap, packOffset, within, maxdepth, point);
                }
                if (result != subexpressions) {
                    result[i + resultShift] = newEval;
                } else if (newEval != origEval) {
                    assert (resultShift == 0);
                    result = new ICPPEvaluation[subexpressions.length];
                    System.arraycopy(subexpressions, 0, result, 0, i);
                    result[i] = newEval;
                }
            }
            ++i;
        }
        return result;
    }

    private static class DeferredResolutionBinding
    extends PlatformObject
    implements IBinding {
        private final IASTName fName;

        public DeferredResolutionBinding(IASTName name) {
            this.fName = name;
        }

        public IBinding resolve() {
            return this.fName.resolveBinding();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public char[] getNameCharArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ILinkage getLinkage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IBinding getOwner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IScope getScope() throws DOMException {
            throw new UnsupportedOperationException();
        }
    }
}

