/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.EFSExtensionProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class EFSExtensionManager {
    private DefaultProvider fDefaultProvider = new DefaultProvider();
    private static EFSExtensionManager instance;
    private Map<String, EFSExtensionProvider> fSchemeToExtensionProviderMap = new HashMap<String, EFSExtensionProvider>();
    private static String EXTENSION_ID;

    static {
        EXTENSION_ID = "EFSExtensionProvider";
    }

    private EFSExtensionManager() {
        this.loadExtensions();
    }

    private void loadExtensions() {
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.core", EXTENSION_ID);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension2 = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension2.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    String scheme = configElement.getAttribute("scheme");
                    String utility = configElement.getAttribute("class");
                    if (utility != null) {
                        try {
                            Object execExt = configElement.createExecutableExtension("class");
                            if (execExt instanceof EFSExtensionProvider) {
                                this.fSchemeToExtensionProviderMap.put(scheme, (EFSExtensionProvider)execExt);
                            }
                        }
                        catch (CoreException e) {
                            CCorePlugin.log(e);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public static synchronized EFSExtensionManager getDefault() {
        if (instance == null) {
            instance = new EFSExtensionManager();
        }
        return instance;
    }

    public String getPathFromURI(URI locationURI) {
        EFSExtensionProvider provider = this.fSchemeToExtensionProviderMap.get(locationURI.getScheme());
        if (provider == null) {
            provider = this.fDefaultProvider;
        }
        return provider.getPathFromURI(locationURI);
    }

    public URI getLinkedURI(URI locationURI) {
        EFSExtensionProvider provider = this.fSchemeToExtensionProviderMap.get(locationURI.getScheme());
        if (provider == null) {
            provider = this.fDefaultProvider;
        }
        return provider.getLinkedURI(locationURI);
    }

    public URI createNewURIFromPath(URI locationOnSameFilesystem, String path) {
        URI uri = locationOnSameFilesystem;
        EFSExtensionProvider provider = this.fSchemeToExtensionProviderMap.get(uri.getScheme());
        if (provider == null) {
            return this.fDefaultProvider.createNewURIFromPath(uri, path);
        }
        return provider.createNewURIFromPath(uri, path);
    }

    public String getMappedPath(URI locationURI) {
        URI uri = locationURI;
        EFSExtensionProvider provider = this.fSchemeToExtensionProviderMap.get(uri.getScheme());
        if (provider == null) {
            provider = this.fDefaultProvider;
        }
        return provider.getMappedPath(uri);
    }

    public boolean isVirtual(URI locationURI) {
        EFSExtensionProvider provider = this.fSchemeToExtensionProviderMap.get(locationURI.getScheme());
        if (provider == null) {
            provider = this.fDefaultProvider;
        }
        return provider.isVirtual(locationURI);
    }

    public URI append(URI baseURI, String extension) {
        EFSExtensionProvider provider = this.fSchemeToExtensionProviderMap.get(baseURI.getScheme());
        if (provider == null) {
            provider = this.fDefaultProvider;
        }
        return provider.append(baseURI, extension);
    }

    private class DefaultProvider
    extends EFSExtensionProvider {
        private DefaultProvider() {
        }
    }
}

